/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.handler;

import FeatureCompletionModel.ComplementumVisnetis;
import FeatureCompletionModel.CompletionComponent;
import FeatureCompletionModel.FeatureCompletion;
import FeatureCompletionModel.PerimeterProviding;
import de.uka.ipd.sdq.dsexplore.tools.primitives.Pair;
import de.uka.ipd.sdq.dsexplore.tools.stereotypeapi.StereotypeAPIHelper;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.FCCUtil;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.port.FCCWeaverException;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.handler.FeatureHelper;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.manager.SolutionManager;
import featureObjective.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RepositoryComponent;

public class FCCFeatureHandler {
    private final SolutionManager solutionManager;

    public FCCFeatureHandler(SolutionManager mergedRepoManager) {
        this.solutionManager = mergedRepoManager;
    }

    public List<ProvidedRole> getProvidedFeaturesOf(CompletionComponent fcc) throws FCCWeaverException {
        List<Feature> providedFCCFeatures = this.getFeaturesProvidedBy(fcc);
        ArrayList<ProvidedRole> result = new ArrayList<ProvidedRole>();
        for (Pair<Entity, ComplementumVisnetis> partAndCV : this.extractProvidedCVs()) {
            if (!this.hasFeature(((ComplementumVisnetis)partAndCV.second).getComplementaryFeature(), providedFCCFeatures)) continue;
            if (partAndCV.first instanceof OperationInterface) {
                for (RepositoryComponent comps : this.solutionManager.getRepository().getComponents__Repository()) {
                    for (ProvidedRole provided : comps.getProvidedRoles_InterfaceProvidingEntity()) {
                        if (!(provided instanceof OperationProvidedRole) || !FCCUtil.areEqual((EObject)((OperationProvidedRole)provided).getProvidedInterface__OperationProvidedRole(), (EObject)partAndCV.first) || result.contains(provided)) continue;
                        result.add(provided);
                    }
                }
                continue;
            }
            if (partAndCV.first instanceof OperationSignature) {
                OperationInterface parentPartAndCVFirst = (OperationInterface)((Entity)partAndCV.first).eContainer();
                for (RepositoryComponent comps : this.solutionManager.getRepository().getComponents__Repository()) {
                    for (ProvidedRole provided : comps.getProvidedRoles_InterfaceProvidingEntity()) {
                        if (!(provided instanceof OperationProvidedRole) || !FCCUtil.areEqual((EObject)((OperationProvidedRole)provided).getProvidedInterface__OperationProvidedRole(), (EObject)parentPartAndCVFirst) || result.contains(provided)) continue;
                        result.add(provided);
                    }
                }
                continue;
            }
            if (!(partAndCV.first instanceof RepositoryComponent)) continue;
            RepositoryComponent rc = (RepositoryComponent)partAndCV.first;
            for (ProvidedRole provided : rc.getProvidedRoles_InterfaceProvidingEntity()) {
                if (result.contains(provided)) continue;
                result.add(provided);
            }
        }
        return result;
    }

    private boolean hasFeature(Feature feature, List<Feature> providedFCCFeatures) {
        for (Feature f : providedFCCFeatures) {
            if (!FCCUtil.areEqual((EObject)feature, (EObject)f)) continue;
            return true;
        }
        return false;
    }

    public CompletionComponent getPerimeterProvidingFCCFor(List<ComplementumVisnetis> selectedCVs, FeatureCompletion fc) throws FCCWeaverException {
        List selectedFeatures = selectedCVs.stream().map(selectedCV -> selectedCV.getComplementaryFeature()).collect(Collectors.toList());
        CompletionComponent fcc = null;
        for (CompletionComponent fccCurrent : fc.getCompletionComponents()) {
            EList providedFeatures = fccCurrent.getPerimeterProviding().getFeatureProviding();
            if (!selectedFeatures.stream().allMatch(arg_0 -> FCCFeatureHandler.lambda$1((List)providedFeatures, arg_0))) continue;
            fcc = fccCurrent;
            return fcc;
        }
        return fcc;
    }

    public List<OperationSignature> getPerimeterProvidedRolesFor(CompletionComponent completionComponent, List<ComplementumVisnetis> selectedCVs, FeatureCompletion fc) {
        ArrayList<OperationSignature> result = new ArrayList<OperationSignature>();
        List<RepositoryComponent> components = this.solutionManager.getAffectedComponentsByFCCList(Arrays.asList(completionComponent));
        RepositoryComponent component = this.solutionManager.getComponentFullfillingCV(components, selectedCVs);
        List fullfilledByComponentCVs = StereotypeAPIHelper.getViaStereoTypeFrom((EObject)component, ComplementumVisnetis.class);
        if (SolutionManager.anyCVcontainedInList(fullfilledByComponentCVs, selectedCVs)) {
            result.addAll(component.getProvidedRoles_InterfaceProvidingEntity().stream().flatMap(role -> ((OperationProvidedRole)role).getProvidedInterface__OperationProvidedRole().getSignatures__OperationInterface().stream()).collect(Collectors.toList()));
        }
        for (OperationInterface iface : component.getProvidedRoles_InterfaceProvidingEntity().stream().map(role -> ((OperationProvidedRole)role).getProvidedInterface__OperationProvidedRole()).collect(Collectors.toList())) {
            List fullfilledByInterfaceCVs = StereotypeAPIHelper.getViaStereoTypeFrom((EObject)iface, ComplementumVisnetis.class);
            if (SolutionManager.anyCVcontainedInList(fullfilledByInterfaceCVs, selectedCVs)) {
                result.addAll((Collection<OperationSignature>)iface.getSignatures__OperationInterface());
            }
            for (OperationSignature sig : iface.getSignatures__OperationInterface()) {
                List fullfilledBySignatureCVs = StereotypeAPIHelper.getViaStereoTypeFrom((EObject)sig, ComplementumVisnetis.class);
                if (!SolutionManager.anyCVcontainedInList(fullfilledBySignatureCVs, selectedCVs)) continue;
                result.add(sig);
            }
        }
        return result;
    }

    public List<Pair<Entity, ComplementumVisnetis>> extractProvidedCVs() {
        return FeatureHelper.getCVsFromRepo(this.solutionManager.getRepository());
    }

    private List<Feature> getFeaturesProvidedBy(CompletionComponent fcc) throws FCCWeaverException {
        PerimeterProviding pp = fcc.getPerimeterProviding();
        if (pp == null) {
            throw new FCCWeaverException("No suitable amount of features provided: NIL");
        }
        EList features = pp.getFeatureProviding();
        if (features.size() == 0) {
            throw new FCCWeaverException("No suitable amount of features provided: " + features.size());
        }
        return features;
    }

    private static /* synthetic */ boolean lambda$1(List list, Feature selectedFeature) {
        return list.stream().anyMatch(providedFeature -> providedFeature.getId().equals(selectedFeature.getId()));
    }
}

