/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.behaviour;

import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.behaviour.IBehaviourWeaving;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.behaviour.IWeavingInstruction;
import featureSolution.Appearance;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.SeffFactory;
import org.palladiosimulator.pcm.seff.StartAction;
import org.palladiosimulator.pcm.seff.StopAction;

public abstract class ServiceEffectSpecificationWeaving {
    private final SeffFactory seffFactory = SeffFactory.eINSTANCE;
    protected final IBehaviourWeaving parent;

    public ServiceEffectSpecificationWeaving(IBehaviourWeaving parent) {
        this.parent = parent;
    }

    public abstract void weave(IWeavingInstruction var1);

    protected void addFCCallTo(ResourceDemandingBehaviour seff, AbstractAction internalAction, Appearance appears, List<OperationSignature> list) {
        AbstractAction predecessor = internalAction.getPredecessor_AbstractAction();
        AbstractAction successor = internalAction.getSuccessor_AbstractAction();
        switch (appears) {
            case BEFORE: {
                this.addFCBetween(predecessor, internalAction, this.createExternalCallAction(list, internalAction), seff);
                break;
            }
            case AFTER: {
                this.addFCBetween(internalAction, successor, this.createExternalCallAction(list, internalAction), seff);
                break;
            }
            case AROUND: {
                this.addFCBetween(predecessor, internalAction, this.createExternalCallAction(list, internalAction), seff);
                this.addFCBetween(internalAction, successor, this.createExternalCallAction(list, internalAction), seff);
                break;
            }
        }
    }

    protected OperationRequiredRole getFcRequiredRole(AbstractAction internalAction, OperationInterface operationInterface) {
        BasicComponent comp = null;
        EObject container = internalAction.eContainer();
        while (!(container instanceof BasicComponent)) {
            container = container.eContainer();
        }
        comp = (BasicComponent)container;
        for (RequiredRole requiredRole : comp.getRequiredRoles_InterfaceRequiringEntity()) {
            if (!((OperationRequiredRole)requiredRole).getRequiredInterface__OperationRequiredRole().getId().equals(operationInterface.getId())) continue;
            return (OperationRequiredRole)requiredRole;
        }
        return null;
    }

    List<ExternalCallAction> createExternalCallAction(List<OperationSignature> list, AbstractAction internalAction) {
        ArrayList<ExternalCallAction> externalCallActions = new ArrayList<ExternalCallAction>();
        for (OperationSignature sig : list) {
            ExternalCallAction externalCallAction = this.seffFactory.createExternalCallAction();
            OperationSignature calledService = sig;
            externalCallAction.setEntityName(calledService.getEntityName());
            externalCallAction.setCalledService_ExternalService(calledService);
            OperationRequiredRole fcRequiredRole = this.getFcRequiredRole(internalAction, sig.getInterface__OperationSignature());
            externalCallAction.setRole_ExternalService(fcRequiredRole);
            externalCallActions.add(externalCallAction);
        }
        return externalCallActions;
    }

    void addFCBetween(AbstractAction previous, AbstractAction next, List<ExternalCallAction> list, ResourceDemandingBehaviour seff) {
        for (ExternalCallAction externalCallAction : list) {
            this.addFCAfter(previous, externalCallAction, seff);
        }
    }

    void addFCAfter(AbstractAction action, ExternalCallAction externalCall, ResourceDemandingBehaviour seff) {
        seff.getSteps_Behaviour().add((Object)externalCall);
        AbstractAction next = action.getSuccessor_AbstractAction();
        action.setSuccessor_AbstractAction((AbstractAction)externalCall);
        externalCall.setPredecessor_AbstractAction(action);
        externalCall.setSuccessor_AbstractAction(next);
        next.setPredecessor_AbstractAction((AbstractAction)externalCall);
    }

    protected void addFCCallToSEFF(IWeavingInstruction instruction, ResourceDemandingBehaviour seff) {
        if (instruction.getAdvice().getAppears() == Appearance.BEFORE) {
            AbstractAction start = this.getStartAction((List<AbstractAction>)seff.getSteps_Behaviour());
            this.addFCCallTo(seff, start, Appearance.AFTER, (List)instruction.getFccWithProvidedRole().getSecond());
        } else if (instruction.getAdvice().getAppears() == Appearance.AFTER) {
            AbstractAction stop = this.getStopAction((List<AbstractAction>)seff.getSteps_Behaviour());
            this.addFCCallTo(seff, stop, Appearance.BEFORE, (List)instruction.getFccWithProvidedRole().getSecond());
        } else if (instruction.getAdvice().getAppears() == Appearance.AROUND) {
            AbstractAction start = this.getStartAction((List<AbstractAction>)seff.getSteps_Behaviour());
            AbstractAction stop = this.getStopAction((List<AbstractAction>)seff.getSteps_Behaviour());
            this.addFCCallTo(seff, start, Appearance.AFTER, (List)instruction.getFccWithProvidedRole().getSecond());
            this.addFCCallTo(seff, stop, Appearance.BEFORE, (List)instruction.getFccWithProvidedRole().getSecond());
        }
    }

    private AbstractAction getStopAction(List<AbstractAction> steps) {
        return steps.stream().filter(action -> action instanceof StopAction).findFirst().get();
    }

    private AbstractAction getStartAction(List<AbstractAction> steps) {
        return steps.stream().filter(action -> action instanceof StartAction).findFirst().get();
    }
}

