/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.handler;

import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.handler.OperationRoleHandler;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.handler.RoleHandler;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.handler.SinkSourceRoleHandler;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.manager.SolutionManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.Role;
import org.palladiosimulator.pcm.repository.SinkRole;
import org.palladiosimulator.pcm.repository.SourceRole;

public class RoleHandlerFactory {
    private static final HashMap<Predicate<Role>, Function<SolutionManager, RoleHandler>> roleHandlerMap = new HashMap();

    static {
        roleHandlerMap.put(RoleHandlerFactory.isOperationRole(), mergedRepoManager -> new OperationRoleHandler((SolutionManager)mergedRepoManager));
        roleHandlerMap.put(RoleHandlerFactory.isSinkOrSourceRole(), mergedRepoManager -> new SinkSourceRoleHandler((SolutionManager)mergedRepoManager));
    }

    public static Optional<RoleHandler> getBy(Role role, SolutionManager mergedRepoManager) {
        for (Map.Entry<Predicate<Role>, Function<SolutionManager, RoleHandler>> current : roleHandlerMap.entrySet()) {
            if (!current.getKey().test(role)) continue;
            return Optional.of(current.getValue().apply(mergedRepoManager));
        }
        return Optional.empty();
    }

    private static Predicate<Role> isOperationRole() {
        return role -> RoleHandlerFactory.isOperationRequiredRole(role) || RoleHandlerFactory.isOperationProvidedRole(role);
    }

    private static Predicate<Role> isSinkOrSourceRole() {
        return role -> RoleHandlerFactory.isSinkRole(role) || RoleHandlerFactory.isSourceRole(role);
    }

    private static boolean isSinkRole(Role role) {
        return role instanceof SinkRole;
    }

    private static boolean isSourceRole(Role role) {
        return role instanceof SourceRole;
    }

    private static boolean isOperationProvidedRole(Role role) {
        return role instanceof OperationProvidedRole;
    }

    private static boolean isOperationRequiredRole(Role role) {
        return role instanceof OperationRequiredRole;
    }
}

