/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.manager;

import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter.ServiceEffectSpecificationWeaving;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.EventType;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.repository.SourceRole;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.EmitEventAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.SeffFactory;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.seff.SetVariableAction;
import org.palladiosimulator.pcm.seff.StartAction;
import org.palladiosimulator.pcm.seff.StopAction;

public class PcmServiceEffectSpecificationManager {
    private static final String START_ACTION_NAME = "start";
    private static final String STOP_ACTION_NAME = "stop";
    private SeffFactory seffFactory = SeffFactory.eINSTANCE;

    public void addServiceEffectSpecificationTo(BasicComponent component, ServiceEffectSpecification seff) {
        for (ServiceEffectSpecification s : component.getServiceEffectSpecifications__BasicComponent()) {
            if (!Objects.equals(seff.getDescribedService__SEFF().getId(), s.getDescribedService__SEFF().getId())) continue;
            return;
        }
        component.getServiceEffectSpecifications__BasicComponent().add((Object)seff);
    }

    public ServiceEffectSpecification createServiceEffectSpecificationFor(Signature signature) {
        ResourceDemandingSEFF seff = this.seffFactory.createResourceDemandingSEFF();
        seff.setDescribedService__SEFF(signature);
        return seff;
    }

    public ServiceEffectSpecification addExternalCallActionPipeBy(List<ServiceEffectSpecificationWeaving.ExternalCallInfo> orderedExternalCallInfoSequence, ServiceEffectSpecification seff) {
        ((ResourceDemandingBehaviour)seff).getSteps_Behaviour().addAll(this.toAbstractActions(orderedExternalCallInfoSequence));
        return seff;
    }

    private List<AbstractAction> toAbstractActions(List<ServiceEffectSpecificationWeaving.ExternalCallInfo> orderedExternalCallInfoSequence) {
        ArrayList<AbstractAction> unlinkedActions = new ArrayList<AbstractAction>();
        unlinkedActions.add(this.getStartAction());
        unlinkedActions.addAll(this.toExternalCallActions(orderedExternalCallInfoSequence));
        unlinkedActions.add(this.getStopAction());
        return this.establishLinksBetween(unlinkedActions);
    }

    private List<AbstractAction> establishLinksBetween(List<AbstractAction> unlinkedActions) {
        int size = unlinkedActions.size();
        int i = 0;
        while (i < size) {
            AbstractAction predeccessor = null;
            AbstractAction successor = null;
            AbstractAction current = unlinkedActions.get(i);
            if (this.isStartAction(i)) {
                predeccessor = null;
                successor = unlinkedActions.get(i + 1);
            } else if (this.isStopAction(i, size)) {
                predeccessor = unlinkedActions.get(i - 1);
                successor = null;
            } else {
                predeccessor = unlinkedActions.get(i - 1);
                successor = unlinkedActions.get(i + 1);
            }
            current.setPredecessor_AbstractAction(predeccessor);
            current.setSuccessor_AbstractAction(successor);
            ++i;
        }
        return unlinkedActions;
    }

    private boolean isStartAction(int i) {
        return i == 0;
    }

    private boolean isStopAction(int i, int size) {
        return i == size - 1;
    }

    private List<AbstractAction> toExternalCallActions(List<ServiceEffectSpecificationWeaving.ExternalCallInfo> orderedExternalCallInfoSequence) {
        ArrayList<AbstractAction> result = new ArrayList<AbstractAction>();
        for (ServiceEffectSpecificationWeaving.ExternalCallInfo info : orderedExternalCallInfoSequence) {
            for (AbstractAction action : this.createAbstractExternalActionCallOf(info)) {
                result.add(action);
            }
        }
        return result;
    }

    private AbstractAction getStopAction() {
        StopAction stopAction = this.seffFactory.createStopAction();
        stopAction.setEntityName(STOP_ACTION_NAME);
        return stopAction;
    }

    private AbstractAction getStartAction() {
        StartAction startAction = this.seffFactory.createStartAction();
        startAction.setEntityName(START_ACTION_NAME);
        return startAction;
    }

    private List<AbstractAction> createAbstractExternalActionCallOf(ServiceEffectSpecificationWeaving.ExternalCallInfo externalCallInfo) {
        ArrayList<AbstractAction> abstractActions = new ArrayList<AbstractAction>();
        if (externalCallInfo.requiredRole instanceof OperationRequiredRole) {
            abstractActions.add(this.createExternalActionCallOf(externalCallInfo));
        } else {
            abstractActions.add(this.createEmitEventActionOf(externalCallInfo));
        }
        abstractActions.addAll(this.getSetVariableActionsFrom(externalCallInfo.setVariableActions));
        return abstractActions;
    }

    private List<SetVariableAction> getSetVariableActionsFrom(List<SetVariableAction> setVariableActions) {
        return setVariableActions.stream().map(each -> (SetVariableAction)EcoreUtil.copy((EObject)each)).collect(Collectors.toList());
    }

    private AbstractAction createExternalActionCallOf(ServiceEffectSpecificationWeaving.ExternalCallInfo externalCallInfo) {
        OperationSignature calledService = (OperationSignature)externalCallInfo.calledService;
        ExternalCallAction externalCallAction = this.seffFactory.createExternalCallAction();
        externalCallAction.setEntityName(calledService.getEntityName());
        externalCallAction.setCalledService_ExternalService(calledService);
        externalCallAction.setRole_ExternalService((OperationRequiredRole)externalCallInfo.requiredRole);
        externalCallAction.getInputVariableUsages__CallAction().addAll(this.copy(externalCallInfo.inputVariableUsages));
        externalCallAction.getReturnVariableUsage__CallReturnAction().addAll(this.copy(externalCallInfo.returnVariableUsage));
        return externalCallAction;
    }

    private AbstractAction createEmitEventActionOf(ServiceEffectSpecificationWeaving.ExternalCallInfo externalCallInfo) {
        EventType emittedEvent = (EventType)externalCallInfo.calledService;
        EmitEventAction emitEventAction = this.seffFactory.createEmitEventAction();
        emitEventAction.setEntityName(emittedEvent.getEntityName());
        emitEventAction.setEventType__EmitEventAction(emittedEvent);
        emitEventAction.setSourceRole__EmitEventAction((SourceRole)externalCallInfo.requiredRole);
        emitEventAction.getInputVariableUsages__CallAction().addAll(this.copy(externalCallInfo.inputVariableUsages));
        return emitEventAction;
    }

    private List<VariableUsage> copy(List<VariableUsage> variableUsages) {
        ArrayList<VariableUsage> copy = new ArrayList<VariableUsage>();
        for (VariableUsage eachVariableUsage : variableUsages) {
            copy.add((VariableUsage)EcoreUtil.copy((EObject)eachVariableUsage));
        }
        return copy;
    }
}

