/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.are.dsexplore.featurecompletions.weaver.util;

import FeatureCompletionModel.ComplementumVisnetis;
import de.uka.ipd.sdq.dsexplore.tools.primitives.Pair;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.port.FCCWeaverException;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.WeavingLocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.solver.core.models.PCMInstance;

public final class LocationExtractor {
    public static List<WeavingLocation> extractLocation(Pair<String, ComplementumVisnetis> connector, PCMInstance pcm) {
        Connector connectorInstance = LocationExtractor.getConnector(pcm, (String)connector.first);
        return LocationExtractor.extractWeavingLocationFromInterface(connectorInstance, pcm);
    }

    private static List<WeavingLocation> extractWeavingLocationFromInterface(Connector conn, PCMInstance pcm) {
        ArrayList<WeavingLocation> result = new ArrayList<WeavingLocation>();
        result.addAll(LocationExtractor.extractWeavingLocationsFromProvidedInterface(conn, pcm));
        result.addAll(LocationExtractor.extractWeavingLocationsFromRequiredInterface(conn, pcm));
        ArrayList<? extends OperationSignature> osis = new ArrayList<OperationSignature>();
        for (WeavingLocation wlocs : result) {
            osis.addAll(wlocs.getAffectedSignatures());
        }
        WeavingLocation merged = new WeavingLocation(osis, conn);
        return Arrays.asList(merged);
    }

    private static List<WeavingLocation> extractWeavingLocationsFromProvidedInterface(Connector conn, PCMInstance pcm) {
        if (conn instanceof AssemblyConnector) {
            return LocationExtractor.handleAssemblyConnectorProvidesSide((AssemblyConnector)conn, pcm);
        }
        if (conn instanceof ProvidedDelegationConnector) {
            return LocationExtractor.handleProvidedDelegationConnectorProvidesSide((ProvidedDelegationConnector)conn, pcm);
        }
        throw new FCCWeaverException("Unknown Connector!");
    }

    private static List<WeavingLocation> extractWeavingLocationsFromRequiredInterface(Connector conn, PCMInstance pcm) {
        if (conn instanceof AssemblyConnector) {
            return LocationExtractor.handleAssemblyConnectorRequiresSide((AssemblyConnector)conn, pcm);
        }
        if (conn instanceof ProvidedDelegationConnector) {
            return LocationExtractor.handleProvidedDelegationConnectorRequiresSide((ProvidedDelegationConnector)conn, pcm);
        }
        throw new FCCWeaverException("Unknown Connector!");
    }

    private static List<WeavingLocation> handleProvidedDelegationConnectorRequiresSide(ProvidedDelegationConnector conn, PCMInstance pcm) {
        ArrayList<WeavingLocation> result = new ArrayList<WeavingLocation>();
        EList osis = conn.getInnerProvidedRole_ProvidedDelegationConnector().getProvidedInterface__OperationProvidedRole().getSignatures__OperationInterface();
        result.add(new WeavingLocation((List<? extends OperationSignature>)osis, (Connector)conn));
        return result;
    }

    private static List<WeavingLocation> handleProvidedDelegationConnectorProvidesSide(ProvidedDelegationConnector conn, PCMInstance pcm) {
        ArrayList<WeavingLocation> result = new ArrayList<WeavingLocation>();
        EList osis = conn.getOuterProvidedRole_ProvidedDelegationConnector().getProvidedInterface__OperationProvidedRole().getSignatures__OperationInterface();
        result.add(new WeavingLocation((List<? extends OperationSignature>)osis, (Connector)conn));
        return result;
    }

    private static List<WeavingLocation> handleAssemblyConnectorRequiresSide(AssemblyConnector conn, PCMInstance pcm) {
        ArrayList<WeavingLocation> result = new ArrayList<WeavingLocation>();
        EList osis = conn.getRequiredRole_AssemblyConnector().getRequiredInterface__OperationRequiredRole().getSignatures__OperationInterface();
        result.add(new WeavingLocation((List<? extends OperationSignature>)osis, (Connector)conn));
        return result;
    }

    private static List<WeavingLocation> handleAssemblyConnectorProvidesSide(AssemblyConnector conn, PCMInstance pcm) {
        ArrayList<WeavingLocation> result = new ArrayList<WeavingLocation>();
        EList osis = conn.getProvidedRole_AssemblyConnector().getProvidedInterface__OperationProvidedRole().getSignatures__OperationInterface();
        result.add(new WeavingLocation((List<? extends OperationSignature>)osis, (Connector)conn));
        return result;
    }

    private static Connector getConnector(PCMInstance pcm, String connectorID) {
        for (Connector connector : pcm.getSystem().getConnectors__ComposedStructure()) {
            if (!connector.getId().equals(connectorID)) continue;
            return connector;
        }
        return null;
    }
}

