/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter.util;

import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.ErrorMessage;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.port.FCCWeaverException;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter.util.AssemblyConnectorGenerator;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter.util.AssemblyEventConnectorGenerator;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter.util.ConnectionInfo;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter.util.ConnectorGenerator;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter.util.IConnectorGeneratorExploration;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.manager.PcmSystemManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ConnectorGeneratorExplorationFactory {
    private Set<IConnectorGeneratorExploration> explorableGenerators;

    public ConnectorGeneratorExplorationFactory(PcmSystemManager pcmSystemManager) {
        this.initialize(pcmSystemManager);
    }

    private void initialize(PcmSystemManager pcmSystemManager) {
        this.explorableGenerators = new HashSet<IConnectorGeneratorExploration>();
        this.explorableGenerators.add(new AssemblyConnectorGenerator(pcmSystemManager));
        this.explorableGenerators.add(new AssemblyEventConnectorGenerator(pcmSystemManager));
    }

    public ConnectorGenerator getApplicableConnectorGeneratorBy(ConnectionInfo connectionInfo) throws FCCWeaverException {
        List<IConnectorGeneratorExploration> generators = this.getMatches(connectionInfo);
        if (this.isValidResult(generators)) {
            return (ConnectorGenerator)((Object)generators.get(0));
        }
        throw new FCCWeaverException(ErrorMessage.unsupportedConnector());
    }

    private List<IConnectorGeneratorExploration> getMatches(ConnectionInfo connectionInfo) {
        ArrayList<IConnectorGeneratorExploration> result = new ArrayList<IConnectorGeneratorExploration>();
        for (IConnectorGeneratorExploration explore : this.explorableGenerators) {
            if (!explore.canBeApplied(connectionInfo)) continue;
            result.add(explore);
        }
        return result;
    }

    private boolean isValidResult(List<IConnectorGeneratorExploration> generators) {
        return generators.size() == 1;
    }
}

