/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.handler;

import FeatureCompletionModel.CompletionComponent;
import FeatureCompletionModel.impl.ComplementumImpl;
import de.uka.ipd.sdq.dsexplore.tools.stereotypeapi.StereotypeAPIHelper;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.manager.SolutionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.RepositoryComponent;

public class FCCStructureHandler {
    private final CompletionComponent fcc;
    private final SolutionManager mergedRepoManager;

    public FCCStructureHandler(CompletionComponent fcc, SolutionManager mergedRepoManager) {
        this.fcc = fcc;
        this.mergedRepoManager = mergedRepoManager;
    }

    public List<RepositoryComponent> getAffectedComponents() {
        return this.getAllAssociatedFCCs(false);
    }

    public List<CompletionComponent> getFCCsRequiredBy(CompletionComponent fcc) {
        ArrayList<CompletionComponent> result = new ArrayList<CompletionComponent>();
        if (!fcc.getRequiredComponents().isEmpty()) {
            EList requiredFCCs = fcc.getRequiredComponents();
            result.addAll((Collection<CompletionComponent>)requiredFCCs);
            for (CompletionComponent completionComponent : requiredFCCs) {
                result.addAll(this.getFCCsRequiredBy(completionComponent));
            }
        }
        return result;
    }

    public <T> List<T> getStructureOfFCCAndRequiredAccordingTo(Function<RepositoryComponent, List<T>> resolvingFunction) {
        ArrayList<T> structure = new ArrayList<T>();
        for (RepositoryComponent c : this.getAllAssociatedFCCs(true)) {
            List<T> ls = resolvingFunction.apply(c);
            for (T t : ls) {
                structure.add(t);
            }
        }
        return structure;
    }

    private List<RepositoryComponent> getAllAssociatedFCCs(boolean considerRequired) {
        return this.mergedRepoManager.getAffectedComponentsByFCCList(this.getAnnotationsOfECC(considerRequired));
    }

    private List<CompletionComponent> getAnnotationsOfECC(boolean considerRequired) {
        return !considerRequired ? Arrays.asList(this.fcc) : this.resolveAllFCCsOf(this.fcc);
    }

    private List<CompletionComponent> resolveAllFCCsOf(CompletionComponent fcc) {
        ArrayList<CompletionComponent> result = new ArrayList<CompletionComponent>();
        LinkedList<CompletionComponent> queue = new LinkedList<CompletionComponent>();
        queue.add(fcc);
        while (!queue.isEmpty()) {
            CompletionComponent peek = (CompletionComponent)queue.poll();
            result.add(peek);
            queue.addAll((Collection<CompletionComponent>)peek.getRequiredComponents());
            queue.removeIf(e -> result.contains(e));
        }
        return result;
    }

    public boolean requiresComplementa(List<RepositoryComponent> realizingComponents) {
        return realizingComponents.stream().anyMatch(component -> !StereotypeAPIHelper.getViaStereoTypeFrom((EObject)component, ComplementumImpl.class).stream().filter(compl -> compl.getClass().equals(ComplementumImpl.class)).collect(Collectors.toList()).isEmpty());
    }

    public List<RepositoryComponent> getRequiredComplementa(List<RepositoryComponent> realizingComponents) {
        ArrayList<RepositoryComponent> result = new ArrayList<RepositoryComponent>();
        for (RepositoryComponent repositoryComponent : realizingComponents) {
            List<Object> requiredComplementa = new ArrayList();
            List requiredComplementaByComponent = StereotypeAPIHelper.getViaStereoTypeFrom((EObject)repositoryComponent, ComplementumImpl.class);
            List requiredComplementaByInterface = repositoryComponent.getProvidedRoles_InterfaceProvidingEntity().stream().flatMap(role -> StereotypeAPIHelper.getViaStereoTypeFrom((EObject)((OperationProvidedRole)role).getProvidedInterface__OperationProvidedRole(), ComplementumImpl.class).stream()).collect(Collectors.toList());
            List requiredComplementaBySignature = repositoryComponent.getProvidedRoles_InterfaceProvidingEntity().stream().flatMap(role -> ((OperationProvidedRole)role).getProvidedInterface__OperationProvidedRole().getSignatures__OperationInterface().stream()).flatMap(signature -> StereotypeAPIHelper.getViaStereoTypeFrom((EObject)signature, ComplementumImpl.class).stream()).collect(Collectors.toList());
            requiredComplementa.addAll(requiredComplementaByComponent);
            requiredComplementa.addAll(requiredComplementaByInterface);
            requiredComplementa.addAll(requiredComplementaBySignature);
            requiredComplementa = requiredComplementa.stream().filter(compl -> compl.getClass().equals(ComplementumImpl.class)).collect(Collectors.toList());
            if (requiredComplementa.isEmpty()) continue;
            for (ComplementumImpl complementumImpl : requiredComplementa) {
                result.add(this.mergedRepoManager.getFulfillingComponentForComplementum(complementumImpl));
            }
        }
        return result;
    }

    public AssemblyContext getComponentsIntantiatingFCC(CompletionComponent fcc, List<AssemblyContext> contexts) {
        for (AssemblyContext ac : contexts) {
            List fccs = StereotypeAPIHelper.getViaStereoTypeFrom((EObject)ac.getEncapsulatedComponent__AssemblyContext(), CompletionComponent.class);
            if (fccs.size() != 1 || !((CompletionComponent)fccs.get(0)).getId().equals(fcc.getId())) continue;
            return ac;
        }
        return null;
    }
}

