/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.manager;

import de.uka.ipd.sdq.dsexplore.tools.primitives.Pair;
import de.uka.ipd.sdq.dsexplore.tools.stereotypeapi.EcoreReferenceResolver;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.FCCUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.AssemblyEventConnector;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.core.composition.RequiredDelegationConnector;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.Role;
import org.palladiosimulator.pcm.repository.SinkRole;
import org.palladiosimulator.pcm.repository.SourceRole;
import org.palladiosimulator.pcm.system.System;

public class PcmSystemManager {
    private System system;

    public PcmSystemManager(System system) {
        this.system = system;
    }

    public List<Connector> getConnectorsBy(Predicate<Connector> searchCriteria) {
        ArrayList<Connector> result = new ArrayList<Connector>();
        for (Connector c : this.getAllConnectors()) {
            if (!searchCriteria.test(c)) continue;
            result.add(c);
        }
        return result;
    }

    public boolean existConnector(Connector searchedConnector) {
        for (Connector c : this.getAllConnectors()) {
            if (!this.areEqual(c, searchedConnector)) continue;
            return true;
        }
        return false;
    }

    public boolean existConnectors(List<Connector> searchedConnectors) {
        for (Connector c : searchedConnectors) {
            if (this.existConnector(c)) continue;
            return false;
        }
        return true;
    }

    private boolean areEqual(Connector givenConnector, Connector searchedConnector) {
        if (!givenConnector.getClass().equals(searchedConnector.getClass())) {
            return false;
        }
        return this.hasEqualRoles(this.getRolesOf(searchedConnector), this.getRolesOf(givenConnector));
    }

    private boolean hasEqualRoles(List<Role> searchedConnectorRoles, List<Role> givenConnectorRoles) {
        if (searchedConnectorRoles.size() != givenConnectorRoles.size()) {
            return false;
        }
        int i = 0;
        while (i < searchedConnectorRoles.size()) {
            if (!searchedConnectorRoles.get(i).equals(givenConnectorRoles.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private List<Role> getRolesOf(Connector connector) {
        return new EcoreReferenceResolver((EObject)connector).getCrossReferencedElementsOfType(Role.class);
    }

    public void remove(Connector connectorToRemove) {
        this.system.getConnectors__ComposedStructure().remove((Object)connectorToRemove);
    }

    private List<Connector> getAllConnectors() {
        return this.system.getConnectors__ComposedStructure();
    }

    public Optional<AssemblyContext> getAssemblyContextBy(Predicate<AssemblyContext> searchCriteria) {
        for (AssemblyContext ac : this.getAllAssemblyContexts()) {
            if (!searchCriteria.test(ac)) continue;
            return Optional.of(ac);
        }
        return Optional.empty();
    }

    public List<AssemblyContext> getAssemblyContextsBy(Predicate<AssemblyContext> searchCriteria) {
        ArrayList<AssemblyContext> result = new ArrayList<AssemblyContext>();
        for (AssemblyContext ac : this.getAllAssemblyContexts()) {
            if (!searchCriteria.test(ac)) continue;
            result.add(ac);
        }
        return result;
    }

    public List<AssemblyContext> getAssemblyContextsInstantiating(RepositoryComponent component) {
        ArrayList<AssemblyContext> result = new ArrayList<AssemblyContext>();
        for (AssemblyContext ac : this.getAllAssemblyContexts()) {
            RepositoryComponent ec = ac.getEncapsulatedComponent__AssemblyContext();
            if (!FCCUtil.areEqual((EObject)ec, (EObject)component)) continue;
            result.add(ac);
        }
        return result;
    }

    private List<AssemblyContext> getAllAssemblyContexts() {
        return this.system.getAssemblyContexts__ComposedStructure();
    }

    public void addAssemblyContext(AssemblyContext assemblyContextToAdd) {
        this.system.getAssemblyContexts__ComposedStructure().add((Object)assemblyContextToAdd);
    }

    public void addAssemblyContexts(List<AssemblyContext> assemblyContextsToAdd) {
        this.system.getAssemblyContexts__ComposedStructure().addAll(assemblyContextsToAdd);
    }

    public void addConnectors(Connector ... connectorsToAdd) {
        this.addConnectors(Arrays.asList(connectorsToAdd));
    }

    public void addConnectors(List<Connector> connectorsToAdd) {
        this.system.getConnectors__ComposedStructure().addAll(connectorsToAdd);
    }

    public ProvidedDelegationConnector createProvidedDelegationConnectorBy(OperationProvidedRole outerProvidedRole, Pair<OperationProvidedRole, AssemblyContext> providedPair) {
        AssemblyContext assemblyContext = (AssemblyContext)providedPair.getSecond();
        String delegationConnectorName = assemblyContext.getEncapsulatedComponent__AssemblyContext().getEntityName();
        ProvidedDelegationConnector delegationConnector = CompositionFactory.eINSTANCE.createProvidedDelegationConnector();
        delegationConnector.setEntityName(String.format("%1sProvidedDelegationConnector", delegationConnectorName));
        delegationConnector.setInnerProvidedRole_ProvidedDelegationConnector((OperationProvidedRole)providedPair.getFirst());
        delegationConnector.setOuterProvidedRole_ProvidedDelegationConnector(outerProvidedRole);
        delegationConnector.setAssemblyContext_ProvidedDelegationConnector(assemblyContext);
        return delegationConnector;
    }

    public RequiredDelegationConnector createRequiredDelegationConnectorBy(OperationRequiredRole outerRequiredRole, Pair<OperationRequiredRole, AssemblyContext> requiredPair) {
        AssemblyContext assemblyContext = (AssemblyContext)requiredPair.getSecond();
        String delegationConnectorName = assemblyContext.getEncapsulatedComponent__AssemblyContext().getEntityName();
        RequiredDelegationConnector delegationConnector = CompositionFactory.eINSTANCE.createRequiredDelegationConnector();
        delegationConnector.setEntityName(String.format("%1sRequiredDelegationConnector", delegationConnectorName));
        delegationConnector.setInnerRequiredRole_RequiredDelegationConnector((OperationRequiredRole)requiredPair.getFirst());
        delegationConnector.setOuterRequiredRole_RequiredDelegationConnector(outerRequiredRole);
        delegationConnector.setAssemblyContext_RequiredDelegationConnector(assemblyContext);
        return delegationConnector;
    }

    public AssemblyConnector createAssemblyConnectorBy(Pair<OperationRequiredRole, AssemblyContext> requiredPair, Pair<OperationProvidedRole, AssemblyContext> providedPair) {
        String requiredComponentName = ((AssemblyContext)requiredPair.getSecond()).getEncapsulatedComponent__AssemblyContext().getEntityName();
        String providedComponentName = ((AssemblyContext)providedPair.getSecond()).getEncapsulatedComponent__AssemblyContext().getEntityName();
        AssemblyConnector assemblyConnector = CompositionFactory.eINSTANCE.createAssemblyConnector();
        assemblyConnector.setEntityName(String.format("%1sTo%2sConnector", requiredComponentName, providedComponentName));
        assemblyConnector.setRequiredRole_AssemblyConnector((OperationRequiredRole)requiredPair.getFirst());
        assemblyConnector.setRequiringAssemblyContext_AssemblyConnector((AssemblyContext)requiredPair.getSecond());
        assemblyConnector.setProvidedRole_AssemblyConnector((OperationProvidedRole)providedPair.getFirst());
        assemblyConnector.setProvidingAssemblyContext_AssemblyConnector((AssemblyContext)providedPair.getSecond());
        return assemblyConnector;
    }

    public AssemblyEventConnector createAssemblyEventConnectorBy(Pair<SourceRole, AssemblyContext> requiredPair, Pair<SinkRole, AssemblyContext> providedPair) {
        String requiredComponentName = ((AssemblyContext)requiredPair.getSecond()).getEncapsulatedComponent__AssemblyContext().getEntityName();
        String providedComponentName = ((AssemblyContext)providedPair.getSecond()).getEncapsulatedComponent__AssemblyContext().getEntityName();
        AssemblyEventConnector assemblyEventConnector = CompositionFactory.eINSTANCE.createAssemblyEventConnector();
        assemblyEventConnector.setEntityName(String.format("%1sTo%2sConnector", requiredComponentName, providedComponentName));
        assemblyEventConnector.setSourceRole__AssemblyEventConnector((SourceRole)requiredPair.getFirst());
        assemblyEventConnector.setSourceAssemblyContext__AssemblyEventConnector((AssemblyContext)requiredPair.getSecond());
        assemblyEventConnector.setSinkRole__AssemblyEventConnector((SinkRole)providedPair.getFirst());
        assemblyEventConnector.setSinkAssemblyContext__AssemblyEventConnector((AssemblyContext)providedPair.getSecond());
        return assemblyEventConnector;
    }

    public List<AssemblyContext> createAssemblyContextsOf(List<RepositoryComponent> components) {
        ArrayList<AssemblyContext> result = new ArrayList<AssemblyContext>();
        for (RepositoryComponent c : components) {
            AssemblyContext ac = this.createAssemblyContextOf(c);
            result.add(ac);
        }
        return result;
    }

    public AssemblyContext createAssemblyContextOf(RepositoryComponent component) {
        AssemblyContext componentAssemblyContext = CompositionFactory.eINSTANCE.createAssemblyContext();
        componentAssemblyContext.setEncapsulatedComponent__AssemblyContext(component);
        componentAssemblyContext.setEntityName(String.format("%1sInstance", component.getEntityName()));
        return componentAssemblyContext;
    }

    public AssemblyContext createAssemblyContextOf(RepositoryComponent component, String name) {
        AssemblyContext componentAssemblyContext = CompositionFactory.eINSTANCE.createAssemblyContext();
        componentAssemblyContext.setEncapsulatedComponent__AssemblyContext(component);
        componentAssemblyContext.setEntityName(name);
        return componentAssemblyContext;
    }

    public AssemblyContext createAndAddAssemblyContextOf(RepositoryComponent component) {
        AssemblyContext assemblyContext = this.createAssemblyContextOf(component);
        this.addAssemblyContext(assemblyContext);
        return assemblyContext;
    }
}

