/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.manager;

import FeatureCompletionModel.Complementum;
import FeatureCompletionModel.ComplementumVisnetis;
import FeatureCompletionModel.CompletionComponent;
import FeatureCompletionModel.impl.ComplementumImpl;
import de.uka.ipd.sdq.dsexplore.tools.stereotypeapi.StereotypeAPIHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.osgi.framework.hooks.weaving.WeavingException;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.ComponentType;
import org.palladiosimulator.pcm.repository.EventGroup;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.SinkRole;
import org.palladiosimulator.pcm.repository.SourceRole;

public final class SolutionManager {
    private Repository solution = null;

    public SolutionManager(Repository solution) {
        this.solution = solution;
    }

    public Optional<RepositoryComponent> getComponentByName(String name) {
        for (RepositoryComponent c : this.solution.getComponents__Repository()) {
            if (!c.getEntityName().equals(name)) continue;
            return Optional.of(c);
        }
        return Optional.empty();
    }

    public List<RepositoryComponent> getAffectedComponentsByFCCList(List<CompletionComponent> fccs) {
        HashSet<RepositoryComponent> affectedComponents = new HashSet<RepositoryComponent>();
        for (RepositoryComponent rcs : this.solution.getComponents__Repository()) {
            List realizedCCs = StereotypeAPIHelper.getViaStereoTypeFrom((EObject)rcs, CompletionComponent.class);
            if (!this.anyContainedInList(realizedCCs, fccs)) continue;
            affectedComponents.add(rcs);
        }
        return new ArrayList<RepositoryComponent>(affectedComponents);
    }

    public List<RepositoryComponent> getRealizingComponentsByFCCList(List<CompletionComponent> fccs, List<OperationSignature> providedSigs, List<ComplementumVisnetis> cvs) {
        ArrayList<RepositoryComponent> affectedComponents = new ArrayList<RepositoryComponent>();
        for (CompletionComponent completionComponent : fccs) {
            ArrayList<RepositoryComponent> realizingComponents = new ArrayList<RepositoryComponent>();
            for (RepositoryComponent rcs : this.solution.getComponents__Repository()) {
                List realizedCCs = StereotypeAPIHelper.getViaStereoTypeFrom((EObject)rcs, CompletionComponent.class);
                if (!this.anyContainedInList(realizedCCs, Arrays.asList(completionComponent))) continue;
                realizingComponents.add(rcs);
            }
            RepositoryComponent component = this.getComponentFullfillingCV(realizingComponents, cvs);
            affectedComponents.add(component);
        }
        return affectedComponents;
    }

    public RepositoryComponent getComponentFullfillingCV(List<RepositoryComponent> realizingComponents, List<ComplementumVisnetis> cvs) {
        for (RepositoryComponent repositoryComponent : realizingComponents) {
            List fullfilledByComponentCVs = StereotypeAPIHelper.getViaStereoTypeFrom((EObject)repositoryComponent, ComplementumVisnetis.class);
            List<ComplementumVisnetis> fullfilledByInterfaceCVs = repositoryComponent.getProvidedRoles_InterfaceProvidingEntity().stream().flatMap(role -> StereotypeAPIHelper.getViaStereoTypeFrom((EObject)((OperationProvidedRole)role).getProvidedInterface__OperationProvidedRole(), ComplementumVisnetis.class).stream()).collect(Collectors.toList());
            List<ComplementumVisnetis> fullfilledBySignatureCVs = repositoryComponent.getProvidedRoles_InterfaceProvidingEntity().stream().flatMap(role -> ((OperationProvidedRole)role).getProvidedInterface__OperationProvidedRole().getSignatures__OperationInterface().stream()).flatMap(signature -> StereotypeAPIHelper.getViaStereoTypeFrom((EObject)signature, ComplementumVisnetis.class).stream()).collect(Collectors.toList());
            if (!SolutionManager.anyCVcontainedInList(fullfilledByComponentCVs, cvs) && !SolutionManager.anyCVcontainedInList(fullfilledByInterfaceCVs, cvs) && !SolutionManager.anyCVcontainedInList(fullfilledBySignatureCVs, cvs)) continue;
            return repositoryComponent;
        }
        throw new WeavingException("no realizing component for a cv in " + cvs.stream().map(cv -> cv.getName()).reduce((s1, s2) -> String.valueOf(s1) + "," + s2).get() + " found or ambigous components found in solution repo " + this.solution.getEntityName());
    }

    public static boolean anyCVcontainedInList(List<ComplementumVisnetis> fullfilledCVs, List<ComplementumVisnetis> cvs) {
        for (ComplementumVisnetis complementumVisnetis : fullfilledCVs) {
            if (!cvs.stream().anyMatch(cv -> cv.getId().equals(complementumVisnetis.getId()))) continue;
            return true;
        }
        return false;
    }

    private boolean anyContainedInList(List<CompletionComponent> realizedCCs, List<CompletionComponent> listToContainedIn) {
        for (CompletionComponent completionComponent : realizedCCs) {
            if (!listToContainedIn.contains(completionComponent)) continue;
            return true;
        }
        return false;
    }

    public RepositoryComponent createAndAddAdapter(String name) {
        BasicComponent adapter = this.createAdapter(name);
        this.solution.getComponents__Repository().add((Object)adapter);
        return adapter;
    }

    private BasicComponent createAdapter(String name) {
        BasicComponent adapter = RepositoryFactory.eINSTANCE.createBasicComponent();
        adapter.setComponentType(ComponentType.BUSINESS_COMPONENT);
        adapter.setEntityName(name);
        return adapter;
    }

    public RequiredRole createRequiredRoleBy(OperationProvidedRole providedRole) {
        OperationInterface referencedInterface = providedRole.getProvidedInterface__OperationProvidedRole();
        OperationRequiredRole requiredRole = RepositoryFactory.eINSTANCE.createOperationRequiredRole();
        requiredRole.setEntityName(String.format("requires%2s", referencedInterface.getEntityName()));
        requiredRole.setRequiredInterface__OperationRequiredRole(referencedInterface);
        return requiredRole;
    }

    public RequiredRole createRequiredRoleBy(OperationSignature signature) {
        OperationInterface referencedInterface = signature.getInterface__OperationSignature();
        OperationRequiredRole requiredRole = RepositoryFactory.eINSTANCE.createOperationRequiredRole();
        requiredRole.setEntityName(String.format("requires%2s", referencedInterface.getEntityName()));
        requiredRole.setRequiredInterface__OperationRequiredRole(referencedInterface);
        return requiredRole;
    }

    public RequiredRole createRequiredRoleBy(SinkRole sinkRole) {
        EventGroup referencedEventGroup = sinkRole.getEventGroup__SinkRole();
        SourceRole sourceRole = RepositoryFactory.eINSTANCE.createSourceRole();
        sourceRole.setEntityName(String.format("sourceOf%2s", referencedEventGroup.getEntityName()));
        sourceRole.setEventGroup__SourceRole(referencedEventGroup);
        return sourceRole;
    }

    public ProvidedRole createProvidedRoleBy(OperationRequiredRole requiredRole) {
        OperationInterface referencedInterface = requiredRole.getRequiredInterface__OperationRequiredRole();
        OperationProvidedRole providedRole = RepositoryFactory.eINSTANCE.createOperationProvidedRole();
        providedRole.setEntityName(String.format("provides%2s", referencedInterface.getEntityName()));
        providedRole.setProvidedInterface__OperationProvidedRole(referencedInterface);
        return providedRole;
    }

    public ProvidedRole createProvidedRoleBy(SourceRole sourceRole) {
        EventGroup referencedInterface = sourceRole.getEventGroup__SourceRole();
        SinkRole sinkRole = RepositoryFactory.eINSTANCE.createSinkRole();
        sinkRole.setEntityName(String.format("provides%2s", referencedInterface.getEntityName()));
        sinkRole.setEventGroup__SinkRole(referencedInterface);
        return sinkRole;
    }

    public ProvidedRole createProvidedRoleBy(OperationProvidedRole providedRole, String name) {
        OperationInterface referencedInterface = providedRole.getProvidedInterface__OperationProvidedRole();
        OperationProvidedRole newProvidedRole = RepositoryFactory.eINSTANCE.createOperationProvidedRole();
        newProvidedRole.setEntityName(String.format("%1s_%2s", providedRole.getEntityName(), name));
        newProvidedRole.setProvidedInterface__OperationProvidedRole(referencedInterface);
        return newProvidedRole;
    }

    public List<ProvidedRole> getAllProvidedRoles() {
        ArrayList<ProvidedRole> prs = new ArrayList<ProvidedRole>();
        for (RepositoryComponent c : this.solution.getComponents__Repository()) {
            EList role = c.getProvidedRoles_InterfaceProvidingEntity();
            prs.addAll((Collection<ProvidedRole>)role);
        }
        return prs;
    }

    public Repository getRepository() {
        return this.solution;
    }

    public RepositoryComponent getFulfillingComponentForComplementum(ComplementumImpl complementum) {
        for (RepositoryComponent c : this.solution.getComponents__Repository()) {
            for (ProvidedRole role : c.getProvidedRoles_InterfaceProvidingEntity()) {
                List complementa = StereotypeAPIHelper.getViaStereoTypeFrom((EObject)((OperationProvidedRole)role).getProvidedInterface__OperationProvidedRole(), Complementum.class);
                if (complementa.isEmpty() || !((Complementum)complementa.get(0)).getId().equals(complementum.getId())) continue;
                return c;
            }
        }
        return null;
    }
}

