/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter;

import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.port.FCCWeaverException;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter.AssemblyWeaving;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter.IAdapterWeaving;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter.util.AssemblyConnectorGenerator;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter.util.ConnectionInfo;
import java.util.List;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Role;

public class AssemblyLocationWeaving
extends AssemblyWeaving {
    public AssemblyLocationWeaving(IAdapterWeaving parent) {
        super(parent);
    }

    @Override
    public void weaveAdapterIntoSystem(Connector weavingLocation) throws FCCWeaverException {
        this.replace((AssemblyConnector)weavingLocation);
    }

    private void replace(AssemblyConnector assemblyConnectorToReplace) throws FCCWeaverException {
        this.parent.getPCMSystemManager().remove((Connector)assemblyConnectorToReplace);
        this.replaceWithAssemblyConnectorsToAdapter(assemblyConnectorToReplace);
    }

    private void replaceWithAssemblyConnectorsToAdapter(AssemblyConnector assemblyConnectorToReplace) throws FCCWeaverException {
        this.createAssemblyConnectorFromAdapterToProvidedEndOf(assemblyConnectorToReplace);
        this.createAssemblyConnectorFromRequiredEndToAdapter(assemblyConnectorToReplace);
    }

    private void createAssemblyConnectorFromAdapterToProvidedEndOf(AssemblyConnector assemblyConnectorToReplace) throws FCCWeaverException {
        OperationProvidedRole providedRole = assemblyConnectorToReplace.getProvidedRole_AssemblyConnector();
        RequiredRole requiredRole = (RequiredRole)this.getComplimentaryRoleOf((Role)providedRole, this.getRequiredRolesOfAdapter());
        AssemblyContext providedAssemblyContext = assemblyConnectorToReplace.getProvidingAssemblyContext_AssemblyConnector();
        ConnectionInfo connectionInfo = new ConnectionInfo((Role)requiredRole, (Role)providedRole, this.parent.getAdapterAssemblyContext(), providedAssemblyContext);
        Connector newConnector = new AssemblyConnectorGenerator(this.parent.getPCMSystemManager()).createConnectorBy(connectionInfo);
        newConnector.setId(assemblyConnectorToReplace.getId());
        this.addConnector(newConnector);
    }

    private void createAssemblyConnectorFromRequiredEndToAdapter(AssemblyConnector assemblyConnectorToReplace) throws FCCWeaverException {
        OperationRequiredRole requiredRole = assemblyConnectorToReplace.getRequiredRole_AssemblyConnector();
        ProvidedRole providedRole = (ProvidedRole)this.getComplimentaryRoleOf((Role)requiredRole, this.getProvidedRolesOfAdapter());
        AssemblyContext requiredAssemblyContext = assemblyConnectorToReplace.getRequiringAssemblyContext_AssemblyConnector();
        ConnectionInfo connectionInfo = new ConnectionInfo((Role)requiredRole, (Role)providedRole, requiredAssemblyContext, this.parent.getAdapterAssemblyContext());
        Connector newConnector = new AssemblyConnectorGenerator(this.parent.getPCMSystemManager()).createConnectorBy(connectionInfo);
        newConnector.setId(String.valueOf(assemblyConnectorToReplace.getId()) + "-requiredEnd");
        this.addConnector(newConnector);
    }

    private List<ProvidedRole> getProvidedRolesOfAdapter() {
        return this.parent.getAdapterComponent().getProvidedRoles_InterfaceProvidingEntity();
    }
}

