/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter;

import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.ErrorMessage;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.FCCUtil;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.port.FCCWeaverException;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.WeavingInstruction;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter.IAdapterWeaving;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.handler.RoleHandler;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.handler.RoleHandlerFactory;
import java.util.List;
import java.util.Optional;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Role;

public abstract class RepositoryWeaving {
    protected final IAdapterWeaving parent;

    public RepositoryWeaving(IAdapterWeaving parent) {
        this.parent = parent;
    }

    public void weave(WeavingInstruction weavingInstruction) throws FCCWeaverException {
        this.setAdapterComponentRegarding(weavingInstruction);
        this.connectAdapterTo((List)weavingInstruction.getFCCWithConsumedFeatures().getSecond());
        this.weaveAdapterIntoRepository(weavingInstruction.getWeavingLocation());
    }

    private void setAdapterComponentRegarding(WeavingInstruction weavingInstruction) {
        String uniqueAdapterName = FCCUtil.createUniqueAdapterNameBy(weavingInstruction.getWeavingLocation());
        if (weavingInstruction.getInclusionMechanism().isMultiple()) {
            this.parent.setAdapter(this.parent.getSolutionManager().createAndAddAdapter(uniqueAdapterName));
        } else {
            this.parent.setAdapter(this.getOrCreateAdapterComponent(uniqueAdapterName));
        }
    }

    private RepositoryComponent getOrCreateAdapterComponent(String name) {
        return this.getExistingAdapter(name).orElseGet(() -> this.parent.getSolutionManager().createAndAddAdapter(name));
    }

    private Optional<RepositoryComponent> getExistingAdapter(String name) {
        return this.parent.getSolutionManager().getComponentByName(name);
    }

    private void connectAdapterTo(List<ProvidedRole> providedECCFeatures) throws FCCWeaverException {
        for (ProvidedRole eachProvidedFeature : providedECCFeatures) {
            RequiredRole complimentaryRequiredRole = this.createComplimentaryRequiredRoleOf(eachProvidedFeature);
            if (!this.isNotAlreadyContainedInAdapter(complimentaryRequiredRole)) continue;
            this.parent.getAdapterComponent().getRequiredRoles_InterfaceRequiringEntity().add((Object)complimentaryRequiredRole);
        }
    }

    private RequiredRole createComplimentaryRequiredRoleOf(ProvidedRole providedRole) throws FCCWeaverException {
        RoleHandler roleHandler = RoleHandlerFactory.getBy((Role)providedRole, this.parent.getSolutionManager()).orElseThrow(() -> new FCCWeaverException(ErrorMessage.unsupportedRole()));
        return roleHandler.createRequiredRoleOf(providedRole);
    }

    protected boolean isNotAlreadyContainedInAdapter(RequiredRole requiredRole) {
        RepositoryComponent rc = this.parent.getAdapterComponent();
        for (RequiredRole role : rc.getRequiredRoles_InterfaceRequiringEntity()) {
            if (!role.getEntityName().equals(requiredRole.getEntityName())) continue;
            return false;
        }
        return true;
    }

    protected boolean isNotAlreadyContainedInAdapter(ProvidedRole providedRole) {
        RepositoryComponent rc = this.parent.getAdapterComponent();
        for (ProvidedRole role : rc.getProvidedRoles_InterfaceProvidingEntity()) {
            if (!role.getEntityName().equals(providedRole.getEntityName())) continue;
            return false;
        }
        return true;
    }

    protected abstract void weaveAdapterIntoRepository(Connector var1);
}

