/*
 * Decompiled with CFR 0.152.
 */
package featureSolution;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ControlFlow implements Enumerator
{
    LOOP(0, "LOOP", "LOOP"),
    BRANCH(1, "BRANCH", "BRANCH");

    public static final int LOOP_VALUE = 0;
    public static final int BRANCH_VALUE = 1;
    private static final ControlFlow[] VALUES_ARRAY;
    public static final List<ControlFlow> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ControlFlow[]{LOOP, BRANCH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ControlFlow get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ControlFlow result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ControlFlow getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ControlFlow result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ControlFlow get(int value) {
        switch (value) {
            case 0: {
                return LOOP;
            }
            case 1: {
                return BRANCH;
            }
        }
        return null;
    }

    private ControlFlow(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

