/*
 * Decompiled with CFR 0.152.
 */
package featureSolution;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Appearance implements Enumerator
{
    BEFORE(0, "BEFORE", "BEFORE"),
    AFTER(1, "AFTER", "AFTER"),
    AROUND(2, "AROUND", "AROUND");

    public static final int BEFORE_VALUE = 0;
    public static final int AFTER_VALUE = 1;
    public static final int AROUND_VALUE = 2;
    private static final Appearance[] VALUES_ARRAY;
    public static final List<Appearance> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Appearance[]{BEFORE, AFTER, AROUND};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Appearance get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Appearance result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Appearance getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Appearance result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Appearance get(int value) {
        switch (value) {
            case 0: {
                return BEFORE;
            }
            case 1: {
                return AFTER;
            }
            case 2: {
                return AROUND;
            }
        }
        return null;
    }

    private Appearance(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

