/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.analysis.qes;

import FeatureCompletionModel.ComplementumVisnetis;
import de.uka.ipd.sdq.dsexplore.analysis.qes.DirectedGraph;
import de.uka.ipd.sdq.dsexplore.analysis.qes.QesHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.modelversioning.emfprofile.Stereotype;
import org.modelversioning.emfprofileapplication.StereotypeApplication;
import org.palladiosimulator.mdsdprofiles.api.StereotypeAPI;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.core.composition.impl.AssemblyConnectorImpl;
import org.palladiosimulator.pcm.core.composition.impl.ProvidedDelegationConnectorImpl;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.CompositeComponent;
import org.palladiosimulator.pcm.repository.InfrastructureProvidedRole;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.subsystem.SubSystem;
import org.palladiosimulator.qes.qualityEffectSpecification.Annotation;
import org.palladiosimulator.qes.qualityEffectSpecification.Assembly;
import org.palladiosimulator.qes.qualityEffectSpecification.AssemblyType;
import org.palladiosimulator.qes.qualityEffectSpecification.ComponentProperty;
import org.palladiosimulator.qes.qualityEffectSpecification.ComponentSpecification;
import org.palladiosimulator.qes.qualityEffectSpecification.ComponentType;
import org.palladiosimulator.qes.qualityEffectSpecification.Identifier;
import org.palladiosimulator.qes.qualityEffectSpecification.Name;
import org.palladiosimulator.qes.qualityEffectSpecification.Resource;
import org.palladiosimulator.qes.qualityEffectSpecification.ResourceProperty;
import org.palladiosimulator.qes.qualityEffectSpecification.Role;
import org.palladiosimulator.qes.qualityEffectSpecification.RoleProperty;
import org.palladiosimulator.qes.qualityEffectSpecification.RoleType;
import org.palladiosimulator.qes.qualityEffectSpecification.Type;
import org.palladiosimulator.solver.core.models.PCMInstance;

public class QesFinder {
    private final DirectedGraph<RepositoryComponent> componentGraph;
    private final Set<RepositoryComponent> infrastructure;
    private final Map<ResourceContainer, Set<RepositoryComponent>> serverMap;
    private final Map<String, Set<RepositoryComponent>> annotationMap;

    private static DirectedGraph<RepositoryComponent> getComponentGraph(PCMInstance instance) {
        DirectedGraph<RepositoryComponent> componentGraph = new DirectedGraph<RepositoryComponent>();
        for (Connector c : instance.getSystem().getConnectors__ComposedStructure()) {
            if (!(c instanceof AssemblyConnectorImpl)) continue;
            AssemblyConnectorImpl ac = (AssemblyConnectorImpl)c;
            componentGraph.addEdge(ac.getRequiringAssemblyContext_AssemblyConnector().getEncapsulatedComponent__AssemblyContext(), ac.getProvidingAssemblyContext_AssemblyConnector().getEncapsulatedComponent__AssemblyContext());
        }
        return componentGraph;
    }

    private static Set<RepositoryComponent> getInfrastructureRolls(PCMInstance instance) {
        HashSet<RepositoryComponent> components = new HashSet<RepositoryComponent>();
        for (Connector c : instance.getSystem().getConnectors__ComposedStructure()) {
            if (!(c instanceof ProvidedDelegationConnectorImpl)) continue;
            ProvidedDelegationConnectorImpl dc = (ProvidedDelegationConnectorImpl)c;
            AssemblyContext sc = dc.getAssemblyContext_ProvidedDelegationConnector();
            RepositoryComponent rc = sc.getEncapsulatedComponent__AssemblyContext();
            components.add(rc);
        }
        return Collections.unmodifiableSet(components);
    }

    private static Set<Entity> getRolesEntities(RepositoryComponent component) {
        HashSet<Entity> effectedComponents = new HashSet<Entity>();
        component.getProvidedRoles_InterfaceProvidingEntity().forEach(effectedComponents::add);
        component.getRequiredRoles_InterfaceRequiringEntity().forEach(effectedComponents::add);
        return effectedComponents;
    }

    private static Map<ResourceContainer, Set<RepositoryComponent>> getServerMap(PCMInstance instance) {
        HashMap<ResourceContainer, Set<RepositoryComponent>> serverMap = new HashMap<ResourceContainer, Set<RepositoryComponent>>();
        for (AllocationContext allocationContext : instance.getAllocation().getAllocationContexts_Allocation()) {
            ResourceContainer container = allocationContext.getResourceContainer_AllocationContext();
            RepositoryComponent component = allocationContext.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext();
            if (serverMap.containsKey(container)) {
                ((Set)serverMap.get(container)).add(component);
                continue;
            }
            HashSet<RepositoryComponent> componentSet = new HashSet<RepositoryComponent>();
            componentSet.add(component);
            serverMap.put(container, componentSet);
        }
        return serverMap;
    }

    private static boolean isComponentProvided(RepositoryComponent component) {
        if (component == null || component.getProvidedRoles_InterfaceProvidingEntity() == null) {
            return false;
        }
        for (ProvidedRole role : component.getProvidedRoles_InterfaceProvidingEntity()) {
            if (role == null || !(role instanceof OperationProvidedRole)) continue;
            return true;
        }
        return false;
    }

    private static boolean isComponentRequired(RepositoryComponent component) {
        if (component == null || component.getRequiredRoles_InterfaceRequiringEntity() == null) {
            return false;
        }
        for (RequiredRole role : component.getRequiredRoles_InterfaceRequiringEntity()) {
            if (role == null || !(role instanceof OperationRequiredRole)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInfrastructureProvided(RepositoryComponent component) {
        if (component == null || component.getProvidedRoles_InterfaceProvidingEntity() == null) {
            return false;
        }
        for (ProvidedRole role : component.getProvidedRoles_InterfaceProvidingEntity()) {
            if (role == null || !(role instanceof InfrastructureProvidedRole)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInfrastructureRequired(RepositoryComponent component) {
        if (component == null || component.getRequiredRoles_InterfaceRequiringEntity() == null) {
            return false;
        }
        for (RequiredRole role : component.getRequiredRoles_InterfaceRequiringEntity()) {
            if (role == null || !(role instanceof InfrastructureRequiredRole)) continue;
            return true;
        }
        return false;
    }

    public QesFinder(PCMInstance instance) {
        this.componentGraph = QesFinder.getComponentGraph(instance);
        System.err.println(this.componentGraph);
        this.serverMap = QesFinder.getServerMap(instance);
        System.err.println(this.serverMap);
        this.infrastructure = QesFinder.getInfrastructureRolls(instance);
        System.err.println(this.infrastructure);
        this.annotationMap = QesFinder.getAnnotationMap(instance);
        System.err.println(this.annotationMap);
    }

    private static void put(Map<String, Set<RepositoryComponent>> annotationMap, Set<String> annotations, RepositoryComponent component) {
        if (annotations == null || annotations.isEmpty()) {
            return;
        }
        for (String annotation : annotations) {
            if (annotation == null || annotation.length() == 0) continue;
            if (annotationMap.containsKey(annotation)) {
                annotationMap.get(annotation).add(component);
                continue;
            }
            HashSet<RepositoryComponent> components = new HashSet<RepositoryComponent>();
            components.add(component);
            annotationMap.put(annotation, components);
        }
    }

    private static void put(Map<String, Set<RepositoryComponent>> annotationMap, RepositoryComponent component) {
        QesFinder.put(annotationMap, QesFinder.getAnnotatios((EObject)component), component);
    }

    private static void put(Map<String, Set<RepositoryComponent>> annotationMap, AssemblyConnectorImpl connector) {
        Set<String> annotations = QesFinder.getAnnotatios((EObject)connector);
        RepositoryComponent requiring = connector.getRequiringAssemblyContext_AssemblyConnector().getEncapsulatedComponent__AssemblyContext();
        QesFinder.put(annotationMap, annotations, requiring);
        QesFinder.put(annotationMap, requiring);
        RepositoryComponent providing = connector.getProvidingAssemblyContext_AssemblyConnector().getEncapsulatedComponent__AssemblyContext();
        QesFinder.put(annotationMap, annotations, providing);
        QesFinder.put(annotationMap, providing);
    }

    private static void put(Map<String, Set<RepositoryComponent>> annotationMap, ProvidedDelegationConnectorImpl connector) {
        Set<String> annotations = QesFinder.getAnnotatios((EObject)connector);
        RepositoryComponent providing = connector.getAssemblyContext_ProvidedDelegationConnector().getEncapsulatedComponent__AssemblyContext();
        QesFinder.put(annotationMap, annotations, providing);
        QesFinder.put(annotationMap, providing);
    }

    private static Map<String, Set<RepositoryComponent>> getAnnotationMap(PCMInstance instance) {
        HashMap<String, Set<RepositoryComponent>> annotations = new HashMap<String, Set<RepositoryComponent>>();
        for (Connector connector : instance.getSystem().getConnectors__ComposedStructure()) {
            if (connector instanceof AssemblyConnectorImpl) {
                QesFinder.put(annotations, (AssemblyConnectorImpl)connector);
                continue;
            }
            if (!(connector instanceof ProvidedDelegationConnectorImpl)) continue;
            QesFinder.put(annotations, (ProvidedDelegationConnectorImpl)connector);
        }
        return Collections.unmodifiableMap(annotations);
    }

    private static Set<String> getAnnotatios(EObject object) {
        if (!StereotypeAPI.hasStereotypeApplications((EObject)object)) {
            return Collections.emptySet();
        }
        HashSet<String> annotatios = new HashSet<String>();
        for (StereotypeApplication application : StereotypeAPI.getStereotypeApplications((EObject)object)) {
            annotatios.add(application.getStereotype().getName());
        }
        return Collections.unmodifiableSet(annotatios);
    }

    private Set<String> getComponents(Annotation annotation) {
        if (this.annotationMap == null || this.annotationMap.isEmpty() || annotation == null) {
            return Collections.emptySet();
        }
        String name = annotation.getAnnotation();
        if (name == null || name.length() == 0 || !this.annotationMap.containsKey(name)) {
            return Collections.emptySet();
        }
        HashSet<String> annotatedComponents = new HashSet<String>();
        for (RepositoryComponent component : this.annotationMap.get(name)) {
            annotatedComponents.add(component.getId());
        }
        boolean isNot = annotation.isNot();
        if (isNot) {
            HashSet<String> notAnnotatedComponents = new HashSet<String>();
            for (RepositoryComponent component : this.componentGraph) {
                String id = component.getId();
                if (annotatedComponents.contains(id)) continue;
                notAnnotatedComponents.add(id);
            }
            return Collections.unmodifiableSet(notAnnotatedComponents);
        }
        return Collections.unmodifiableSet(annotatedComponents);
    }

    private Set<String> getComponents(Assembly assembly) {
        HashSet<String> effectedComponents = new HashSet<String>();
        boolean isNot = assembly.isNot();
        AssemblyType type = assembly.getType();
        if (isNot && type == AssemblyType.ANY) {
            return effectedComponents;
        }
        Set<String> assemblyComponents = this.getComponents(assembly.getComponent());
        if (assemblyComponents.isEmpty()) {
            return effectedComponents;
        }
        boolean provided = true;
        boolean required = true;
        if (isNot && type == AssemblyType.PROVIDED || !isNot && type == AssemblyType.REQUIRED) {
            provided = false;
        } else if (isNot && type == AssemblyType.REQUIRED || !isNot && type == AssemblyType.PROVIDED) {
            required = false;
        }
        if (required) {
            for (RepositoryComponent component : this.componentGraph) {
                for (RepositoryComponent edge : this.componentGraph.edgesFrom(component)) {
                    boolean equals = false;
                    for (String id : assemblyComponents) {
                        if (!id.equalsIgnoreCase(edge.getId())) continue;
                        equals = true;
                        break;
                    }
                    if (!equals) continue;
                    effectedComponents.add(component.getId());
                }
            }
        }
        if (provided) {
            block3: for (RepositoryComponent component : this.componentGraph) {
                for (String id : assemblyComponents) {
                    if (!id.equalsIgnoreCase(component.getId())) continue;
                    for (RepositoryComponent edge : this.componentGraph.edgesFrom(component)) {
                        effectedComponents.add(edge.getId());
                    }
                    continue block3;
                }
            }
        }
        return effectedComponents;
    }

    private Set<RepositoryComponent> getComponents(boolean isNot, RoleType type) {
        HashSet<RepositoryComponent> effectedComponents = new HashSet<RepositoryComponent>();
        if (type == null || isNot && type == RoleType.ANY) {
            return effectedComponents;
        }
        if (isNot && type == RoleType.COMPONENT_REQUIRED_PROVIDED || !isNot && (type == RoleType.INFRASTRUCTURE_REQUIRED || type == RoleType.INFRASTRUCTURE_PROVIDED || type == RoleType.INFRASTRUCTURE_REQUIRED_PROVIDED)) {
            return this.infrastructure;
        }
        for (RepositoryComponent component : this.componentGraph) {
            if (type == RoleType.ANY) {
                effectedComponents.add(component);
                continue;
            }
            boolean isComponentProvided = QesFinder.isComponentProvided(component);
            boolean isComponentRequired = QesFinder.isComponentRequired(component);
            boolean isInfrastructureProvided = QesFinder.isInfrastructureProvided(component);
            boolean isInfrastructureRequired = QesFinder.isInfrastructureRequired(component);
            if (!isNot && isComponentProvided && (type == RoleType.COMPONENT_PROVIDED || type == RoleType.COMPONENT_REQUIRED_PROVIDED)) {
                effectedComponents.add(component);
                continue;
            }
            if (!isNot && isComponentRequired && (type == RoleType.COMPONENT_REQUIRED || type == RoleType.COMPONENT_REQUIRED_PROVIDED)) {
                effectedComponents.add(component);
                continue;
            }
            if (!isNot && isInfrastructureProvided && (type == RoleType.INFRASTRUCTURE_PROVIDED || type == RoleType.INFRASTRUCTURE_REQUIRED_PROVIDED)) {
                effectedComponents.add(component);
                continue;
            }
            if (!isNot && isInfrastructureRequired && (type == RoleType.INFRASTRUCTURE_REQUIRED || type == RoleType.INFRASTRUCTURE_REQUIRED_PROVIDED)) {
                effectedComponents.add(component);
                continue;
            }
            if (isNot && (type == RoleType.INFRASTRUCTURE_REQUIRED_PROVIDED || type == RoleType.INFRASTRUCTURE_REQUIRED || type == RoleType.INFRASTRUCTURE_PROVIDED) && (isComponentProvided || isComponentRequired)) {
                effectedComponents.add(component);
                continue;
            }
            if (!isNot || type != RoleType.COMPONENT_REQUIRED_PROVIDED && type != RoleType.COMPONENT_REQUIRED && type != RoleType.COMPONENT_PROVIDED || !isInfrastructureProvided && !isInfrastructureRequired) continue;
            effectedComponents.add(component);
        }
        return effectedComponents;
    }

    private Set<String> getComponents(ComponentProperty property) {
        HashSet<String> effectedComponents = new HashSet<String>();
        if (property == null) {
            return effectedComponents;
        }
        if (property instanceof Name) {
            return this.getComponents((Name)property);
        }
        if (property instanceof Identifier) {
            return this.getComponents((Identifier)property);
        }
        if (property instanceof Annotation) {
            return this.getComponents((Annotation)property);
        }
        if (property instanceof Type) {
            return this.getComponents((Type)property);
        }
        if (property instanceof Role) {
            return this.getComponents((Role)property);
        }
        if (property instanceof Assembly) {
            return this.getComponents((Assembly)property);
        }
        if (property instanceof Resource) {
            return this.getComponents((Resource)property);
        }
        return effectedComponents;
    }

    private Set<String> getComponents(ComponentSpecification componentSpecifications) {
        HashSet<String> effectedComponents = new HashSet<String>();
        if (componentSpecifications == null || componentSpecifications.getProperties() == null || componentSpecifications.getProperties().isEmpty()) {
            return effectedComponents;
        }
        for (ComponentProperty property : componentSpecifications.getProperties()) {
            if (effectedComponents.isEmpty()) {
                effectedComponents.addAll(this.getComponents(property));
            } else {
                effectedComponents.retainAll(this.getComponents(property));
            }
            if (effectedComponents.isEmpty()) break;
        }
        return effectedComponents;
    }

    private Set<String> getComponents(Identifier identifier) {
        HashSet<String> effectedComponents = new HashSet<String>();
        for (RepositoryComponent component : this.componentGraph) {
            if (!QesHelper.equalsIgnoreCase(component.getId(), identifier.isNot(), identifier.getId())) continue;
            effectedComponents.add(component.getId());
        }
        return effectedComponents;
    }

    private Set<String> getComponents(Name name) {
        HashSet<String> effectedComponents = new HashSet<String>();
        for (RepositoryComponent component : this.componentGraph) {
            if (!QesHelper.equalsIgnoreCase(component.getEntityName(), name.isNot(), name.getAutonym())) continue;
            effectedComponents.add(component.getId());
        }
        return effectedComponents;
    }

    private Set<String> getComponents(Resource resource) {
        HashSet<String> effectedComponents = new HashSet<String>();
        for (Entity entity : this.serverMap.keySet()) {
            for (ResourceProperty property : resource.getProperties()) {
                if (property instanceof Name) {
                    if (!QesHelper.equalsIgnoreCase(entity.getEntityName(), ((Name)property).isNot(), ((Name)property).getAutonym())) continue;
                    for (RepositoryComponent component : this.serverMap.get(entity)) {
                        effectedComponents.add(component.getId());
                    }
                    continue;
                }
                if (!(property instanceof Identifier) || !QesHelper.equalsIgnoreCase(entity.getId(), ((Identifier)property).isNot(), ((Identifier)property).getId())) continue;
                for (RepositoryComponent component : this.serverMap.get(entity)) {
                    effectedComponents.add(component.getId());
                }
            }
        }
        return effectedComponents;
    }

    private Set<String> getComponents(Role role) {
        HashSet<String> effectedComponents = new HashSet<String>();
        for (RepositoryComponent component : this.getComponents(role.isNot(), role.getType())) {
            if (role.getProperties() == null || role.getProperties().isEmpty()) {
                effectedComponents.add(component.getId());
                continue;
            }
            for (Entity entity : QesFinder.getRolesEntities(component)) {
                for (RoleProperty property : role.getProperties()) {
                    if (property instanceof Name && QesHelper.equalsIgnoreCase(entity.getEntityName(), ((Name)property).isNot(), ((Name)property).getAutonym())) {
                        effectedComponents.add(component.getId());
                    }
                    if (property instanceof Identifier && QesHelper.equalsIgnoreCase(entity.getId(), ((Identifier)property).isNot(), ((Identifier)property).getId())) {
                        effectedComponents.add(component.getId());
                    }
                    if (!(property instanceof Annotation) || !StereotypeAPI.hasStereotypeApplications((EObject)property)) continue;
                    for (Stereotype stereotype : StereotypeAPI.getAppliedStereotypes((EObject)property)) {
                        for (EObject refs : stereotype.eCrossReferences()) {
                            if (!(refs instanceof ComplementumVisnetis) || !QesHelper.equalsIgnoreCase(((ComplementumVisnetis)refs).getName(), ((Annotation)property).isNot(), ((Annotation)property).getAnnotation())) continue;
                            effectedComponents.add(component.getId());
                        }
                    }
                }
            }
        }
        return effectedComponents;
    }

    private Set<String> getComponents(Type type) {
        HashSet<String> effectedComponents = new HashSet<String>();
        boolean isNot = type.isNot();
        ComponentType componentType = type.getType();
        if (componentType == null || componentType == ComponentType.ANY && isNot) {
            return effectedComponents;
        }
        for (RepositoryComponent component : this.componentGraph) {
            if (componentType == ComponentType.ANY && !isNot) {
                effectedComponents.add(String.valueOf(component.getId()));
                continue;
            }
            if (componentType == ComponentType.BASIC && !isNot || componentType == ComponentType.COMPOSITE && isNot) {
                if (!(component instanceof BasicComponent)) continue;
                effectedComponents.add(String.valueOf(component.getId()));
                continue;
            }
            if ((componentType != ComponentType.COMPOSITE || isNot) && (componentType != ComponentType.BASIC || !isNot) || !(component instanceof CompositeComponent) && !(component instanceof SubSystem)) continue;
            effectedComponents.add(String.valueOf(component.getId()));
        }
        return effectedComponents;
    }

    public Set<String> getEffectedComponents(List<ComponentSpecification> componentsSpecifications) {
        HashSet<String> effectedComponents = new HashSet<String>();
        if (componentsSpecifications == null || componentsSpecifications.isEmpty()) {
            return Collections.unmodifiableSet(effectedComponents);
        }
        for (ComponentSpecification component : componentsSpecifications) {
            effectedComponents.addAll(this.getComponents(component));
        }
        return Collections.unmodifiableSet(effectedComponents);
    }
}

