/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.tcfmoop.config;

import de.uka.ipd.sdq.tcfmoop.config.AbstractConfiguration;
import de.uka.ipd.sdq.tcfmoop.config.TerminationCriteriaNames;
import de.uka.ipd.sdq.tcfmoop.config.exceptions.InvalidConfigException;

public class ElapsedTimeConfig
extends AbstractConfiguration {
    private Long executionInterval;
    private TimeType timeType;

    public ElapsedTimeConfig() {
        super(TerminationCriteriaNames.ELAPSED_TIME);
    }

    @Override
    public boolean validateConfiguration() {
        return this.getTerminationCriterionName() == TerminationCriteriaNames.ELAPSED_TIME && this.executionInterval != null && (this.timeType == TimeType.CPU_TIME || this.timeType == TimeType.USER_TIME);
    }

    public void setExecutionInterval(long timeInMilis) throws InvalidConfigException {
        if (timeInMilis < 1L) {
            throw new InvalidConfigException("ElapsedTimeConfig.setExecutionInterval: Negative Time is not allowed.");
        }
        this.executionInterval = timeInMilis;
    }

    public long getExecutionInterval() {
        return this.executionInterval;
    }

    public void setTimeType(TimeType timeType) throws InvalidConfigException {
        if (timeType == null) {
            throw new InvalidConfigException("ElapsedTimeConfig.setTimeType(): The supplied parameter should be TimeType.CPU_TIME or TimeType.USER_TIME.Currently the parameter is null.");
        }
        this.timeType = timeType;
    }

    public TimeType getTimeType() {
        return this.timeType;
    }

    public static enum TimeType {
        USER_TIME,
        CPU_TIME;

    }
}

