/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.tcfmoop.config;

import de.uka.ipd.sdq.tcfmoop.config.AbstractConfiguration;
import de.uka.ipd.sdq.tcfmoop.config.TerminationCriteriaNames;
import de.uka.ipd.sdq.tcfmoop.config.exceptions.InvalidConfigException;

public class NoNewParetoOptimalCandidatesFoundConfig
extends AbstractConfiguration {
    private Integer iterationsWithoutNewCandidates;

    public NoNewParetoOptimalCandidatesFoundConfig() {
        super(TerminationCriteriaNames.NO_NEW_PARETO_OPTIMAL_CANDIDATES_FOUND);
    }

    @Override
    public boolean validateConfiguration() {
        return this.getTerminationCriterionName() == TerminationCriteriaNames.NO_NEW_PARETO_OPTIMAL_CANDIDATES_FOUND && this.iterationsWithoutNewCandidates != null;
    }

    public void setIterationsWithoutNewCandidates(int numberOfIterations) throws InvalidConfigException {
        if (numberOfIterations < 1) {
            throw new InvalidConfigException("NoNewParetoOptimalCandidatesFoundConfig.setNumberOfGenerationWithoutNewCandidates: The minimum number of generations without new pareto optimal candidate must be at least 1.");
        }
        this.iterationsWithoutNewCandidates = numberOfIterations;
    }

    public int getIterationsWithoutNewCandidates() {
        return this.iterationsWithoutNewCandidates;
    }
}

