/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.tcfmoop.tcmanager;

import bsh.EvalError;
import bsh.Interpreter;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import de.uka.ipd.sdq.tcfmoop.config.IConfiguration;
import de.uka.ipd.sdq.tcfmoop.config.TerminationCriteriaNames;
import de.uka.ipd.sdq.tcfmoop.outputtree.Node;
import de.uka.ipd.sdq.tcfmoop.outputtree.Tree;
import de.uka.ipd.sdq.tcfmoop.tcmanager.IOptimizationTerminatedListener;
import de.uka.ipd.sdq.tcfmoop.tcmanager.IOutputChangedListener;
import de.uka.ipd.sdq.tcfmoop.tcmanager.IRequestManualTerminationProvider;
import de.uka.ipd.sdq.tcfmoop.tcmanager.ITerminationCriteriaManager;
import de.uka.ipd.sdq.tcfmoop.tcmanager.ITerminationCriteriaManagerInitializedListener;
import de.uka.ipd.sdq.tcfmoop.terminationcriteria.AbstractTerminationCriterion;
import de.uka.ipd.sdq.tcfmoop.terminationcriteria.ElapsedTimeCriterion;
import de.uka.ipd.sdq.tcfmoop.terminationcriteria.GivenParetoFrontIsReachedCriterion;
import de.uka.ipd.sdq.tcfmoop.terminationcriteria.ITerminationCriterion;
import de.uka.ipd.sdq.tcfmoop.terminationcriteria.InsignificantParetoFrontChangeCriterion;
import de.uka.ipd.sdq.tcfmoop.terminationcriteria.InsignificantSetQualityImprovementCriterion;
import de.uka.ipd.sdq.tcfmoop.terminationcriteria.MaxGenerationNumber;
import de.uka.ipd.sdq.tcfmoop.terminationcriteria.MinimalQualityCriteriaValueCriterion;
import de.uka.ipd.sdq.tcfmoop.terminationcriteria.NoNewParetoOptimalCandidatesFoundCriterion;
import de.uka.ipd.sdq.tcfmoop.terminationcriteria.ParetoOptimalSetStabilityCriterion;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.opt4j.core.optimizer.Archive;
import org.opt4j.core.optimizer.Control;
import org.opt4j.core.optimizer.Optimizer;
import org.opt4j.core.optimizer.Population;

@Singleton
public class TerminationCriteriaManager
implements ITerminationCriteriaManager {
    private List<ITerminationCriterion> terminationCriteria = new LinkedList<ITerminationCriterion>();
    private boolean isInitialized = false;
    private long currentTime;
    private Control control;
    private Optimizer optimizer;
    private Population population;
    private Archive archive;
    private int iteration;
    private boolean isInComparisionMode = false;
    private boolean isComposedCriterionActive = false;
    private boolean performManualStop = false;
    private String composedCriterionExpression = "";
    private List<IOutputChangedListener> outputChangedListeners;
    private static List<ITerminationCriteriaManagerInitializedListener> terminationCriteriaManagerInitializedListeners = new ArrayList<ITerminationCriteriaManagerInitializedListener>();
    private List<IOptimizationTerminatedListener> optimizationTerminatedListener;
    private Tree outputTree = new Tree("Termination Criteria Manager", Node.NodeType.MANAGER);
    private Tree managerTree = new Tree("Manager", Node.NodeType.MANAGER);
    private Tree tCriteriaTree = new Tree("Termination Criteria", Node.NodeType.PARAMETER_GROUP);
    private Tree warningsTree = new Tree("Warnings", Node.NodeType.WARNING);
    private Node iterationNummberNode;
    private Node candidatesInPopulationNode;
    private Node candidatesInArchiveNode;
    private Node useComposedCriterionNode;
    private Node ComposedCriterionExpressionNode;
    private Node isRunningInComparisionModeNode;
    private Node manualTerminationRequestedNode;
    private Node optimizationStoppedNode;
    private boolean substituteWarningShown = false;

    @Inject
    public TerminationCriteriaManager(Control control, Population population, Archive archive) {
        this.control = control;
        this.population = population;
        this.archive = archive;
        this.outputChangedListeners = new ArrayList<IOutputChangedListener>();
        this.optimizationTerminatedListener = new ArrayList<IOptimizationTerminatedListener>();
    }

    @Override
    public void initialize(List<IConfiguration> tcConfigurations) {
        for (IConfiguration conf : tcConfigurations) {
            if (!conf.validateConfiguration()) {
                this.warningsTree.addChild("The configuration for : " + (Object)((Object)conf.getTerminationCriterionName()) + " cannot be veryfied successfully. " + "The criterion will not be created.", Node.NodeType.WARNING);
                continue;
            }
            AbstractTerminationCriterion tc = null;
            switch (conf.getTerminationCriterionName()) {
                case MAXIMUM_NUMBER_OF_GENERATIONS: {
                    tc = new MaxGenerationNumber(conf, this.population, this.archive);
                    break;
                }
                case ELAPSED_TIME: {
                    tc = new ElapsedTimeCriterion(conf, this.population, this.archive);
                    break;
                }
                case PARETO_OPTIMAL_SET_STABILITY: {
                    tc = new ParetoOptimalSetStabilityCriterion(conf, this.population, this.archive);
                    break;
                }
                case NO_NEW_PARETO_OPTIMAL_CANDIDATES_FOUND: {
                    tc = new NoNewParetoOptimalCandidatesFoundCriterion(conf, this.population, this.archive);
                    break;
                }
                case MINIMAL_QUALITY_CIRTERIA_VALUE: {
                    tc = new MinimalQualityCriteriaValueCriterion(conf, this.population, this.archive);
                    break;
                }
                case INSIGNIFICANT_SET_QUALITY_IMPROVEMENT: {
                    tc = new InsignificantSetQualityImprovementCriterion(conf, this.population, this.archive);
                    break;
                }
                case GIVEN_PARETO_FRONT_IS_REACHED: {
                    tc = new GivenParetoFrontIsReachedCriterion(conf, this.population, this.archive);
                    break;
                }
                case INSIGNIFICANT_PARETO_FRONT_CHANGE: {
                    tc = new InsignificantParetoFrontChangeCriterion(conf, this.population, this.archive);
                    break;
                }
                default: {
                    this.warningsTree.addChild("Unknown Termination Criterion: " + (Object)((Object)conf.getTerminationCriterionName()), Node.NodeType.WARNING);
                }
            }
            if (tc == null) continue;
            this.terminationCriteria.add(tc);
        }
        this.initializeOutputTree();
        this.isInitialized = true;
        this.fireTerminationCriteriaManagerInitializedEvent();
        this.fireOutputInformationChangedEvent();
    }

    private void initializeOutputTree() {
        this.outputTree.attachSubtree(this.managerTree);
        this.outputTree.attachSubtree(this.tCriteriaTree);
        this.outputTree.attachSubtree(this.warningsTree);
        this.iterationNummberNode = this.managerTree.addChild("Iteration Number: " + this.iteration, Node.NodeType.PARAMETER);
        this.candidatesInPopulationNode = this.managerTree.addChild("Candidates in Population: " + this.population.size(), Node.NodeType.PARAMETER);
        this.candidatesInArchiveNode = this.managerTree.addChild("All Pareto Optimal Candidates: " + this.archive.size(), Node.NodeType.PARAMETER);
        this.useComposedCriterionNode = this.managerTree.addChild("Use Composed Criterion: " + this.isComposedCriterionActive, Node.NodeType.PARAMETER);
        this.ComposedCriterionExpressionNode = this.managerTree.addChild("Composed Criterion Expression: " + this.composedCriterionExpression, Node.NodeType.EXPRESSION);
        this.isRunningInComparisionModeNode = this.managerTree.addChild("Running in Comparision Mode: " + this.isInComparisionMode, Node.NodeType.PARAMETER);
        this.manualTerminationRequestedNode = this.managerTree.addChild("Manual Termination requested: " + this.performManualStop, Node.NodeType.PARAMETER);
        this.optimizationStoppedNode = this.managerTree.addChild("Optimization Stopped: " + this.control.isStopped(), Node.NodeType.PARAMETER);
    }

    @Override
    public void activateTCComparisionMode() {
        this.isInComparisionMode = true;
        this.fireOutputInformationChangedEvent();
    }

    @Override
    public void deactivateTCComparisionMode() {
        this.isInComparisionMode = false;
        this.fireOutputInformationChangedEvent();
    }

    @Override
    public void activateComposedCriterion() {
        this.isComposedCriterionActive = true;
        this.fireOutputInformationChangedEvent();
    }

    @Override
    public void deactivateComposedCriterion() {
        this.isComposedCriterionActive = false;
        this.fireOutputInformationChangedEvent();
    }

    @Override
    public void setComposedCriterionExpression(String composedCriterionExpression) {
        if (this.isComposedCriterionActive && !composedCriterionExpression.isEmpty()) {
            String exprTemp = String.valueOf(composedCriterionExpression);
            exprTemp = exprTemp.replace(TerminationCriteriaNames.ELAPSED_TIME.name(), "");
            exprTemp = exprTemp.replace(TerminationCriteriaNames.GIVEN_PARETO_FRONT_IS_REACHED.name(), "");
            exprTemp = exprTemp.replace(TerminationCriteriaNames.INSIGNIFICANT_PARETO_FRONT_CHANGE.name(), "");
            exprTemp = exprTemp.replace(TerminationCriteriaNames.INSIGNIFICANT_SET_QUALITY_IMPROVEMENT.name(), "");
            exprTemp = exprTemp.replace(TerminationCriteriaNames.MAXIMUM_NUMBER_OF_GENERATIONS.name(), "");
            exprTemp = exprTemp.replace(TerminationCriteriaNames.MINIMAL_QUALITY_CIRTERIA_VALUE.name(), "");
            exprTemp = exprTemp.replace(TerminationCriteriaNames.NO_NEW_PARETO_OPTIMAL_CANDIDATES_FOUND.name(), "");
            exprTemp = exprTemp.replace(TerminationCriteriaNames.PARETO_OPTIMAL_SET_STABILITY.name(), "");
            exprTemp = exprTemp.replace("true", "");
            exprTemp = exprTemp.replace("false", "");
            exprTemp = exprTemp.replace("&&", "");
            exprTemp = exprTemp.replace("||", "");
            exprTemp = exprTemp.replace("!", "");
            exprTemp = exprTemp.replace("(", "");
            exprTemp = exprTemp.replace(")", "");
            if (!(exprTemp = exprTemp.replaceAll(" ", "")).isEmpty()) {
                this.isComposedCriterionActive = false;
                this.warningsTree.addChild("Composed Criterion Expression cannot be set because of the following reason: 1. The expression contains symbols that are not allowed. A Standard 'OR' Expression will be used instead.", Node.NodeType.WARNING);
                return;
            }
            Interpreter i = new Interpreter();
            try {
                i.set(TerminationCriteriaNames.ELAPSED_TIME.name(), true);
                i.set(TerminationCriteriaNames.GIVEN_PARETO_FRONT_IS_REACHED.name(), true);
                i.set(TerminationCriteriaNames.INSIGNIFICANT_PARETO_FRONT_CHANGE.name(), true);
                i.set(TerminationCriteriaNames.INSIGNIFICANT_SET_QUALITY_IMPROVEMENT.name(), true);
                i.set(TerminationCriteriaNames.MAXIMUM_NUMBER_OF_GENERATIONS.name(), true);
                i.set(TerminationCriteriaNames.MINIMAL_QUALITY_CIRTERIA_VALUE.name(), true);
                i.set(TerminationCriteriaNames.NO_NEW_PARETO_OPTIMAL_CANDIDATES_FOUND.name(), true);
                i.set(TerminationCriteriaNames.PARETO_OPTIMAL_SET_STABILITY.name(), true);
                i.eval("boolean evalResult = " + composedCriterionExpression + ";");
                i.get("evalResult");
                this.composedCriterionExpression = composedCriterionExpression;
            }
            catch (EvalError evalError) {
                this.isComposedCriterionActive = false;
                this.warningsTree.addChild("Composed Criterion Expression cannot be set because of the following reason: 1. The Expression cannot be evaluated because it is malformed. A Standard 'OR' Expression will be used instead.", Node.NodeType.WARNING);
            }
        } else {
            this.warningsTree.addChild("Composed Criterion Expression cannot be set because of one of the following reasons: 1. The Composed Criterion is deactivated. 2. The Expression is empty. A Standard 'OR' Expression will be used instead.", Node.NodeType.WARNING);
        }
        this.fireOutputInformationChangedEvent();
    }

    @Override
    public void evaluateTerminationCriteria() {
        if (this.isInitialized) {
            this.iteration = this.optimizer.getIteration();
            this.currentTime = System.currentTimeMillis();
            boolean doStop = false;
            if (!this.performManualStop) {
                for (ITerminationCriterion tc : this.terminationCriteria) {
                    tc.evaluate(this.optimizer.getIteration(), this.currentTime);
                }
                if (this.isComposedCriterionActive) {
                    doStop = this.evaluateExpression();
                } else {
                    for (ITerminationCriterion tc : this.terminationCriteria) {
                        if (!tc.getEvaluationResult() || doStop) continue;
                        doStop = true;
                    }
                }
            }
            if (this.performManualStop || doStop && !this.isInComparisionMode) {
                this.control.doStop();
                this.fireOutputInformationChangedEvent();
                this.fireOptimizationTerminatedEvent();
            } else {
                this.fireOutputInformationChangedEvent();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean evaluateExpression() {
        block6: {
            expressionCopy = this.composedCriterionExpression.trim();
            for (ITerminationCriterion tc : this.terminationCriteria) {
                if (!expressionCopy.contains(tc.getName().name())) continue;
                expressionCopy = expressionCopy.replace(tc.getName().name(), Boolean.toString(tc.getEvaluationResult()));
            }
            if (expressionCopy.contains("_")) {
                expressionCopy = expressionCopy.replace(TerminationCriteriaNames.ELAPSED_TIME.name(), Boolean.toString(false));
                expressionCopy = expressionCopy.replace(TerminationCriteriaNames.GIVEN_PARETO_FRONT_IS_REACHED.name(), Boolean.toString(false));
                expressionCopy = expressionCopy.replace(TerminationCriteriaNames.INSIGNIFICANT_PARETO_FRONT_CHANGE.name(), Boolean.toString(false));
                expressionCopy = expressionCopy.replace(TerminationCriteriaNames.INSIGNIFICANT_SET_QUALITY_IMPROVEMENT.name(), Boolean.toString(false));
                expressionCopy = expressionCopy.replace(TerminationCriteriaNames.MAXIMUM_NUMBER_OF_GENERATIONS.name(), Boolean.toString(false));
                expressionCopy = expressionCopy.replace(TerminationCriteriaNames.MINIMAL_QUALITY_CIRTERIA_VALUE.name(), Boolean.toString(false));
                expressionCopy = expressionCopy.replace(TerminationCriteriaNames.NO_NEW_PARETO_OPTIMAL_CANDIDATES_FOUND.name(), Boolean.toString(false));
                expressionCopy = expressionCopy.replace(TerminationCriteriaNames.PARETO_OPTIMAL_SET_STABILITY.name(), Boolean.toString(false));
                if (!this.substituteWarningShown) {
                    this.substituteWarningShown = true;
                    this.warningsTree.addChild("There is an inactive Termination Criterion referensed in the Composed Criterion Expression. Its value has been substituted with false.", Node.NodeType.WARNING);
                }
            }
            i = new Interpreter();
            evaluationResult = false;
            try {
                i.eval("boolean evalResult = " + expressionCopy + ";");
                evaluationResult = (Boolean)i.get("evalResult");
                break block6;
            }
            catch (EvalError v0) {
                this.isComposedCriterionActive = false;
                ** for (tc : this.terminationCriteria)
            }
lbl-1000:
            // 1 sources

            {
                if (!tc.getEvaluationResult() || evaluationResult) continue;
                evaluationResult = true;
                continue;
            }
lbl32:
            // 1 sources

            this.warningsTree.addChild("Composed Criterion Expression cannot be set because of the following reason: 1. The Expression cannot be evaluated because it is malformed. A Standard 'OR' Expression will be used instead.", Node.NodeType.WARNING);
        }
        return evaluationResult;
    }

    private void fireOutputInformationChangedEvent() {
        if (this.isInitialized) {
            this.iterationNummberNode.updateValue("Iteration Number: " + this.iteration);
            this.candidatesInPopulationNode.updateValue("Candidates in Population: " + this.population.size());
            this.candidatesInArchiveNode.updateValue("All Pareto Optimal Candidates: " + this.archive.size());
            this.useComposedCriterionNode.updateValue("Use Composed Criterion: " + this.isComposedCriterionActive);
            this.ComposedCriterionExpressionNode.updateValue("Composed Criterion Expression: " + this.composedCriterionExpression);
            this.isRunningInComparisionModeNode.updateValue("Running in Comparision Mode: " + this.isInComparisionMode);
            this.manualTerminationRequestedNode.updateValue("Manual Termination requested: " + this.performManualStop);
            this.optimizationStoppedNode.updateValue("Optimization Stopped: " + this.control.isStopped());
            this.tCriteriaTree.clearChildren();
            for (ITerminationCriterion tc : this.terminationCriteria) {
                this.tCriteriaTree.attachSubtree(tc.getOutputInformation());
            }
        }
        for (IOutputChangedListener listener : this.outputChangedListeners) {
            listener.handleOutputChangedEvent(this.outputTree);
        }
    }

    private void fireTerminationCriteriaManagerInitializedEvent() {
        for (ITerminationCriteriaManagerInitializedListener listener : terminationCriteriaManagerInitializedListeners) {
            listener.handleTerminationCriteriaManagerInitializedEvent(this);
        }
    }

    private void fireOptimizationTerminatedEvent() {
        ArrayList<IOptimizationTerminatedListener> tempList = new ArrayList<IOptimizationTerminatedListener>(this.optimizationTerminatedListener);
        for (IOptimizationTerminatedListener listener : tempList) {
            listener.handleOptimizationTerminatedListener(this);
        }
    }

    @Override
    public void addOutputChangedListener(IOutputChangedListener listener) {
        this.outputChangedListeners.add(listener);
        if (listener instanceof IRequestManualTerminationProvider) {
            ((IRequestManualTerminationProvider)((Object)listener)).addRequestManualTerminationListener(this);
        }
    }

    @Override
    public void removeOutputChangedListener(IOutputChangedListener listener) {
        this.outputChangedListeners.remove(listener);
        if (listener instanceof IRequestManualTerminationProvider) {
            ((IRequestManualTerminationProvider)((Object)listener)).removeRequestManualTerminationListener(this);
        }
    }

    public static void addTerminationCriteriaManagerInitializedListener(ITerminationCriteriaManagerInitializedListener listener) {
        terminationCriteriaManagerInitializedListeners.add(listener);
    }

    public static void removeTerminationCriteriaManagerInitializedListener(ITerminationCriteriaManagerInitializedListener listener) {
        terminationCriteriaManagerInitializedListeners.remove(listener);
    }

    public void iterationComplete(Optimizer optimizer, int iteration) {
        if (this.isInitialized) {
            this.optimizer = optimizer;
            this.evaluateTerminationCriteria();
        }
    }

    @Override
    public void addOptimizationTerminatedListener(IOptimizationTerminatedListener listener) {
        this.optimizationTerminatedListener.add(listener);
    }

    @Override
    public void removeOptimizationTerminatedListener(IOptimizationTerminatedListener listener) {
        this.optimizationTerminatedListener.remove(listener);
    }

    @Override
    public void handleManualTerminationRequest() {
        this.performManualStop = true;
        this.fireOutputInformationChangedEvent();
    }
}

