/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.tcfmoop.tests;

import de.uka.ipd.sdq.tcfmoop.config.ElapsedTimeConfig;
import de.uka.ipd.sdq.tcfmoop.terminationcriteria.ElapsedTimeCriterion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ElapsedTimeCriterionTest {
    ElapsedTimeConfig etconfUser;
    ElapsedTimeCriterion etcritUser;
    ElapsedTimeConfig etconfCPUFalse;
    ElapsedTimeCriterion etcritCPUFalse;
    ElapsedTimeConfig etconfCPUTrue;
    ElapsedTimeCriterion etcritCPUTrue;

    @Before
    public void setUp() throws Exception {
        this.etconfUser = new ElapsedTimeConfig();
        this.etconfUser.setExecutionInterval(3600000L);
        this.etconfUser.setTimeType(ElapsedTimeConfig.TimeType.USER_TIME);
        if (!this.etconfUser.validateConfiguration()) {
            throw new Exception();
        }
        this.etcritUser = new ElapsedTimeCriterion(this.etconfUser, null, null);
        this.etconfCPUFalse = new ElapsedTimeConfig();
        this.etconfCPUFalse.setExecutionInterval(3600000L);
        this.etconfCPUFalse.setTimeType(ElapsedTimeConfig.TimeType.CPU_TIME);
        if (!this.etconfCPUFalse.validateConfiguration()) {
            throw new Exception();
        }
        this.etcritCPUFalse = new ElapsedTimeCriterion(this.etconfCPUFalse, null, null);
        this.etconfCPUTrue = new ElapsedTimeConfig();
        this.etconfCPUTrue.setExecutionInterval(10L);
        this.etconfCPUTrue.setTimeType(ElapsedTimeConfig.TimeType.CPU_TIME);
        if (!this.etconfCPUTrue.validateConfiguration()) {
            throw new Exception();
        }
        this.etcritCPUTrue = new ElapsedTimeCriterion(this.etconfCPUTrue, null, null);
    }

    @Test
    public void testUserTime() {
        this.etcritUser.evaluate(251, System.currentTimeMillis());
        Assert.assertFalse((boolean)this.etcritUser.getEvaluationResult());
        this.etcritUser.evaluate(251, System.currentTimeMillis() + 0x6DDD00L);
        Assert.assertTrue((boolean)this.etcritUser.getEvaluationResult());
    }

    @Test
    public void testCPUTime() {
        this.etcritUser.evaluate(251, System.currentTimeMillis());
        Assert.assertFalse((boolean)this.etcritUser.getEvaluationResult());
        this.etcritUser.evaluate(251, System.currentTimeMillis() + 0x6DDD00L);
        Assert.assertTrue((boolean)this.etcritUser.getEvaluationResult());
    }
}

