/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.are.dsexplore.analysis.security;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.analyzer.workflow.runconfig.FileNamesInputTab;

public class SecurityAnalysisTab
extends FileNamesInputTab
implements ILaunchConfigurationTab {
    private static final String ATTR_ATTACKER_MTOA = "attacker_mtoa";
    private static final String ATTR_ATTACKER_DELTA = "attacker_delta";
    private static final String ATTR_ATTACKER_LAMBDA = "attacker_lambda";
    private static Logger logger = Logger.getLogger((String)"edu.kit.ipd.are.dsexplore.analysis.security");
    private final int CUSTOM_INDEX = 2;
    private Button[] buttons = new Button[3];
    private Text[][] atkSettingsTexts = new Text[3][3];
    private int numButtonSelected = 1;
    private String attacker_lambda = "0.01";
    private String attacker_delta = "100";
    private String attacker_mtoa = "200";
    private final String[][] atkSettingsTextContent = new String[][]{{"Low", "0.007", "150", "200"}, {"High", "0.01", "100", "200"}, {"Custom", this.attacker_lambda, this.attacker_delta, this.attacker_mtoa}};

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout());
        this.createAttackerSettings(container);
    }

    private Composite createAttackerSettings(Composite parent) {
        Button button;
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText("Set Attacker Skill Level");
        Composite radioContainer = new Composite(parent, 0);
        radioContainer.setLayout((Layout)new GridLayout(4, false));
        Text nameText = new Text(radioContainer, 8);
        nameText.setEnabled(true);
        nameText.setText("Type");
        nameText.setEditable(false);
        Text lambdaDesc = new Text(radioContainer, 8);
        lambdaDesc.setEnabled(true);
        lambdaDesc.setText("Lambda");
        lambdaDesc.setToolTipText("Describes how much the attacker is improving over time");
        lambdaDesc.setEditable(false);
        Text deltaDesc = new Text(radioContainer, 8);
        deltaDesc.setEnabled(true);
        deltaDesc.setText("Delta");
        deltaDesc.setToolTipText("Time the attacker is always unsuccessful and needs to get to know the system");
        deltaDesc.setEditable(false);
        Text mtoaDesc = new Text(radioContainer, 8);
        mtoaDesc.setEnabled(true);
        mtoaDesc.setText("Mean Time of Attack");
        mtoaDesc.setToolTipText("Mean time the attacker tries to get into the system");
        mtoaDesc.setEditable(false);
        int i = 0;
        while (i < 3) {
            button = new Button(radioContainer, 32);
            button.setEnabled(true);
            button.setText(this.atkSettingsTextContent[i][0]);
            button.setSelection(i == this.numButtonSelected);
            this.buttons[i] = button;
            Text lambda = new Text(radioContainer, 8);
            lambda.setEnabled(true);
            lambda.setText(this.atkSettingsTextContent[i][1]);
            lambda.setEditable(i == 2);
            this.atkSettingsTexts[i][0] = lambda;
            Text delta = new Text(radioContainer, 8);
            delta.setEnabled(true);
            delta.setText(this.atkSettingsTextContent[i][2]);
            delta.setEditable(i == 2);
            this.atkSettingsTexts[i][1] = delta;
            Text mtoa = new Text(radioContainer, 8);
            mtoa.setEnabled(true);
            mtoa.setText(this.atkSettingsTextContent[i][3]);
            mtoa.setEditable(i == 2);
            this.atkSettingsTexts[i][2] = mtoa;
            ++i;
        }
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SecurityAnalysisTab.this.setDirty(true);
                SecurityAnalysisTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() instanceof Button) {
                    Button button = (Button)e.getSource();
                    int i = 0;
                    while (i < SecurityAnalysisTab.this.buttons.length) {
                        Button otherButton = SecurityAnalysisTab.this.buttons[i];
                        if (!otherButton.equals(button)) {
                            otherButton.setSelection(false);
                        } else {
                            SecurityAnalysisTab.this.attacker_lambda = SecurityAnalysisTab.this.atkSettingsTexts[i][0].getText();
                            SecurityAnalysisTab.this.attacker_delta = SecurityAnalysisTab.this.atkSettingsTexts[i][1].getText();
                            SecurityAnalysisTab.this.attacker_mtoa = SecurityAnalysisTab.this.atkSettingsTexts[i][2].getText();
                        }
                        ++i;
                    }
                }
                SecurityAnalysisTab.this.setDirty(true);
                SecurityAnalysisTab.this.updateLaunchConfigurationDialog();
            }
        };
        Button[] buttonArray = this.buttons;
        int n = this.buttons.length;
        int lambda = 0;
        while (lambda < n) {
            button = buttonArray[lambda];
            button.addSelectionListener(selectionListener);
            ++lambda;
        }
        ModifyListener textModifyListener = event -> {
            this.attacker_lambda = this.atkSettingsTexts[2][0].getText();
            this.attacker_delta = this.atkSettingsTexts[2][1].getText();
            this.attacker_mtoa = this.atkSettingsTexts[2][2].getText();
            this.setSelectedButton(2);
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        };
        int i2 = 0;
        while (i2 < this.atkSettingsTexts[2].length) {
            this.atkSettingsTexts[2][i2].addModifyListener(textModifyListener);
            ++i2;
        }
        return radioContainer;
    }

    public String getName() {
        return "Security Analysis";
    }

    private void setSelectedButton(int buttonIndex) {
        int i = 0;
        while (i < this.buttons.length) {
            this.buttons[i].setSelection(i == buttonIndex);
            ++i;
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.attacker_lambda = configuration.getAttribute(ATTR_ATTACKER_LAMBDA, "0.01");
            this.attacker_delta = configuration.getAttribute(ATTR_ATTACKER_DELTA, "100");
            this.attacker_mtoa = configuration.getAttribute(ATTR_ATTACKER_MTOA, "200");
            if (this.attacker_lambda.equals(this.atkSettingsTextContent[0][1]) && this.attacker_delta.equals(this.atkSettingsTextContent[0][2]) && this.attacker_mtoa.equals(this.atkSettingsTextContent[0][3])) {
                this.numButtonSelected = 0;
            } else if (this.attacker_lambda.equals(this.atkSettingsTextContent[1][1]) && this.attacker_delta.equals(this.atkSettingsTextContent[1][2]) && this.attacker_mtoa.equals(this.atkSettingsTextContent[1][3])) {
                this.numButtonSelected = 1;
            } else {
                this.atkSettingsTexts[2][0].setText(this.attacker_lambda);
                this.atkSettingsTexts[2][1].setText(this.attacker_delta);
                this.atkSettingsTexts[2][2].setText(this.attacker_mtoa);
                this.numButtonSelected = 2;
            }
            this.setSelectedButton(this.numButtonSelected);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(ATTR_ATTACKER_LAMBDA, this.attacker_lambda);
        configuration.setAttribute(ATTR_ATTACKER_DELTA, this.attacker_delta);
        configuration.setAttribute(ATTR_ATTACKER_MTOA, this.attacker_mtoa);
        logger.debug((Object)("Changed Config: Attacker(" + this.attacker_lambda + "," + this.attacker_delta + "," + this.attacker_mtoa + ")"));
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(ATTR_ATTACKER_LAMBDA, this.attacker_lambda);
        configuration.setAttribute(ATTR_ATTACKER_DELTA, this.attacker_delta);
        configuration.setAttribute(ATTR_ATTACKER_MTOA, this.attacker_mtoa);
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void dispose() {
        super.dispose();
    }

    public Image getImage() {
        return null;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        try {
            Double.parseDouble(this.attacker_lambda);
            double delta = Double.parseDouble(this.attacker_delta);
            double mtoa = Double.parseDouble(this.attacker_mtoa);
            if (delta > mtoa) {
                this.setErrorMessage("Custom values for Attacker are invalid!");
                return false;
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage("Custom values for Attacker are invalid!");
            return false;
        }
    }
}

