/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter;

import FeatureCompletionModel.Complementum;
import FeatureCompletionModel.ComplementumVisnetis;
import FeatureCompletionModel.CompletionComponent;
import FeatureCompletionModel.FeatureCompletion;
import de.uka.ipd.sdq.dsexplore.tools.primitives.Pair;
import de.uka.ipd.sdq.dsexplore.tools.stereotypeapi.StereotypeAPIHelper;
import de.uka.ipd.sdq.pcm.designdecision.BoolChoice;
import de.uka.ipd.sdq.pcm.designdecision.Choice;
import de.uka.ipd.sdq.pcm.designdecision.ClassChoice;
import de.uka.ipd.sdq.pcm.designdecision.DegreeOfFreedomInstance;
import de.uka.ipd.sdq.pcm.designdecision.impl.designdecisionFactoryImpl;
import de.uka.ipd.sdq.pcm.designdecision.specific.AllocationDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.FeatureDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.impl.specificFactoryImpl;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.port.FCCModule;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.port.FCCWeaverException;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.IWeavingStrategy;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.WeavingInstruction;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.WeavingLocation;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.WeavingStrategies;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter.AdapterStrategyExtension;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter.AdapterWeavingFactory;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter.AllocationWeaving;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter.AssemblyWeaving;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter.ComplementumWeaver;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter.IAdapterWeaving;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter.RepositoryWeaving;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter.ServiceEffectSpecificationWeaving;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter.UsageModelWeaving;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.handler.FCCFeatureHandler;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.handler.FCCStructureHandler;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.manager.PcmAllocationManager;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.manager.PcmServiceEffectSpecificationManager;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.manager.PcmSystemManager;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.manager.PcmUsageModelManager;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.manager.SolutionManager;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.util.InstructionGenerator;
import featureSolution.InclusionMechanism;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.solver.core.models.PCMInstance;

public class AdapterWeavingStrategy
implements IWeavingStrategy,
IAdapterWeaving {
    private final PCMInstance pcmToAdapt;
    private final Repository solution;
    private final FeatureCompletion fc;
    private final InclusionMechanism im;
    private RepositoryComponent currentAdapter;
    private AssemblyContext currentAC;
    private SolutionManager mrm;
    private PcmAllocationManager pam;
    private PcmServiceEffectSpecificationManager pseffm;
    private PcmSystemManager psm;
    private PcmUsageModelManager pumm;
    private List<WeavingInstruction> instructions;
    private List<Choice> allocationChoices;

    public AdapterWeavingStrategy(PCMInstance pcmToAdapt, Repository solution, FeatureCompletion fc, InclusionMechanism im) {
        this.pcmToAdapt = pcmToAdapt;
        this.solution = solution;
        this.fc = fc;
        this.im = im;
        this.initManagers();
    }

    @Override
    public void weave() throws FCCWeaverException {
        AllocationWeaving alw = new AllocationWeaving(this);
        UsageModelWeaving umw = new UsageModelWeaving(this);
        for (WeavingInstruction instruction : new ArrayList<WeavingInstruction>(this.instructions)) {
            RepositoryWeaving rw = AdapterWeavingFactory.getAdapterRepositoryWeaverBy(instruction.getWeavingLocation()).apply(this);
            AssemblyWeaving asw = AdapterWeavingFactory.getAdapterAssemblyWeaverBy(instruction.getWeavingLocation()).apply(this);
            ServiceEffectSpecificationWeaving sew = AdapterWeavingFactory.getAdapterSeffWeaverBy(instruction.getWeavingLocation()).apply(this);
            rw.weave(instruction);
            asw.weave(instruction);
            alw.weave(instruction);
            sew.weave(instruction);
            umw.weave(instruction);
        }
        this.weaveComplementa();
    }

    private void weaveComplementa() {
        List<Pair<Entity, Complementum>> require = this.getRequiresComplementum();
        List<Pair<AssemblyConnector, Complementum>> provides = this.getProvidesComplementum();
        ComplementumWeaver cv = new ComplementumWeaver(this.pcmToAdapt, this.mrm.getRepository());
        cv.weave(require, provides);
    }

    private List<Pair<AssemblyConnector, Complementum>> getProvidesComplementum() {
        ArrayList<Pair<AssemblyConnector, Complementum>> res = new ArrayList<Pair<AssemblyConnector, Complementum>>();
        for (Connector connector : this.pcmToAdapt.getSystem().getConnectors__ComposedStructure()) {
            List complementa = StereotypeAPIHelper.getViaStereoTypeFrom((EObject)connector, Complementum.class, (String)"fulfillsComplementum");
            if (complementa.size() == 0) continue;
            res.add((Pair<AssemblyConnector, Complementum>)Pair.of((Object)((AssemblyConnector)connector), (Object)((Complementum)complementa.get(0))));
        }
        return res;
    }

    private List<Pair<Entity, Complementum>> getRequiresComplementum() {
        List complementa;
        ArrayList<Pair<Entity, Complementum>> res = new ArrayList<Pair<Entity, Complementum>>();
        for (Repository repo : this.pcmToAdapt.getRepositories()) {
            for (Interface iface : repo.getInterfaces__Repository()) {
                if (!(iface instanceof OperationInterface)) continue;
                complementa = StereotypeAPIHelper.getViaStereoTypeFrom((EObject)iface, Complementum.class, (String)"requiresComplementum");
                if (complementa.size() != 0) {
                    res.add((Pair<Entity, Complementum>)Pair.of((Object)iface, (Object)((Complementum)complementa.get(0))));
                }
                for (OperationSignature opSig : ((OperationInterface)iface).getSignatures__OperationInterface()) {
                    complementa = StereotypeAPIHelper.getViaStereoTypeFrom((EObject)opSig, Complementum.class, (String)"fulfillsComplementum");
                    if (complementa.size() == 0) continue;
                    res.add((Pair<Entity, Complementum>)Pair.of((Object)opSig, (Object)((Complementum)complementa.get(0))));
                }
            }
        }
        for (Repository repo : this.pcmToAdapt.getRepositories()) {
            for (RepositoryComponent rc : repo.getComponents__Repository()) {
                complementa = StereotypeAPIHelper.getViaStereoTypeFrom((EObject)rc, Complementum.class, (String)"requiresComplementum");
                if (complementa.size() == 0) continue;
                res.add((Pair<Entity, Complementum>)Pair.of((Object)rc, (Object)((Complementum)complementa.get(0))));
            }
        }
        return res;
    }

    @Override
    public void setAdapter(RepositoryComponent component) {
        this.currentAdapter = component;
    }

    @Override
    public void setAdapter(AssemblyContext assembly) {
        this.currentAC = assembly;
    }

    @Override
    public RepositoryComponent getAdapterComponent() {
        return this.currentAdapter;
    }

    @Override
    public AssemblyContext getAdapterAssemblyContext() {
        return this.currentAC;
    }

    @Override
    public PCMInstance getPCMToAdapt() {
        return this.pcmToAdapt;
    }

    private void initManagers() {
        this.mrm = new SolutionManager(this.solution);
        this.pam = new PcmAllocationManager(this.pcmToAdapt.getAllocation());
        this.pseffm = new PcmServiceEffectSpecificationManager();
        this.psm = new PcmSystemManager(this.pcmToAdapt.getSystem());
        this.pumm = new PcmUsageModelManager(this.pcmToAdapt.getUsageModel());
    }

    @Override
    public SolutionManager getSolutionManager() {
        return this.mrm;
    }

    @Override
    public PcmAllocationManager getPCMAllocationManager() {
        return this.pam;
    }

    @Override
    public PcmServiceEffectSpecificationManager getPCMSEFFManager() {
        return this.pseffm;
    }

    @Override
    public PcmSystemManager getPCMSystemManager() {
        return this.psm;
    }

    @Override
    public PcmUsageModelManager getPCMUsageModelManager() {
        return this.pumm;
    }

    @Override
    public void initialize(List<Pair<ComplementumVisnetis, WeavingLocation>> locations, Choice fccChoice, List<Choice> allocationChoices) {
        AdapterStrategyExtension ase = (AdapterStrategyExtension)WeavingStrategies.ADAPTER.getExtension();
        List<WeavingInstruction> instructions = this.determineInstructions(locations, ase.optionalFeatures);
        this.instructions = instructions;
        this.allocationChoices = allocationChoices;
    }

    private List<WeavingInstruction> determineInstructions(List<Pair<ComplementumVisnetis, WeavingLocation>> locations, List<BoolChoice> optionalFeatures) {
        FCCFeatureHandler fccfh = new FCCFeatureHandler(this.mrm);
        InstructionGenerator ig = new InstructionGenerator(this.fc, this.im, fccfh, this.pcmToAdapt);
        ArrayList<WeavingInstruction> instructions = new ArrayList<WeavingInstruction>();
        ArrayList<String> notShallConnectors = new ArrayList<String>();
        this.getNotShallConnectorsFeatures(optionalFeatures, notShallConnectors);
        for (Pair<ComplementumVisnetis, WeavingLocation> targetLoc : locations) {
            WeavingInstruction instruction = ig.generate(targetLoc);
            instructions.add(instruction);
        }
        instructions.removeIf(i -> notShallConnectors.contains(i.getWeavingLocation().getId()));
        return instructions;
    }

    private void getNotShallConnectorsFeatures(List<BoolChoice> optionalFeatures, List<String> notShall) {
        for (BoolChoice ch : optionalFeatures) {
            FeatureDegree fd = (FeatureDegree)ch.getDegreeOfFreedomInstance();
            Pair f = (Pair)fd.getPrimaryChanged();
            if (ch.isChosenValue()) continue;
            notShall.add(((Connector)f.first).getId());
        }
    }

    @Override
    public List<Choice> getConvertedFCCClassChoices() {
        ArrayList<Choice> allocChoices = new ArrayList<Choice>();
        for (Choice fccClassChoice : this.allocationChoices) {
            CompletionComponent fcc = (CompletionComponent)fccClassChoice.getDegreeOfFreedomInstance().getPrimaryChanged();
            FCCStructureHandler fccHandler = new FCCStructureHandler(fcc, this.mrm);
            for (RepositoryComponent comp : fccHandler.getAffectedComponents()) {
                try {
                    AllocationContext alloc = this.getPCMAllocationManager().getAllocationContextContaining(comp);
                    AllocationDegree ad = specificFactoryImpl.init().createAllocationDegree();
                    ad.setPrimaryChanged((EObject)alloc);
                    ClassChoice choice = designdecisionFactoryImpl.init().createClassChoice();
                    choice.setDegreeOfFreedomInstance((DegreeOfFreedomInstance)ad);
                    choice.setChosenValue(((ClassChoice)fccClassChoice).getChosenValue());
                    allocChoices.add((Choice)choice);
                }
                catch (Exception e) {
                    FCCModule.LOGGER.warn((Object)e.getMessage());
                }
            }
        }
        return allocChoices;
    }
}

