/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter;

import FeatureCompletionModel.Complementum;
import de.uka.ipd.sdq.dsexplore.tools.primitives.Pair;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.port.FCCWeaverException;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.allocation.AllocationFactory;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.SeffFactory;
import org.palladiosimulator.pcm.seff.StartAction;
import org.palladiosimulator.pcm.seff.StopAction;
import org.palladiosimulator.solver.core.models.PCMInstance;

public final class ComplementumWeaver {
    private final PCMInstance pcm;
    private Repository repository;

    public ComplementumWeaver(PCMInstance pcmToAdapt, Repository solution) {
        this.pcm = pcmToAdapt;
        this.repository = solution;
    }

    public void weave(List<Pair<Entity, Complementum>> require, List<Pair<AssemblyConnector, Complementum>> provides) throws FCCWeaverException {
        Repository repo = this.repository;
        for (Pair<Entity, Complementum> complementum : require) {
            AssemblyConnector provider = provides.stream().filter(p -> p.second == pair.second).findFirst().map(p -> (AssemblyConnector)p.first).orElse(null);
            if (provider == null) {
                throw new FCCWeaverException("No provider for " + complementum.second + " found");
            }
            if (complementum.first instanceof OperationInterface) {
                this.weaveInterface((OperationInterface)complementum.first, provider, repo);
                continue;
            }
            if (complementum.first instanceof OperationSignature) {
                throw new UnsupportedOperationException("Not implemented yet");
            }
            if (complementum.first instanceof RepositoryComponent) {
                throw new UnsupportedOperationException("Not implemented yet");
            }
            throw new FCCWeaverException("Type " + complementum.getFirst() + " is not supported for complementum weaving");
        }
    }

    private void weaveInterface(OperationInterface newProvided, AssemblyConnector provider, Repository repo) {
        AssemblyContext targetContext = this.findTargetAC(newProvided);
        if (targetContext == null) {
            return;
        }
        BasicComponent adapter = this.createAdapter(newProvided, provider, repo);
        AssemblyContext ac = this.createAssemblyContext(adapter, provider, targetContext, newProvided);
        this.createAllocationContext(adapter, ac);
    }

    private AssemblyContext findTargetAC(OperationInterface newProvided) {
        for (AssemblyContext ac : this.pcm.getSystem().getAssemblyContexts__ComposedStructure()) {
            RepositoryComponent rc = ac.getEncapsulatedComponent__AssemblyContext();
            for (RequiredRole rr : rc.getRequiredRoles_InterfaceRequiringEntity()) {
                OperationRequiredRole orr;
                if (!(rr instanceof OperationRequiredRole) || !(orr = (OperationRequiredRole)rr).getRequiredInterface__OperationRequiredRole().getId().equals(newProvided.getId())) continue;
                return ac;
            }
        }
        return null;
    }

    private AllocationContext createAllocationContext(BasicComponent adapter, AssemblyContext ac) {
        AllocationContext allocCtx = AllocationFactory.eINSTANCE.createAllocationContext();
        allocCtx.setAssemblyContext_AllocationContext(ac);
        allocCtx.setAllocation_AllocationContext(this.pcm.getAllocation());
        allocCtx.setResourceContainer_AllocationContext((ResourceContainer)this.pcm.getResourceEnvironment().getResourceContainer_ResourceEnvironment().get(0));
        return allocCtx;
    }

    private AssemblyContext createAssemblyContext(BasicComponent adapter, AssemblyConnector provider, AssemblyContext target, OperationInterface targetInterface) {
        AssemblyContext ac = CompositionFactory.eINSTANCE.createAssemblyContext();
        ac.setEncapsulatedComponent__AssemblyContext((RepositoryComponent)adapter);
        AssemblyConnector connectProvided = CompositionFactory.eINSTANCE.createAssemblyConnector();
        connectProvided.setRequiringAssemblyContext_AssemblyConnector(ac);
        connectProvided.setRequiredRole_AssemblyConnector((OperationRequiredRole)adapter.getRequiredRoles_InterfaceRequiringEntity().get(0));
        connectProvided.setProvidingAssemblyContext_AssemblyConnector(provider.getProvidingAssemblyContext_AssemblyConnector());
        connectProvided.setProvidedRole_AssemblyConnector(provider.getProvidedRole_AssemblyConnector());
        AssemblyConnector connectRequired = CompositionFactory.eINSTANCE.createAssemblyConnector();
        connectRequired.setRequiringAssemblyContext_AssemblyConnector(target);
        connectRequired.setRequiredRole_AssemblyConnector(this.findRequiredRole(targetInterface, (List<RequiredRole>)target.getEncapsulatedComponent__AssemblyContext().getRequiredRoles_InterfaceRequiringEntity()));
        connectRequired.setProvidingAssemblyContext_AssemblyConnector(ac);
        connectRequired.setProvidedRole_AssemblyConnector((OperationProvidedRole)adapter.getProvidedRoles_InterfaceProvidingEntity().get(0));
        this.pcm.getSystem().getAssemblyContexts__ComposedStructure().add((Object)ac);
        this.pcm.getSystem().getConnectors__ComposedStructure().add((Object)connectRequired);
        this.pcm.getSystem().getConnectors__ComposedStructure().add((Object)connectProvided);
        return ac;
    }

    private OperationRequiredRole findRequiredRole(OperationInterface targetInterface, List<RequiredRole> requiredRoles) {
        for (RequiredRole rr : requiredRoles) {
            if (!(rr instanceof OperationRequiredRole) || !((OperationRequiredRole)rr).getRequiredInterface__OperationRequiredRole().getId().equals(targetInterface.getId())) continue;
            return (OperationRequiredRole)rr;
        }
        return null;
    }

    private BasicComponent createAdapter(OperationInterface provided, AssemblyConnector required, Repository repo) {
        String id = "AdapterFor" + provided.getId() + required.getId();
        RepositoryComponent rc = repo.getComponents__Repository().stream().filter(a -> a.getId().equals(id)).findAny().orElse(null);
        if (rc != null) {
            return (BasicComponent)rc;
        }
        BasicComponent adapter = RepositoryFactory.eINSTANCE.createBasicComponent();
        adapter.setId(id);
        adapter.setEntityName("AdapterFor" + provided.getEntityName() + required.getEntityName());
        OperationProvidedRole pr = RepositoryFactory.eINSTANCE.createOperationProvidedRole();
        pr.setProvidedInterface__OperationProvidedRole(provided);
        adapter.getProvidedRoles_InterfaceProvidingEntity().add((Object)pr);
        OperationRequiredRole or = RepositoryFactory.eINSTANCE.createOperationRequiredRole();
        or.setRequiredInterface__OperationRequiredRole(required.getProvidedRole_AssemblyConnector().getProvidedInterface__OperationProvidedRole());
        adapter.getRequiredRoles_InterfaceRequiringEntity().add((Object)or);
        for (OperationSignature sig : pr.getProvidedInterface__OperationProvidedRole().getSignatures__OperationInterface()) {
            ResourceDemandingSEFF seff = SeffFactory.eINSTANCE.createResourceDemandingSEFF();
            seff.setBasicComponent_ServiceEffectSpecification(adapter);
            adapter.getServiceEffectSpecifications__BasicComponent().add((Object)seff);
            seff.setDescribedService__SEFF((Signature)sig);
            this.enrichSEFF(seff, or);
        }
        repo.getComponents__Repository().add((Object)adapter);
        return adapter;
    }

    private void enrichSEFF(ResourceDemandingSEFF seff, OperationRequiredRole externalCalls) {
        EList actions = seff.getSteps_Behaviour();
        StartAction start = SeffFactory.eINSTANCE.createStartAction();
        actions.add(start);
        StartAction last = start;
        for (OperationSignature extern : externalCalls.getRequiredInterface__OperationRequiredRole().getSignatures__OperationInterface()) {
            ExternalCallAction ea = SeffFactory.eINSTANCE.createExternalCallAction();
            ea.setCalledService_ExternalService(extern);
            ea.setRole_ExternalService(externalCalls);
            ea.setPredecessor_AbstractAction((AbstractAction)last);
            last.setSuccessor_AbstractAction((AbstractAction)ea);
            last = ea;
            actions.add(ea);
        }
        StopAction stop = SeffFactory.eINSTANCE.createStopAction();
        stop.setPredecessor_AbstractAction((AbstractAction)last);
        actions.add(stop);
    }
}

