/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter;

import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.ErrorMessage;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.FCCUtil;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.port.FCCWeaverException;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter.AssemblyWeaving;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter.IAdapterWeaving;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter.util.AssemblyConnectorGenerator;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter.util.ConnectionInfo;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.strategy.adapter.util.DelegationConnectorGenerator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Role;

public class DelegationLocationWeaving
extends AssemblyWeaving {
    public DelegationLocationWeaving(IAdapterWeaving parent) {
        super(parent);
    }

    @Override
    public void weaveAdapterIntoSystem(Connector weavingLocation) throws FCCWeaverException {
        this.replace((ProvidedDelegationConnector)weavingLocation);
    }

    private void replace(ProvidedDelegationConnector assemblyConnectorToReplace) throws FCCWeaverException {
        this.parent.getPCMSystemManager().remove((Connector)assemblyConnectorToReplace);
        this.replaceOldConnectorWithAssemblyConnectorsToAdapter(assemblyConnectorToReplace);
    }

    private void replaceOldConnectorWithAssemblyConnectorsToAdapter(ProvidedDelegationConnector delegationConnectorToReplace) throws FCCWeaverException {
        this.createAssemblyConnectorFromAdapterToInnerProvidedEndOf(delegationConnectorToReplace);
        this.createDelegationConnectorFromOuterProvidedRoleToAdapter(delegationConnectorToReplace);
    }

    private void createAssemblyConnectorFromAdapterToInnerProvidedEndOf(ProvidedDelegationConnector delegationConnectorToReplace) throws FCCWeaverException {
        OperationProvidedRole providedRole = delegationConnectorToReplace.getInnerProvidedRole_ProvidedDelegationConnector();
        RequiredRole requiredRole = (RequiredRole)this.getComplimentaryRoleOf((Role)providedRole, this.getRequiredRolesOfAdapter());
        AssemblyContext providedAssemblyContext = delegationConnectorToReplace.getAssemblyContext_ProvidedDelegationConnector();
        ConnectionInfo connectionInfo = new ConnectionInfo((Role)requiredRole, (Role)providedRole, this.parent.getAdapterAssemblyContext(), providedAssemblyContext);
        this.addConnector(new AssemblyConnectorGenerator(this.parent.getPCMSystemManager()).createConnectorBy(connectionInfo));
    }

    private void createDelegationConnectorFromOuterProvidedRoleToAdapter(ProvidedDelegationConnector delegationConnectorToReplace) throws FCCWeaverException {
        OperationProvidedRole outerProvidedRole = delegationConnectorToReplace.getOuterProvidedRole_ProvidedDelegationConnector();
        ProvidedRole innerProvidedRole = this.getDelegatedProvidedRoleOfAdapter((ProvidedRole)outerProvidedRole);
        ConnectionInfo connectionInfo = new ConnectionInfo((Role)outerProvidedRole, (Role)innerProvidedRole, null, this.parent.getAdapterAssemblyContext());
        this.addConnector(new DelegationConnectorGenerator(this.parent.getPCMSystemManager()).createConnectorBy(connectionInfo));
    }

    private ProvidedRole getDelegatedProvidedRoleOfAdapter(ProvidedRole outerProvidedRole) throws FCCWeaverException {
        OperationInterface interface1 = ((OperationProvidedRole)outerProvidedRole).getProvidedInterface__OperationProvidedRole();
        for (OperationProvidedRole eachProvidedRole : this.getOperationProvidedRolesOfAdapter()) {
            OperationInterface interface2 = eachProvidedRole.getProvidedInterface__OperationProvidedRole();
            if (!FCCUtil.areEqual((EObject)interface1, (EObject)interface2)) continue;
            return eachProvidedRole;
        }
        throw new FCCWeaverException(ErrorMessage.missingDelegatedRole((Role)outerProvidedRole, this.parent.getAdapterComponent()));
    }

    private List<OperationProvidedRole> getOperationProvidedRolesOfAdapter() {
        return this.parent.getAdapterComponent().getProvidedRoles_InterfaceProvidingEntity().stream().filter(each -> each instanceof OperationProvidedRole).map(each -> (OperationProvidedRole)each).collect(Collectors.toList());
    }
}

