/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.qes.qualityEffectSpecification;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RoleType implements Enumerator
{
    ANY(0, "ANY", "AnyRoleType"),
    COMPONENT_REQUIRED_PROVIDED(1, "COMPONENT_REQUIRED_PROVIDED", "ComponentRequiredProvided"),
    COMPONENT_REQUIRED(2, "COMPONENT_REQUIRED", "ComponentRequired"),
    COMPONENT_PROVIDED(3, "COMPONENT_PROVIDED", "ComponentProvided"),
    INFRASTRUCTURE_REQUIRED_PROVIDED(4, "INFRASTRUCTURE_REQUIRED_PROVIDED", "InfrastructureRequiredProvided"),
    INFRASTRUCTURE_REQUIRED(5, "INFRASTRUCTURE_REQUIRED", "InfrastructureRequired"),
    INFRASTRUCTURE_PROVIDED(6, "INFRASTRUCTURE_PROVIDED", "InfrastructureProvided");

    public static final int ANY_VALUE = 0;
    public static final int COMPONENT_REQUIRED_PROVIDED_VALUE = 1;
    public static final int COMPONENT_REQUIRED_VALUE = 2;
    public static final int COMPONENT_PROVIDED_VALUE = 3;
    public static final int INFRASTRUCTURE_REQUIRED_PROVIDED_VALUE = 4;
    public static final int INFRASTRUCTURE_REQUIRED_VALUE = 5;
    public static final int INFRASTRUCTURE_PROVIDED_VALUE = 6;
    private static final RoleType[] VALUES_ARRAY;
    public static final List<RoleType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RoleType[]{ANY, COMPONENT_REQUIRED_PROVIDED, COMPONENT_REQUIRED, COMPONENT_PROVIDED, INFRASTRUCTURE_REQUIRED_PROVIDED, INFRASTRUCTURE_REQUIRED, INFRASTRUCTURE_PROVIDED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RoleType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RoleType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RoleType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RoleType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RoleType get(int value) {
        switch (value) {
            case 0: {
                return ANY;
            }
            case 1: {
                return COMPONENT_REQUIRED_PROVIDED;
            }
            case 2: {
                return COMPONENT_REQUIRED;
            }
            case 3: {
                return COMPONENT_PROVIDED;
            }
            case 4: {
                return INFRASTRUCTURE_REQUIRED_PROVIDED;
            }
            case 5: {
                return INFRASTRUCTURE_REQUIRED;
            }
            case 6: {
                return INFRASTRUCTURE_PROVIDED;
            }
        }
        return null;
    }

    private RoleType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

