/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.bayesnets.searchers;

import de.uka.ipd.sdq.dsexplore.bayesnets.samplers.BOAsampler;
import de.uka.ipd.sdq.dsexplore.bayesnets.searchers.HillClimber;
import de.uka.ipd.sdq.dsexplore.bayesnets.utility.BayesNetworkScore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;

public class ChowLiuTree {
    int[][] Data;

    public static void main(String[] args) {
        int[][] DataMat = new int[100][27];
        Random r = new Random();
        int i = 0;
        while (i < 100) {
            int j = 0;
            while (j < 27) {
                DataMat[i][j] = r.nextInt(2);
                ++j;
            }
            ++i;
        }
        HillClimber hc = new HillClimber();
        int[][] graph1 = hc.search(DataMat, 5);
        ChowLiuTree clt = new ChowLiuTree(DataMat);
        int[][] graph = clt.search();
        int i2 = 0;
        while (i2 < graph.length) {
            int j = 0;
            while (j < graph.length) {
                System.out.print(graph[i2][j]);
                ++j;
            }
            System.out.println();
            ++i2;
        }
        System.out.println("Sampled Data from the network");
        BOAsampler boasampler = new BOAsampler(graph, DataMat);
        int[][] sampledData = boasampler.sample(10);
        int i3 = 0;
        while (i3 < sampledData.length) {
            int j = 0;
            while (j < sampledData[0].length) {
                System.out.print(sampledData[i3][j]);
                ++j;
            }
            System.out.println();
            ++i3;
        }
        BayesNetworkScore bns = new BayesNetworkScore(graph, DataMat);
        System.out.println(bns.BIC());
        BayesNetworkScore bns1 = new BayesNetworkScore(graph1, DataMat);
        System.out.println(bns1.BIC());
    }

    public ChowLiuTree(int[][] Data) {
        this.Data = Data;
    }

    public int[][] search() {
        int j;
        int n = this.Data[0].length;
        double[][] MutInfMat = new double[(n * n - n) / 2][3];
        int i = 0;
        while (i < MutInfMat.length) {
            int j2 = 0;
            while (j2 < MutInfMat[0].length) {
                MutInfMat[i][j2] = 0.0;
                System.out.print(MutInfMat[i][j2]);
                ++j2;
            }
            System.out.println();
            ++i;
        }
        int index = 0;
        int i2 = 0;
        while (i2 < n) {
            j = 0;
            while (j < n) {
                if (j > i2) {
                    double MutInf = this.mutualInfo(i2, j);
                    MutInfMat[index][0] = i2;
                    MutInfMat[index][1] = j;
                    MutInfMat[index][2] = MutInf;
                    ++index;
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < MutInfMat.length) {
            j = 0;
            while (j < MutInfMat[0].length) {
                System.out.print(MutInfMat[i2][j]);
                ++j;
            }
            System.out.println();
            ++i2;
        }
        double[][] MutInfMatSorted = this.sortMatrix(MutInfMat, 2);
        int i3 = 0;
        while (i3 < MutInfMatSorted.length) {
            int j3 = 0;
            while (j3 < MutInfMatSorted[0].length) {
                System.out.print(MutInfMatSorted[i3][j3]);
                ++j3;
            }
            System.out.println();
            ++i3;
        }
        int[][] ResultGraph = new int[n][n];
        int i4 = MutInfMatSorted.length - 1;
        while (i4 >= 0) {
            System.out.println("i:" + i4);
            ArrayList<Integer> list = new ArrayList<Integer>();
            if (!this.checkPath((int)MutInfMatSorted[i4][0], (int)MutInfMatSorted[i4][1], ResultGraph, list)) {
                ResultGraph[(int)MutInfMatSorted[i4][0]][(int)MutInfMatSorted[i4][1]] = 1;
                ResultGraph[(int)MutInfMatSorted[i4][1]][(int)MutInfMatSorted[i4][0]] = 1;
            }
            --i4;
        }
        System.out.println("ResultGraph:");
        i4 = 0;
        while (i4 < ResultGraph.length) {
            int j4 = 0;
            while (j4 < ResultGraph.length) {
                System.out.print(ResultGraph[i4][j4]);
                ++j4;
            }
            System.out.println();
            ++i4;
        }
        ArrayList<Integer> nodelist = new ArrayList<Integer>();
        Random nodeSelector = new Random();
        this.makeDirected(nodeSelector.nextInt(n), ResultGraph, nodelist);
        return ResultGraph;
    }

    public double mutualInfo(int Node1, int Node2) {
        double Result = 0.0;
        int[] r = this.determineNumOfStates();
        int i = 0;
        while (i < r[Node1]) {
            int j = 0;
            while (j < r[Node2]) {
                double num = this.calcProb(Node1, i, Node2, j);
                double den1 = this.calcProb(Node1, i);
                double den2 = this.calcProb(Node2, j);
                Result += num * Math.log(num / (den1 * den2));
                ++j;
            }
            ++i;
        }
        return Result;
    }

    private double calcProb(int Node, int Value) {
        double Num = 0.0;
        double Den = 0.0;
        int i = 0;
        while (i < this.Data.length) {
            if (this.Data[i][Node] == Value) {
                Num += 1.0;
            }
            Den += 1.0;
            ++i;
        }
        return Num / Den;
    }

    private double calcProb(int Node1, int Value1, int Node2, int Value2) {
        double Num = 0.0;
        double Den = 0.0;
        int i = 0;
        while (i < this.Data.length) {
            if (this.Data[i][Node1] == Value1 && this.Data[i][Node2] == Value2) {
                Num += 1.0;
            }
            Den += 1.0;
            ++i;
        }
        return Num / Den;
    }

    private int[] determineNumOfStates() {
        int[] Result = new int[this.Data[0].length];
        int i = 0;
        while (i < this.Data[0].length) {
            HashSet<Integer> ColumnValues = new HashSet<Integer>();
            int j = 0;
            while (j < this.Data.length) {
                ColumnValues.add(this.Data[j][i]);
                ++j;
            }
            Result[i] = ColumnValues.size();
            ++i;
        }
        return Result;
    }

    private boolean checkPath(int Node1, int Node2, int[][] Graph, List<Integer> visitedNodes) {
        boolean Result = false;
        visitedNodes.add(Node1);
        List<Integer> NeighboursOfNode1 = this.getNeighbours(Node1, Graph);
        if (NeighboursOfNode1.contains(Node2)) {
            Result = true;
        } else {
            int i = 0;
            while (i < NeighboursOfNode1.size()) {
                if (!visitedNodes.contains(NeighboursOfNode1.get(i))) {
                    Result = Result || this.checkPath(NeighboursOfNode1.get(i), Node2, Graph, visitedNodes);
                }
                ++i;
            }
        }
        return Result;
    }

    private List<Integer> getNeighbours(int node, int[][] graph) {
        ArrayList<Integer> Neighbours = new ArrayList<Integer>();
        int i = 0;
        while (i < graph[node].length) {
            if (graph[node][i] == 1) {
                Neighbours.add(i);
            }
            ++i;
        }
        return Neighbours;
    }

    private double[][] sortMatrix(double[][] Matrix, final int Column) {
        Arrays.sort(Matrix, new Comparator<double[]>(){

            @Override
            public int compare(double[] a, double[] b) {
                return Double.compare(a[Column], b[Column]);
            }
        });
        return Matrix;
    }

    private void makeDirected(int Node, int[][] Graph, List<Integer> visitedNodes) {
        visitedNodes.add(Node);
        List<Integer> NeighboursOfNode = this.getNeighbours(Node, Graph);
        int i = 0;
        while (i < NeighboursOfNode.size()) {
            if (!visitedNodes.contains(NeighboursOfNode.get(i))) {
                Graph[NeighboursOfNode.get((int)i).intValue()][Node] = 0;
                this.makeDirected(NeighboursOfNode.get(i), Graph, visitedNodes);
            }
            ++i;
        }
    }
}

