/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.analysis.qes;

import de.uka.ipd.sdq.dsexplore.analysis.qes.ParseException;
import de.uka.ipd.sdq.dsexplore.analysis.qes.QesHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.palladiosimulator.qes.qualityEffectSpecification.Model;
import org.palladiosimulator.qes.qualityEffectSpecification.NQA;
import org.palladiosimulator.qes.qualityEffectSpecification.NumericValue;
import org.palladiosimulator.qes.qualityEffectSpecification.QualityEffectSpecification;
import org.palladiosimulator.qes.qualityEffectSpecification.Reasoning;
import org.palladiosimulator.qes.qualityEffectSpecification.TransformationSpecification;

public class QesParser {
    private final boolean isEmpty;
    private final Model model;
    private final Set<QualityEffectSpecification> nqas;
    private final Set<QualityEffectSpecification> reasonings;
    private final Map<String, Set<QualityEffectSpecification>> values;

    public QesParser(String string) throws ParseException {
        this(QesHelper.createUri(string));
    }

    public QesParser(URI uri) throws ParseException {
        try {
            this.model = (Model)new XtextResourceSet().getResource(uri, true).getContents().get(0);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
        assert (this.isValid());
        this.isEmpty = this.model.getSpecifications() == null || this.model.getSpecifications().isEmpty();
        HashSet<QualityEffectSpecification> n = new HashSet<QualityEffectSpecification>();
        HashSet<QualityEffectSpecification> r = new HashSet<QualityEffectSpecification>();
        HashMap v = new HashMap();
        for (QualityEffectSpecification specification : this.model.getSpecifications()) {
            for (TransformationSpecification transformation : specification.getTransformations()) {
                if (transformation instanceof NQA) {
                    n.add(specification);
                    continue;
                }
                if (transformation instanceof Reasoning) {
                    r.add(specification);
                    continue;
                }
                if (!(transformation instanceof NumericValue)) continue;
                String type = ((NumericValue)transformation).getValueType();
                if (v.containsKey(type)) {
                    ((Set)v.get(type)).add(specification);
                    continue;
                }
                HashSet<QualityEffectSpecification> specifications = new HashSet<QualityEffectSpecification>();
                specifications.add(specification);
                v.put(type, specifications);
            }
        }
        this.nqas = Collections.unmodifiableSet(n);
        this.reasonings = Collections.unmodifiableSet(r);
        this.values = Collections.unmodifiableMap(v);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.model.equals(((QesParser)obj).model);
    }

    public Set<QualityEffectSpecification> getNqaSpecifications() {
        return this.nqas;
    }

    public Set<QualityEffectSpecification> getReasoningSpecifications() {
        return this.reasonings;
    }

    public Set<QualityEffectSpecification> getSpecifications(String key) {
        if (key != null && this.values.containsKey(key)) {
            return Collections.unmodifiableSet(this.values.get(key));
        }
        return Collections.unmodifiableSet(new HashSet());
    }

    public int hashCode() {
        return this.model.hashCode();
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public boolean isValid() {
        try {
            return Diagnostician.INSTANCE.validate((EObject)this.model).getSeverity() <= 2;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String toString() {
        return "QesParser [" + this.model + "]";
    }
}

