/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.are.dsexplore.analysis.security.model;

import edu.kit.ipd.are.dsexplore.analysis.security.model.Attacker;
import edu.kit.ipd.are.dsexplore.analysis.security.model.Component;
import java.util.Arrays;

public class Scenario {
    private int[][] theta;
    private Component[] components;

    public Scenario(int[][] theta, Component[] components) {
        this.theta = theta;
        this.components = components;
    }

    private int[] calculateXi() {
        int[] res = new int[this.theta.length];
        int i = 0;
        while (i < this.theta.length) {
            int j = 0;
            while (j < this.theta[i].length) {
                if (this.theta[i][j] > 0) {
                    int n = i;
                    res[n] = res[n] + 1;
                }
                ++j;
            }
            ++i;
        }
        return res;
    }

    private double[] calcMTTBC(Attacker a) {
        double[] res = new double[this.components.length];
        int i = 0;
        while (i < this.components.length) {
            res[i] = this.components[i].calcMTTBC(a);
            ++i;
        }
        return res;
    }

    public double calcMTTSF(int length_Entry, Attacker a) {
        double mttsf_w = 0.0;
        int[] xi = this.calculateXi();
        double[] mttbc = this.calcMTTBC(a);
        int i = 0;
        while (i < mttbc.length) {
            if (xi[i] != 0) {
                double mid = 0.0;
                int j = 0;
                while (j < mttbc.length + 1) {
                    mid += mttbc[i] * (double)this.theta[i][j];
                    ++j;
                }
                mttsf_w += mid / (double)xi[i];
            }
            ++i;
        }
        return mttsf_w / (double)length_Entry;
    }

    public static double calcMTTSF(int length_Entry, Attacker a, Component[] components, int[][] theta) {
        Scenario scen = new Scenario(theta, components);
        return scen.calcMTTSF(length_Entry, a);
    }

    public String toString() {
        String ret = "";
        ret = String.valueOf(ret) + "\n\tComponents:";
        Component[] componentArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            ret = String.valueOf(ret) + "\n\t" + c.toString();
            ++n2;
        }
        ret = String.valueOf(ret) + "\n\tTheta:";
        ret = String.valueOf(ret) + "\n\t" + Arrays.deepToString((Object[])this.theta);
        return ret;
    }
}

