/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.are.dsexplore.featurecompletions.weaver;

import FeatureCompletionModel.ComplementumVisnetis;
import de.uka.ipd.sdq.dsexplore.tools.primitives.Pair;
import de.uka.ipd.sdq.identifier.Identifier;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.util.AssemblyConnectorData;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.util.ExternalCallActionData;
import edu.kit.ipd.are.dsexplore.featurecompletions.weaver.util.ProvidedDelegationConnectorData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.AbstractLoopAction;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ForkAction;
import org.palladiosimulator.pcm.seff.ForkedBehaviour;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.solver.core.models.PCMInstance;

public final class FCCUnweaver {
    private final Map<String, AssemblyConnectorData> originalAssemblyConnectors;
    private final Map<String, ProvidedDelegationConnectorData> originalProvidedDelegationConnectors;
    private final Set<String> originalAssemblyContexts;
    private final Set<String> originalAllocationContexts;
    private final Map<String, ExternalCallActionData> originalExternalCalls;

    public FCCUnweaver(MDSDBlackboard blackboard) {
        PCMResourceSetPartition initial = (PCMResourceSetPartition)blackboard.getPartition("initialPCModelPartitionID");
        this.originalAssemblyConnectors = this.saveOriginalAssemblyConnectors(initial.getSystem());
        this.originalProvidedDelegationConnectors = this.saveOriginalProvidedDelegationConnectors(initial.getSystem());
        this.originalAssemblyContexts = this.saveOriginalAssemblyContexts(initial.getSystem());
        this.originalAllocationContexts = this.saveOriginalAllocationContexts(initial.getAllocation());
        this.originalExternalCalls = this.saveOriginalExternalCalls(initial.getSystem());
    }

    public void unweave(PCMInstance pcmToAdopt, List<Pair<String, ComplementumVisnetis>> availableCVs) {
        List neccessaryIds = availableCVs.stream().map(t -> (String)t.first).collect(Collectors.toList());
        ArrayList copy = new ArrayList(pcmToAdopt.getSystem().getConnectors__ComposedStructure());
        for (Connector c : copy) {
            if (!neccessaryIds.contains(c.getId())) continue;
            if (c instanceof AssemblyConnector) {
                this.handleAssemblyConnector((AssemblyConnector)c, pcmToAdopt);
                continue;
            }
            if (c instanceof ProvidedDelegationConnector) {
                this.handleProvidedDelegationConnector((ProvidedDelegationConnector)c, pcmToAdopt);
                continue;
            }
            throw new Error("Not possible");
        }
        ArrayList copyAC = new ArrayList(pcmToAdopt.getSystem().getAssemblyContexts__ComposedStructure());
        for (AssemblyContext ac : copyAC) {
            if (this.originalAssemblyContexts.contains(ac.getId())) continue;
            pcmToAdopt.getSystem().getAssemblyContexts__ComposedStructure().remove((Object)ac);
        }
        ArrayList copyConn = new ArrayList(pcmToAdopt.getSystem().getConnectors__ComposedStructure());
        for (Connector c : copyConn) {
            if (c instanceof AssemblyConnector && !this.originalAssemblyConnectors.containsKey(c.getId())) {
                pcmToAdopt.getSystem().getConnectors__ComposedStructure().remove((Object)c);
            }
            if (!(c instanceof ProvidedDelegationConnector) || this.originalProvidedDelegationConnectors.containsKey(c.getId())) continue;
            pcmToAdopt.getSystem().getConnectors__ComposedStructure().remove((Object)c);
        }
        ArrayList copyAllocs = new ArrayList(pcmToAdopt.getAllocation().getAllocationContexts_Allocation());
        for (AllocationContext allocs : copyAllocs) {
            if (this.originalAllocationContexts.contains(allocs.getId())) continue;
            pcmToAdopt.getAllocation().getAllocationContexts_Allocation().remove((Object)allocs);
        }
        Map<String, ExternalCallActionData> copyExternalCallIDs = this.saveOriginalExternalCalls(pcmToAdopt.getSystem());
        for (Map.Entry<String, ExternalCallActionData> copyExternalCallID : copyExternalCallIDs.entrySet()) {
            if (this.originalExternalCalls.containsKey(copyExternalCallID.getKey()) || this.existsConnectorWithProvidedRole(copyExternalCallID.getValue().getOperationRequiredRoleId())) continue;
            this.removeExternalCallAction(copyExternalCallID.getKey(), pcmToAdopt);
        }
    }

    private void removeExternalCallAction(String key, PCMInstance pcmToAdopt) {
        for (AssemblyContext ac : pcmToAdopt.getSystem().getAssemblyContexts__ComposedStructure()) {
            BasicComponent comp = (BasicComponent)ac.getEncapsulatedComponent__AssemblyContext();
            for (ServiceEffectSpecification seff : comp.getServiceEffectSpecifications__BasicComponent()) {
                for (ExternalCallAction externalCallAction : this.getExternalCallActions((ResourceDemandingBehaviour)seff)) {
                    if (!externalCallAction.getId().equals(key)) continue;
                    AbstractAction prev = externalCallAction.getPredecessor_AbstractAction();
                    AbstractAction next = externalCallAction.getSuccessor_AbstractAction();
                    prev.setSuccessor_AbstractAction(next);
                    next.setPredecessor_AbstractAction(prev);
                    ResourceDemandingBehaviour containingSeff = (ResourceDemandingBehaviour)externalCallAction.eContainer();
                    containingSeff.getSteps_Behaviour().remove((Object)externalCallAction);
                }
            }
        }
    }

    private boolean existsConnectorWithProvidedRole(String operationRequiredRoleId) {
        for (Map.Entry<String, AssemblyConnectorData> c : this.originalAssemblyConnectors.entrySet()) {
            if (!operationRequiredRoleId.equals(c.getValue().operationRequiredRoleId)) continue;
            return true;
        }
        return false;
    }

    private void handleAssemblyConnector(AssemblyConnector c, PCMInstance pcmToAdopt) {
        String currentId = c.getId();
        AssemblyConnectorData acd = this.originalAssemblyConnectors.get(currentId);
        System system = pcmToAdopt.getSystem();
        boolean original = true;
        original = original && c.getProvidedRole_AssemblyConnector().getProvidedInterface__OperationProvidedRole().getId().equals(acd.operationProvidedRoleInterfaceId);
        original = original && c.getRequiredRole_AssemblyConnector().getRequiredInterface__OperationRequiredRole().getId().equals(acd.operationRequiredRoleInterfaceId);
        original = original && c.getProvidingAssemblyContext_AssemblyConnector().getId().equals(acd.providedAssemblyContextId);
        original = original && c.getRequiringAssemblyContext_AssemblyConnector().getId().equals(acd.requiredAssemblyContextId);
        boolean bl = original = original && c.getEntityName().equals(acd.name);
        if (original) {
            return;
        }
        AssemblyConnector requiredEnd = (AssemblyConnector)FCCUnweaver.getConnectorBy(system, String.valueOf(currentId) + "-requiredEnd");
        system.getConnectors__ComposedStructure().remove((Object)requiredEnd);
        system.getConnectors__ComposedStructure().remove((Object)c);
        AssemblyConnector assemblyConnector = CompositionFactory.eINSTANCE.createAssemblyConnector();
        assemblyConnector.setEntityName(acd.name);
        assemblyConnector.setId(currentId);
        AssemblyContext ctxReq = this.getAssemblyContextById(system, acd.requiredAssemblyContextId);
        assemblyConnector.setRequiringAssemblyContext_AssemblyConnector(ctxReq);
        assemblyConnector.setRequiredRole_AssemblyConnector(this.getRoleByRequiredInterfaceId(pcmToAdopt, ctxReq, acd.operationRequiredRoleInterfaceId, acd.operationRequiredRoleId));
        AssemblyContext ctxPro = this.getAssemblyContextById(system, acd.providedAssemblyContextId);
        assemblyConnector.setProvidingAssemblyContext_AssemblyConnector(ctxPro);
        assemblyConnector.setProvidedRole_AssemblyConnector(this.getRoleByProvidedInterfaceId(pcmToAdopt, ctxPro, acd.operationProvidedRoleInterfaceId, acd.operationProvidedRoleId));
        system.getConnectors__ComposedStructure().add((Object)assemblyConnector);
    }

    private static Connector getConnectorBy(System pcmSystem, String connectorID) {
        for (Connector connector : pcmSystem.getConnectors__ComposedStructure()) {
            if (!connector.getId().equals(connectorID)) continue;
            return connector;
        }
        return null;
    }

    private AssemblyContext getAssemblyContextById(System system, String id) {
        for (AssemblyContext ac : system.getAssemblyContexts__ComposedStructure()) {
            if (!ac.getId().equals(id)) continue;
            return ac;
        }
        return null;
    }

    private OperationProvidedRole getRoleByProvidedInterfaceId(PCMInstance pcmInstance, AssemblyContext ctxPro, String operationProvidedRoleInterfaceId, String operationProvidedRoleId) {
        OperationProvidedRole opr = this.getOperationProvidedRoleById(ctxPro, operationProvidedRoleInterfaceId);
        return opr;
    }

    private OperationProvidedRole getOperationProvidedRoleById(AssemblyContext ctxPro, String operationProvidedRoleInterfaceId) {
        for (ProvidedRole role : ctxPro.getEncapsulatedComponent__AssemblyContext().getProvidedRoles_InterfaceProvidingEntity()) {
            EList xRefs = role.eCrossReferences();
            xRefs.removeIf(r -> !(r instanceof Identifier) || !((Identifier)r).getId().equals(operationProvidedRoleInterfaceId));
            if (xRefs.isEmpty()) continue;
            return (OperationProvidedRole)role;
        }
        return null;
    }

    private OperationRequiredRole getRoleByRequiredInterfaceId(PCMInstance pcmInstance, AssemblyContext ctxReq, String operationRequiredRoleInterfaceId, String operationRequiredRoleId) {
        OperationRequiredRole orr = this.getOperationRequiredRoleById(ctxReq, operationRequiredRoleInterfaceId);
        return orr;
    }

    private OperationRequiredRole getOperationRequiredRoleById(AssemblyContext ctxReq, String operationRequiredRoleInterfaceId) {
        for (RequiredRole role : ctxReq.getEncapsulatedComponent__AssemblyContext().getRequiredRoles_InterfaceRequiringEntity()) {
            EList xRefs = role.eCrossReferences();
            xRefs.removeIf(r -> !(r instanceof Identifier) || !((Identifier)r).getId().equals(operationRequiredRoleInterfaceId));
            if (xRefs.isEmpty()) continue;
            return (OperationRequiredRole)role;
        }
        return null;
    }

    private void handleProvidedDelegationConnector(ProvidedDelegationConnector c, PCMInstance pcmToAdopt) {
        throw new IllegalAccessError();
    }

    private Set<String> saveOriginalAllocationContexts(Allocation allocation) {
        HashSet<String> result = new HashSet<String>();
        for (AllocationContext alloc : allocation.getAllocationContexts_Allocation()) {
            result.add(alloc.getId());
        }
        return result;
    }

    private Set<String> saveOriginalAssemblyContexts(System system) {
        HashSet<String> result = new HashSet<String>();
        for (AssemblyContext ac : system.getAssemblyContexts__ComposedStructure()) {
            result.add(ac.getId());
        }
        return result;
    }

    private Map<String, ProvidedDelegationConnectorData> saveOriginalProvidedDelegationConnectors(System pcmSystem) {
        HashMap<String, ProvidedDelegationConnectorData> result = new HashMap<String, ProvidedDelegationConnectorData>();
        for (Connector c : pcmSystem.getConnectors__ComposedStructure()) {
            if (!(c instanceof ProvidedDelegationConnector)) continue;
            ProvidedDelegationConnector pcd = (ProvidedDelegationConnector)c;
            result.put(pcd.getId(), new ProvidedDelegationConnectorData(pcd));
        }
        return result;
    }

    private Map<String, AssemblyConnectorData> saveOriginalAssemblyConnectors(System pcmSystem) {
        HashMap<String, AssemblyConnectorData> result = new HashMap<String, AssemblyConnectorData>();
        for (Connector c : pcmSystem.getConnectors__ComposedStructure()) {
            if (!(c instanceof AssemblyConnector)) continue;
            AssemblyConnector ac = (AssemblyConnector)c;
            result.put(ac.getId(), new AssemblyConnectorData(ac));
        }
        return result;
    }

    private Map<String, ExternalCallActionData> saveOriginalExternalCalls(System system) {
        HashMap<String, ExternalCallActionData> result = new HashMap<String, ExternalCallActionData>();
        for (AssemblyContext ac : system.getAssemblyContexts__ComposedStructure()) {
            BasicComponent comp = (BasicComponent)ac.getEncapsulatedComponent__AssemblyContext();
            for (ServiceEffectSpecification seff : comp.getServiceEffectSpecifications__BasicComponent()) {
                for (ExternalCallAction externalCallAction : this.getExternalCallActions((ResourceDemandingBehaviour)seff)) {
                    result.put(externalCallAction.getId(), new ExternalCallActionData((RepositoryComponent)comp, externalCallAction.getRole_ExternalService()));
                }
            }
        }
        return result;
    }

    private List<ExternalCallAction> getExternalCallActions(ResourceDemandingBehaviour seff) {
        ArrayList<ExternalCallAction> result = new ArrayList<ExternalCallAction>();
        EList actions = seff.getSteps_Behaviour();
        for (AbstractAction abstractAction : actions) {
            if (abstractAction instanceof ExternalCallAction) {
                result.add((ExternalCallAction)abstractAction);
                continue;
            }
            if (abstractAction instanceof BranchAction) {
                EList branches = ((BranchAction)abstractAction).getBranches_Branch();
                for (AbstractBranchTransition abstractBranchTransition : branches) {
                    result.addAll(this.getExternalCallActions(abstractBranchTransition.getBranchBehaviour_BranchTransition()));
                }
                continue;
            }
            if (abstractAction instanceof AbstractLoopAction) {
                result.addAll(this.getExternalCallActions(((AbstractLoopAction)abstractAction).getBodyBehaviour_Loop()));
                continue;
            }
            if (!(abstractAction instanceof ForkAction)) continue;
            EList forkedSEFFs = ((ForkAction)abstractAction).getAsynchronousForkedBehaviours_ForkAction();
            for (ForkedBehaviour forkedBehaviour : forkedSEFFs) {
                result.addAll(this.getExternalCallActions((ResourceDemandingBehaviour)forkedBehaviour));
            }
        }
        return result;
    }
}

