/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.view.plantuml.generator;

import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingEntity;
import org.palladiosimulator.pcm.core.entity.NamedElement;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.CompositeComponent;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.view.plantuml.generator.UmlDiagramSupplier;

public class PcmSystemDiagramGenerator
implements UmlDiagramSupplier {
    private static final String COLON = " : ";
    private static final String COMPONENT_START = "[";
    private static final String COMPONENT_END = "]";
    private static final String CURLY_OPENING_BRACKET = "{";
    private static final String CURLY_CLOSING_BRACKET = "}";
    private static final String DEFAULT_NAME = "System";
    private static final String INTERFACE_START = "(";
    private static final String INTERFACE_END = ")";
    private static final String LINK_START = "[[";
    private static final String LINK_END = "]]";
    private static final String NEWLINE = "\n";
    private static final String PORT = "port ";
    private static final String PROVIDES_REQUIRES_LINK = " -(0- ";
    private static final String RECTANGLE_KEYWORD = "rectangle";
    private static final String SIMPLE_LINK = " - ";
    private static final String SPACE = " ";
    private final StringBuilder builder = new StringBuilder();
    private final List<BasicComponent> components;
    private final List<Connector> connectors;
    private final String diagramText;
    private final List<String> providedRoles;
    private final String systemName;

    public PcmSystemDiagramGenerator(System system) {
        this.systemName = this.getSystemName(Objects.requireNonNull(system));
        this.components = system.getAssemblyContexts__ComposedStructure().stream().filter(c -> c != null).map(AssemblyContext::getEncapsulatedComponent__AssemblyContext).filter(c -> c != null && c.getEntityName() != null && !c.getEntityName().isBlank()).distinct().filter(BasicComponent.class::isInstance).map(BasicComponent.class::cast).sorted(UmlDiagramSupplier.byName()).toList();
        this.connectors = system.getConnectors__ComposedStructure().stream().filter(c -> c != null && c.getEntityName() != null && !c.getEntityName().isBlank()).distinct().sorted(UmlDiagramSupplier.byName()).toList();
        this.providedRoles = system.getProvidedRoles_InterfaceProvidingEntity().stream().filter(r -> r != null).map(NamedElement::getEntityName).filter(n -> n != null && !n.isBlank()).map(UmlDiagramSupplier::escape).distinct().sorted().toList();
        this.diagramText = this.components.isEmpty() ? "" : this.getSystemDiagramText();
    }

    private void appendAssemblyConnector(AssemblyConnector connector) {
        RepositoryComponent requiring = connector.getRequiringAssemblyContext_AssemblyConnector().getEncapsulatedComponent__AssemblyContext();
        RepositoryComponent providing = connector.getProvidingAssemblyContext_AssemblyConnector().getEncapsulatedComponent__AssemblyContext();
        if (this.components.contains(requiring) && this.components.contains(providing)) {
            this.builder.append(COMPONENT_START);
            this.builder.append(UmlDiagramSupplier.escape(requiring.getEntityName()));
            this.builder.append(COMPONENT_END);
            this.builder.append(PROVIDES_REQUIRES_LINK);
            this.builder.append(COMPONENT_START);
            this.builder.append(UmlDiagramSupplier.escape(providing.getEntityName()));
            this.builder.append(COMPONENT_END);
            this.builder.append(COLON);
            this.builder.append(UmlDiagramSupplier.escape(connector.getProvidedRole_AssemblyConnector().getEntityName()));
            this.builder.append(NEWLINE);
        }
    }

    private void appendComponent(BasicComponent component) {
        this.builder.append(COMPONENT_START);
        this.builder.append(UmlDiagramSupplier.escape(component.getEntityName()));
        this.builder.append(COMPONENT_END);
        this.builder.append(SPACE);
        this.builder.append(LINK_START);
        this.builder.append(UmlDiagramSupplier.getEObjectHyperlink((EObject)component.getRepository__RepositoryComponent()));
        this.builder.append(LINK_END);
        this.builder.append(NEWLINE);
    }

    private void appendProvidedDelConnector(ProvidedDelegationConnector connector) {
        String innerProvidedRole = UmlDiagramSupplier.escape(connector.getInnerProvidedRole_ProvidedDelegationConnector().getEntityName());
        InterfaceProvidingEntity providingEntity = connector.getInnerProvidedRole_ProvidedDelegationConnector().getProvidingEntity_ProvidedRole();
        if (providingEntity instanceof CompositeComponent var4_5) {
            providingEntity = (InterfaceProvidingEntity)composite.getConnectors__ComposedStructure().stream().filter(ProvidedDelegationConnector.class::isInstance).map(ProvidedDelegationConnector.class::cast).filter(c -> c != null && c.getEntityName() != null && !c.getEntityName().isBlank()).distinct().sorted(UmlDiagramSupplier.byName()).filter(c -> UmlDiagramSupplier.escape(c.getOuterProvidedRole_ProvidedDelegationConnector().getEntityName()).equals(innerProvidedRole)).findFirst().map(ProvidedDelegationConnector::getAssemblyContext_ProvidedDelegationConnector).map(AssemblyContext::getEncapsulatedComponent__AssemblyContext).orElse((RepositoryComponent)((CompositeComponent)providingEntity));
        }
        if (this.components.contains(providingEntity)) {
            this.builder.append(PORT);
            this.builder.append(innerProvidedRole);
            this.builder.append(NEWLINE);
            this.builder.append(UmlDiagramSupplier.escape(connector.getOuterProvidedRole_ProvidedDelegationConnector().getEntityName()));
            this.builder.append(SIMPLE_LINK);
            this.builder.append(innerProvidedRole);
            this.builder.append(NEWLINE);
            this.builder.append(innerProvidedRole);
            this.builder.append(SIMPLE_LINK);
            this.builder.append(COMPONENT_START);
            this.builder.append(UmlDiagramSupplier.escape(providingEntity.getEntityName()));
            this.builder.append(COMPONENT_END);
            this.builder.append(NEWLINE);
        }
    }

    private void appendProvidedRole(String role) {
        this.builder.append(INTERFACE_START);
        this.builder.append(INTERFACE_END);
        this.builder.append(SPACE);
        this.builder.append(role);
        this.builder.append(NEWLINE);
    }

    private void appendSystemEnd() {
        this.builder.append(CURLY_CLOSING_BRACKET);
        this.builder.append(NEWLINE);
    }

    private void appendSystemStart(String name) {
        this.builder.append(RECTANGLE_KEYWORD);
        this.builder.append(SPACE);
        this.builder.append(name);
        this.builder.append(SPACE);
        this.builder.append(CURLY_OPENING_BRACKET);
        this.builder.append(NEWLINE);
    }

    @Override
    public String get() {
        return this.diagramText;
    }

    private String getSystemDiagramText() {
        this.builder.append("skinparam fixCircleLabelOverlapping true");
        this.builder.append(NEWLINE);
        this.builder.append("skinparam componentStyle uml2");
        this.builder.append(NEWLINE);
        this.providedRoles.forEach(this::appendProvidedRole);
        this.appendSystemStart(this.systemName);
        this.components.forEach(this::appendComponent);
        for (Connector connector : this.connectors) {
            if (connector instanceof AssemblyConnector) {
                this.appendAssemblyConnector((AssemblyConnector)connector);
                continue;
            }
            if (!(connector instanceof ProvidedDelegationConnector)) continue;
            this.appendProvidedDelConnector((ProvidedDelegationConnector)connector);
        }
        this.appendSystemEnd();
        return this.builder.toString();
    }

    private String getSystemName(System system) {
        if (system == null || system.getEntityName() == null || system.getEntityName().isBlank()) {
            return DEFAULT_NAME;
        }
        String name = UmlDiagramSupplier.escape(system.getEntityName());
        if (name.isBlank() || "null".equalsIgnoreCase(name) || "aName".equalsIgnoreCase(name)) {
            return DEFAULT_NAME;
        }
        return name;
    }
}

