/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.view.plantuml;

import java.util.ArrayList;
import java.util.Collection;
import net.sourceforge.plantuml.ecore.AbstractEcoreDiagramIntentProvider;
import net.sourceforge.plantuml.text.AbstractDiagramIntent;
import net.sourceforge.plantuml.util.DiagramIntent;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.view.plantuml.PcmAllocationDiagramIntent;
import org.palladiosimulator.view.plantuml.PcmComponentDiagramIntent;
import org.palladiosimulator.view.plantuml.PcmSystemDiagramIntent;

public class PcmDiagramIntentProvider
extends AbstractEcoreDiagramIntentProvider {
    private static boolean isPcmAllocationObject(Object object) {
        return object != null && object instanceof Allocation;
    }

    private static boolean isPcmRepositoryObject(Object object) {
        return object != null && object instanceof Repository;
    }

    private static boolean isPcmSystemObject(Object object) {
        return object != null && object instanceof System;
    }

    public PcmDiagramIntentProvider() {
    }

    protected PcmDiagramIntentProvider(Class<?> editorType) {
        super(editorType);
    }

    protected Collection<? extends DiagramIntent> getDiagramInfos(EObject eObject) {
        ArrayList<AbstractDiagramIntent> diagrams = new ArrayList<AbstractDiagramIntent>();
        if (PcmDiagramIntentProvider.isPcmRepositoryObject(eObject)) {
            diagrams.add(new PcmComponentDiagramIntent((Repository)eObject));
        } else if (PcmDiagramIntentProvider.isPcmSystemObject(eObject)) {
            diagrams.add(new PcmSystemDiagramIntent((System)eObject));
        } else if (PcmDiagramIntentProvider.isPcmAllocationObject(eObject)) {
            diagrams.add(new PcmAllocationDiagramIntent((Allocation)eObject));
        }
        return diagrams;
    }

    protected boolean supportsEObject(EObject object) {
        return true;
    }

    protected Boolean supportsPath(IPath path) {
        if (!"ecore".equals(path.getFileExtension()) && !"xmi".equals(path.getFileExtension())) {
            return false;
        }
        return true;
    }
}

