/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.regression.r;

import de.fzi.power.regression.r.AbstractRegression;
import de.fzi.power.regression.r.ConstantModelParameter;
import de.fzi.power.regression.r.DoubleModelParameter;
import de.fzi.power.regression.r.FunctionExpressionExportTripleProvider;
import de.fzi.power.regression.r.TargetMeasurements;
import de.fzi.power.regression.r.VariableMeasurements;
import de.fzi.power.regression.r.expressionoasis.ExportTriple;
import de.fzi.power.regression.r.expressionoasis.ExportTripleProvider;
import de.fzi.power.regression.r.expressionoasis.ExportVisitor;
import de.fzi.power.regression.r.expressionoasis.SimpleTriple;
import de.fzi.power.regression.r.io.RRegressionConnection;
import de.fzi.power.regression.r.io.RRegressionConnectionImpl;
import de.fzi.power.regression.r.io.RUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.measure.Measure;
import javax.measure.quantity.Quantity;
import org.apache.log4j.Logger;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPMismatchException;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.Expression;
import org.vedantatree.expressionoasis.expressions.IdentifierExpression;
import org.vedantatree.expressionoasis.expressions.NumericExpression;
import org.vedantatree.expressionoasis.expressions.arithmatic.AddExpression;
import org.vedantatree.expressionoasis.expressions.arithmatic.DivideExpression;
import org.vedantatree.expressionoasis.expressions.arithmatic.MinusExpression;
import org.vedantatree.expressionoasis.expressions.arithmatic.MultiplyExpression;
import org.vedantatree.expressionoasis.expressions.arithmatic.ParanthesisExpression;
import org.vedantatree.expressionoasis.expressions.arithmatic.SubtractExpression;
import org.vedantatree.expressionoasis.expressions.property.ArgumentExpression;
import org.vedantatree.expressionoasis.expressions.property.FunctionExpression;

public abstract class AbstractNonLinearRegression<Q extends Quantity>
extends AbstractRegression<Q> {
    private static final String R_START_PARAMETERS = "startParameters";
    private static final String R_X_PARAM = "xParam";
    private Expression expression;
    private List<ConstantModelParameter<?, ? extends Quantity>> constants;
    private static final Logger LOGGER = Logger.getLogger((String)AbstractNonLinearRegression.class.getName());

    public AbstractNonLinearRegression(Expression expression, List<VariableMeasurements> measurements, List<ConstantModelParameter<?, ? extends Quantity>> constants, TargetMeasurements targetMetric) {
        super(targetMetric, measurements);
        this.expression = expression;
        this.constants = constants;
    }

    public List<DoubleModelParameter<? extends Quantity>> deriveParameters() {
        this.assignStartParameters();
        int idx = 0;
        while (idx < 50) {
            try {
                this.constructModel();
                break;
            }
            catch (IllegalStateException e) {
                this.calculateLogStartingValues();
                try {
                    LOGGER.error((Object)("Trying parameter starting values on log term. Iteration: " + idx + "\nStarting values of log term: " + Arrays.toString(RRegressionConnectionImpl.getRRegressionConnection().execute(R_START_PARAMETERS).get(0).asDoubles())));
                }
                catch (REXPMismatchException e1) {
                    e1.printStackTrace();
                }
                ++idx;
            }
        }
        List<DoubleModelParameter<? extends Quantity>> modelParameters = this.getResults();
        return modelParameters;
    }

    private void calculateLogStartingValues() {
        StringBuilder commandString = new StringBuilder("coef(nlsLM(");
        commandString.append("log(" + RUtils.sanitizeNameForR(this.targetMetric.getName()) + ")");
        commandString.append("~");
        commandString.append("log(" + this.getFormula() + ")");
        commandString.append(", ");
        commandString.append("data = df");
        commandString.append(", control=c(maxiter=5000, minFactor=1/4096), ");
        commandString.append(String.valueOf(this.getStartValuesAssignString()) + ")" + ");");
        RRegressionConnection rConnection = RRegressionConnectionImpl.getRRegressionConnection();
        rConnection.execute("startParameters <- " + commandString.toString());
    }

    private List<DoubleModelParameter<? extends Quantity>> getResults() {
        RRegressionConnection rConnection = RRegressionConnectionImpl.getRRegressionConnection();
        Vector<REXP> rawResults = rConnection.execute(this.buildReadResultsCommand("targetValue"));
        double[] values = null;
        String[] names = null;
        try {
            values = rawResults.get(0).asDoubles();
            names = rawResults.get(1).asStrings();
        }
        catch (REXPMismatchException e) {
            LOGGER.error((Object)("Error converting regression results: " + e.toString()));
        }
        ArrayList<DoubleModelParameter<? extends Quantity>> modelParameters = new ArrayList<DoubleModelParameter<? extends Quantity>>();
        int i = 0;
        while (i < values.length) {
            modelParameters.add(new DoubleModelParameter(names[i], Measure.valueOf((double)values[i], this.constants.get(i).getUnit())));
            ++i;
        }
        if (values.length != names.length) {
            throw new RuntimeException("The parameter name description and the values in the R result vector do not fit.");
        }
        return modelParameters;
    }

    @Override
    public String getFormula() {
        ExportVisitor visitor = new ExportVisitor(this.createRCompatibleExportVisitorConfiguration());
        this.expression.accept(visitor);
        return visitor.toString();
    }

    private String getRegressionStartValues(List<ConstantModelParameter<?, ? extends Quantity>> constants) {
        StringBuilder commandString = new StringBuilder();
        Iterator<ConstantModelParameter<?, Quantity>> measurementsIt = constants.iterator();
        while (measurementsIt.hasNext()) {
            ConstantModelParameter<?, Quantity> next = measurementsIt.next();
            commandString.append(RUtils.sanitizeNameForR(next.getName()));
            commandString.append("=");
            commandString.append(next.getValue().getValue().toString());
            if (!measurementsIt.hasNext()) continue;
            commandString.append(", ");
        }
        return commandString.toString();
    }

    public Map<Class<?>, ExportTripleProvider<String>> createRCompatibleExportVisitorConfiguration() {
        HashMap configuration = new HashMap();
        HashMap functionExpressions = new HashMap();
        functionExpressions.put("exp", new SimpleTriple("exp", "", ""));
        functionExpressions.put("pow", new ExportTripleProvider<String>(){

            @Override
            public ExportTriple<String> getExportTriple(Expression expression, ExportVisitor<String> rExportVisitor) {
                rExportVisitor.getFunctionParameterSeparatorStack().push("^");
                return new SimpleTriple("", "", "");
            }
        });
        configuration = new HashMap();
        configuration.put(MultiplyExpression.class, new SimpleTriple("", "*", ""));
        configuration.put(AddExpression.class, new SimpleTriple("", "+", ""));
        configuration.put(SubtractExpression.class, new SimpleTriple("", "-", ""));
        configuration.put(DivideExpression.class, new SimpleTriple("", "/", ""));
        configuration.put(ParanthesisExpression.class, new SimpleTriple("(", "", ")"));
        configuration.put(MinusExpression.class, new SimpleTriple("-", "", ""));
        configuration.put(ArgumentExpression.class, new ExportTripleProvider<String>(){

            @Override
            public ExportTriple<String> getExportTriple(Expression expression, ExportVisitor<String> rExportVisitor) {
                return new SimpleTriple("", rExportVisitor.getFunctionParameterSeparatorStack().pop(), "");
            }
        });
        configuration.put(FunctionExpression.class, new FunctionExpressionExportTripleProvider(functionExpressions));
        configuration.put(IdentifierExpression.class, new ExportTripleProvider<String>(){

            @Override
            public ExportTriple<String> getExportTriple(Expression expression, ExportVisitor<String> visitor) {
                return new SimpleTriple(((IdentifierExpression)expression).getIdentifierName(), "", "");
            }
        });
        configuration.put(NumericExpression.class, new ExportTripleProvider<String>(){

            @Override
            public ExportTriple<String> getExportTriple(Expression expression, ExportVisitor<String> visitor) {
                try {
                    return new SimpleTriple(((NumericExpression)expression).getValue().getValue().toString(), "", "");
                }
                catch (ExpressionEngineException e) {
                    LOGGER.error((Object)("Could not instantiate expression: " + e.toString()));
                    return null;
                }
            }
        });
        return configuration;
    }

    public File generateVectorPlot(int graphicsWidth, int graphicsHeight, int fontSize) throws IOException {
        RRegressionConnection rConnection = RRegressionConnectionImpl.getRRegressionConnection();
        File pngFile = File.createTempFile("regression_plot", ".png");
        pngFile.deleteOnExit();
        String rCommand = "";
        rCommand = String.valueOf(rCommand) + "png(\"" + pngFile.getAbsolutePath().replace("\\", "\\\\") + "\",height=" + graphicsHeight + ",width=" + graphicsWidth + ")\n";
        rCommand = String.valueOf(rCommand) + this.generatePlotCommand();
        rCommand = String.valueOf(rCommand) + "dev.off()\n";
        try {
            rConnection.execute(rCommand);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return pngFile;
    }

    private String generatePlotCommand() {
        StringBuilder rCommandBuilder = new StringBuilder();
        rCommandBuilder.append("fitFnc <- function(xParam) predict(targetValue, list(" + ((VariableMeasurements)this.measurements.get(0)).getName() + "=" + R_X_PARAM + ")" + ")" + "\n");
        rCommandBuilder.append("plot.new()\n");
        rCommandBuilder.append("curve(fitFnc, from=0, to=1, col=563,  xlab=\"" + ((VariableMeasurements)this.measurements.get(0)).getName() + "\"" + ", " + "ylab=\"" + this.targetMetric.getUnit() + "\"" + ")" + "\n");
        rCommandBuilder.append("points(df, pch=3)\n");
        rCommandBuilder.append("curve(fitFnc, add=TRUE, col=563)\n");
        return rCommandBuilder.toString();
    }

    @Override
    public Iterable<String> getRequiredPackages() {
        return new ArrayList<String>(0);
    }

    private String buildReadResultsCommand(String resultName) {
        return "coef(" + resultName + ");\n" + "names(coef(" + resultName + "));\n";
    }

    @Override
    protected String getAdditionalParameters() {
        return "control=c(maxiter=5000, minFactor=1/4096), " + this.getStartValuesAssignString();
    }

    private String getStartValuesAssignString() {
        return "start=startParameters";
    }

    private void assignStartParameters() {
        RRegressionConnectionImpl.getRRegressionConnection().execute("startParameters <- list(" + this.getRegressionStartValues(this.constants) + ")");
    }

    public Double getAIC() {
        RRegressionConnection rConnection = RRegressionConnectionImpl.getRRegressionConnection();
        Vector<REXP> results = rConnection.execute("AIC(targetValue)");
        try {
            return results.get(0).asDouble();
        }
        catch (REXPMismatchException e) {
            LOGGER.error((Object)("Error calculating AIC: " + e.toString()));
            return null;
        }
    }
}

