/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.regression.r;

import de.fzi.power.regression.r.Measurements;
import de.fzi.power.regression.r.TargetMeasurements;
import de.fzi.power.regression.r.VariableMeasurements;
import de.fzi.power.regression.r.io.RRegressionConnection;
import de.fzi.power.regression.r.io.RRegressionConnectionImpl;
import de.fzi.power.regression.r.io.RUtils;
import java.util.List;
import java.util.Vector;
import javax.measure.quantity.Quantity;
import org.rosuda.REngine.REXP;

public abstract class AbstractRegression<Q extends Quantity> {
    protected static final String FIT_FNC = "fitFnc";
    protected static final String DATA_FRAME_NAME = "df";
    protected static final String R_REGRESSION_RELATIONHSIP_OPERATOR = "~";
    protected static final String R_PARAM_SEPARATOR = ", ";
    protected static final String R_START_PARAM_NAME_ASSIGN = "start=";
    protected static final String R_START_VALUES_BLOCK = "list(";
    protected static final String R_START_VALUE_ASSIGNMENT_OPERATOR = "=";
    protected static final String R_BLOCK_END = ")";
    protected static final String R_ADDITIONAL_COMMAND = "control=c(maxiter=5000, minFactor=1/4096)";
    protected static final String R_COMMAND_POSTFIX = ");";
    protected static final String R_TARGET_NAME = "targetValue";
    protected static final String R_ASSIGNMENT_OPERATOR = " <- ";
    protected static final String R_ACCESSOR = "$";
    protected TargetMeasurements targetMetric;
    protected List<VariableMeasurements> measurements;

    public AbstractRegression(TargetMeasurements targetMetric, List<VariableMeasurements> measurements) {
        this.targetMetric = targetMetric;
        this.measurements = measurements;
    }

    protected void constructModel() {
        RRegressionConnection rConnection = RRegressionConnectionImpl.getRRegressionConnection();
        RUtils.ensurePackageAvailability(this.getRequiredPackages(), rConnection);
        String formula = this.getFormula();
        String targetName = RUtils.sanitizeNameForR(this.targetMetric.getName());
        rConnection.assign(targetName, this.targetMetric.getValues());
        StringBuilder dataFrameBuilder = new StringBuilder("df <- data.frame(");
        for (Measurements measurements : this.measurements) {
            rConnection.assign(measurements.getName(), measurements.getValues());
            dataFrameBuilder.append(String.valueOf(measurements.getName()) + R_PARAM_SEPARATOR);
        }
        dataFrameBuilder.append(targetName);
        dataFrameBuilder.append(R_BLOCK_END);
        String string = dataFrameBuilder.toString();
        rConnection.execute(string);
        StringBuilder commandString = this.constructRegularRegressionExpression(formula);
        String command = commandString.toString();
        rConnection.execute("set.seed(47)");
        Vector<REXP> rawResults = rConnection.execute("targetValue  <- " + command);
    }

    private StringBuilder constructRegularRegressionExpression(String formula) {
        StringBuilder commandString = new StringBuilder(this.getFunctionName());
        commandString.append(RUtils.sanitizeNameForR(this.targetMetric.getName()));
        commandString.append(R_REGRESSION_RELATIONHSIP_OPERATOR);
        commandString.append(formula);
        commandString.append(R_PARAM_SEPARATOR);
        commandString.append("data = df");
        String params = this.getAdditionalParameters();
        if (params != null && !params.equals("")) {
            commandString.append(R_PARAM_SEPARATOR + params);
        }
        commandString.append(R_COMMAND_POSTFIX);
        return commandString;
    }

    public abstract String getFormula();

    public abstract Iterable<String> getRequiredPackages();

    public abstract String getFunctionName();

    protected abstract String getAdditionalParameters();
}

