/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.regression.r;

import de.fzi.power.regression.r.AbstractRegression;
import de.fzi.power.regression.r.TargetMeasurements;
import de.fzi.power.regression.r.VariableMeasurements;
import de.fzi.power.regression.r.expressionoasis.ExpressionUtil;
import de.fzi.power.regression.r.io.RRegressionConnection;
import de.fzi.power.regression.r.io.RRegressionConnectionImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.measure.quantity.Quantity;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.RList;
import org.vedantatree.expressionoasis.expressions.Expression;

public class SymbolicRegression<Q extends Quantity>
extends AbstractRegression<Q> {
    private static final String R_PACKAGE_NAME = "rgp";
    private static final String R_COMMAND_PREFIX = "symbolicRegression(";
    private static final String R_SIMPLIFY_PACKAGE = "Deriv";
    private static final String LAPPLY = "lapply(";
    private static final String R_ELITE = "elite";
    private int numberOfSteps;

    public SymbolicRegression(List<VariableMeasurements> measurements, TargetMeasurements targetMetric) {
        this(measurements, targetMetric, 10000);
    }

    public SymbolicRegression(List<VariableMeasurements> measurements, TargetMeasurements targetMetric, int numberOfSteps) {
        super(targetMetric, measurements);
        this.numberOfSteps = numberOfSteps;
    }

    @Override
    public String getFunctionName() {
        return R_COMMAND_PREFIX;
    }

    @Override
    public Iterable<String> getRequiredPackages() {
        return Arrays.asList(R_PACKAGE_NAME, R_SIMPLIFY_PACKAGE);
    }

    @Override
    public String getFormula() {
        Iterator iterator = this.measurements.iterator();
        StringBuilder formulaBuilder = new StringBuilder();
        formulaBuilder.append(((VariableMeasurements)iterator.next()).getName());
        while (iterator.hasNext()) {
            formulaBuilder.append(" + " + ((VariableMeasurements)iterator.next()).getName());
        }
        return formulaBuilder.toString();
    }

    @Override
    protected String getAdditionalParameters() {
        return "functionSet=mathFunctionSet, stopCondition=makeStepsStopCondition(" + this.numberOfSteps + ")" + ", " + "penalizeGenotypeConstantIndividuals = TRUE";
    }

    public List<Expression> getEliteResults() {
        this.constructModel();
        RRegressionConnection rConnection = RRegressionConnectionImpl.getRRegressionConnection();
        Vector<REXP> rawElite = rConnection.execute("lapply(lapply(targetValue$elite, Simplify), deparse)");
        RList asList = null;
        try {
            asList = rawElite.get(0).asList();
        }
        catch (REXPMismatchException e) {
            e.printStackTrace();
        }
        ArrayList<Expression> expressionList = new ArrayList<Expression>();
        for (Object curObj : asList) {
            REXPString curString = (REXPString)curObj;
            String expressionString = null;
            expressionString = Arrays.stream(curString.asStrings()).reduce("", String::concat);
            expressionString = Pattern.compile("function \\((.*?)\\)").matcher(expressionString).replaceAll("").trim();
            Expression curExpression = ExpressionUtil.createFromRFunction(expressionString);
            expressionList.add(curExpression);
        }
        return expressionList;
    }
}

