/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.regression.r.expressionoasis;

import de.fzi.power.regression.r.expressionoasis.ExportTriple;
import de.fzi.power.regression.r.expressionoasis.ExportTripleProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.vedantatree.expressionoasis.expressions.BinaryOperatorExpression;
import org.vedantatree.expressionoasis.expressions.Expression;
import org.vedantatree.expressionoasis.expressions.ExpressionVisitor;
import org.vedantatree.expressionoasis.expressions.UnaryOperatorExpression;

public class ExportVisitor<T>
implements ExpressionVisitor {
    private VisitorStackFrame<T> rootFrame;
    private Stack<VisitorStackFrame<T>> frameStack;
    private Stack<String> functionParameterSeparatorStack;
    private Map<Class<?>, ExportTripleProvider<T>> exportDescription;

    public ExportVisitor(Map<Class<?>, ExportTripleProvider<T>> exportDescription) {
        this.exportDescription = exportDescription;
        this.frameStack = new Stack();
        this.functionParameterSeparatorStack = new Stack();
        this.rootFrame = new VisitorStackFrame(1);
        this.frameStack.push(this.rootFrame);
    }

    public void visit(Expression expression) {
        VisitorStackFrame<Object> currentFrame = this.frameStack.peek();
        if (!currentFrame.hasParametersLeft()) {
            throw new RuntimeException("ExportVisitor failed: Got Parameters where no ones where expexted");
        }
        VisitorStackFrame newFrame = null;
        if (expression instanceof BinaryOperatorExpression) {
            newFrame = new VisitorStackFrame(2);
            currentFrame.setParameter(newFrame);
            this.frameStack.push(newFrame);
            this.fillOperatorFrame(newFrame, expression);
            currentFrame = newFrame;
        } else if (expression instanceof UnaryOperatorExpression) {
            newFrame = new VisitorStackFrame(1);
            currentFrame.setParameter(newFrame);
            this.frameStack.push(newFrame);
            this.fillOperatorFrame(newFrame, expression);
            currentFrame = newFrame;
        } else {
            newFrame = new VisitorStackFrame(0);
            currentFrame.setParameter(newFrame);
            this.fillOperatorFrame(newFrame, expression);
        }
        while (!currentFrame.hasParametersLeft()) {
            if (this.frameStack.isEmpty() || this.frameStack.peek().hasParametersLeft()) break;
            currentFrame = this.frameStack.pop();
        }
    }

    private void fillOperatorFrame(VisitorStackFrame<T> newFrame, Expression expression) {
        if (!this.exportDescription.containsKey(expression.getClass())) {
            throw new RuntimeException("No export triple defined for expression: " + expression.toString());
        }
        ExportTriple<T> triple = this.exportDescription.get(expression.getClass()).getExportTriple(expression, this);
        if (triple == null) {
            throw new RuntimeException("No export triple defined for expression: " + expression.toString());
        }
        newFrame.setSeparator(triple.getSeparator());
        newFrame.setPostfix(triple.getPostfix());
        newFrame.setPrefix(triple.getPrefix());
    }

    public String toString() {
        return this.rootFrame.toString();
    }

    public Stack<String> getFunctionParameterSeparatorStack() {
        return this.functionParameterSeparatorStack;
    }

    private class VisitorStackFrame<Q> {
        private Q prefix;
        private Q postfix;
        private Q separator;
        private int parameterCounter;
        private int expectedParameters;
        private List<VisitorStackFrame<Q>> parameterList;

        private VisitorStackFrame(int expectedParameters) {
            this.parameterList = new ArrayList<VisitorStackFrame<Q>>(expectedParameters);
            this.expectedParameters = expectedParameters;
            this.parameterCounter = 0;
        }

        public boolean hasParametersLeft() {
            return this.parameterCounter < this.expectedParameters;
        }

        public void setParameter(VisitorStackFrame<Q> frame) {
            if (this.hasParametersLeft()) {
                this.parameterList.add(frame);
                ++this.parameterCounter;
            } else {
                throw new RuntimeException("The underlying VisitorStackFrame does not expect any more parameters");
            }
        }

        public void setPrefix(Q prefix) {
            this.prefix = prefix;
        }

        public void setPostfix(Q postfix) {
            this.postfix = postfix;
        }

        public void setSeparator(Q content) {
            this.separator = content;
        }

        public List<Q> toList() {
            Vector<Q> resultVector = new Vector<Q>();
            if (this.prefix != null) {
                resultVector.add(this.prefix);
            }
            Iterator<VisitorStackFrame<Q>> iterator = this.parameterList.iterator();
            while (iterator.hasNext()) {
                resultVector.addAll(iterator.next().toList());
                if (!iterator.hasNext() || this.separator == null) continue;
                resultVector.add(this.separator);
            }
            if (this.postfix != null) {
                resultVector.add(this.postfix);
            }
            return resultVector;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (Q q : this.toList()) {
                builder.append(q.toString());
            }
            return builder.toString();
        }
    }
}

