/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.regression.r.expressionoasis;

import de.fzi.power.regression.r.FunctionExpressionExportTripleProvider;
import de.fzi.power.regression.r.expressionoasis.ExportTriple;
import de.fzi.power.regression.r.expressionoasis.ExportTripleProvider;
import de.fzi.power.regression.r.expressionoasis.ExportVisitor;
import de.fzi.power.regression.r.expressionoasis.SimpleTriple;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.vedantatree.expressionoasis.ExpressionContext;
import org.vedantatree.expressionoasis.ExpressionEngine;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.DecimalExpression;
import org.vedantatree.expressionoasis.expressions.Expression;
import org.vedantatree.expressionoasis.expressions.IdentifierExpression;
import org.vedantatree.expressionoasis.expressions.NumericExpression;
import org.vedantatree.expressionoasis.expressions.arithmatic.AddExpression;
import org.vedantatree.expressionoasis.expressions.arithmatic.DivideExpression;
import org.vedantatree.expressionoasis.expressions.arithmatic.MinusExpression;
import org.vedantatree.expressionoasis.expressions.arithmatic.MultiplyExpression;
import org.vedantatree.expressionoasis.expressions.arithmatic.ParanthesisExpression;
import org.vedantatree.expressionoasis.expressions.arithmatic.SubtractExpression;
import org.vedantatree.expressionoasis.expressions.property.ArgumentExpression;
import org.vedantatree.expressionoasis.expressions.property.FunctionExpression;

public class ExpressionUtil {
    private static final Map<Class<?>, ExportTripleProvider<String>> STRING_CONVERSION_MAPPING;
    private static final Logger LOGGER;

    static {
        LOGGER = Logger.getLogger((String)ExpressionUtil.class.getName());
        STRING_CONVERSION_MAPPING = ExpressionUtil.initStringConversionMap();
    }

    public static Expression createFromRFunction(String expressionString) {
        Expression parsedExpression = null;
        try {
            parsedExpression = ExpressionEngine.compileExpression((String)expressionString, (ExpressionContext)new ExpressionContext(), (boolean)false);
        }
        catch (ExpressionEngineException e) {
            e.printStackTrace();
        }
        return parsedExpression;
    }

    private static Map<Class<?>, ExportTripleProvider<String>> initStringConversionMap() {
        HashMap configuration = new HashMap();
        HashMap functionExpressions = new HashMap();
        functionExpressions.put("exp", new SimpleTriple("exp", "", ""));
        functionExpressions.put("pow", new SimpleTriple("pow", "", ""));
        configuration = new HashMap();
        configuration.put(MultiplyExpression.class, new SimpleTriple("", "*", ""));
        configuration.put(AddExpression.class, new SimpleTriple("", "+", ""));
        configuration.put(SubtractExpression.class, new SimpleTriple("", "-", ""));
        configuration.put(DivideExpression.class, new SimpleTriple("", "/", ""));
        configuration.put(ParanthesisExpression.class, new SimpleTriple("(", "", ")"));
        configuration.put(MinusExpression.class, new SimpleTriple("-", "", ""));
        configuration.put(DecimalExpression.class, new ExportTripleProvider<String>(){

            @Override
            public ExportTriple<String> getExportTriple(Expression expression, ExportVisitor<String> visitor) {
                try {
                    return new SimpleTriple(((DecimalExpression)expression).getValue().toString(), "", "");
                }
                catch (ExpressionEngineException e) {
                    LOGGER.error((Object)("Expression " + expression.toString() + " was not a DecimalExpression!"));
                    return null;
                }
            }
        });
        configuration.put(ArgumentExpression.class, new ExportTripleProvider<String>(){

            @Override
            public ExportTriple<String> getExportTriple(Expression expression, ExportVisitor<String> rExportVisitor) {
                return new SimpleTriple("", rExportVisitor.getFunctionParameterSeparatorStack().pop(), "");
            }
        });
        configuration.put(FunctionExpression.class, new FunctionExpressionExportTripleProvider(functionExpressions));
        configuration.put(IdentifierExpression.class, new ExportTripleProvider<String>(){

            @Override
            public ExportTriple<String> getExportTriple(Expression expression, ExportVisitor<String> visitor) {
                return new SimpleTriple(((IdentifierExpression)expression).getIdentifierName(), "", "");
            }
        });
        configuration.put(NumericExpression.class, new ExportTripleProvider<String>(){

            @Override
            public ExportTriple<String> getExportTriple(Expression expression, ExportVisitor<String> visitor) {
                try {
                    return new SimpleTriple(((NumericExpression)expression).getValue().getValue().toString(), "", "");
                }
                catch (ExpressionEngineException e) {
                    LOGGER.error((Object)("Could not instantiate expression: " + e.toString()));
                    return null;
                }
            }
        });
        configuration.put(DecimalExpression.class, new ExportTripleProvider<String>(){

            @Override
            public ExportTriple<String> getExportTriple(Expression expression, ExportVisitor<String> visitor) {
                try {
                    return new SimpleTriple(((DecimalExpression)expression).getValue().getValue().toString(), "", "");
                }
                catch (ExpressionEngineException e) {
                    LOGGER.error((Object)("Could not instantiate expression: " + e.toString()));
                    return null;
                }
            }
        });
        return configuration;
    }

    public static String convertToInputString(Expression expression) {
        ExportVisitor exportVisitor = new ExportVisitor(STRING_CONVERSION_MAPPING);
        expression.accept(exportVisitor);
        return exportVisitor.toString();
    }
}

