/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.regression.r.io;

import de.fzi.power.regression.r.io.RRegressionConnection;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RserveException;

public class RRegressionConnectionImpl
implements RRegressionConnection {
    private static final Logger LOGGER = Logger.getLogger((String)RRegressionConnectionImpl.class.getName());
    private static RConnection rengine;
    private static RRegressionConnectionImpl rConnection;

    static {
        rConnection = null;
    }

    public static RRegressionConnection getRRegressionConnection() {
        if (rConnection == null) {
            rConnection = new RRegressionConnectionImpl();
            rConnection.initalizeConnection();
            rConnection.execute("options(warn=-1)");
        }
        return rConnection;
    }

    @Override
    public void assign(String name, int[] array) {
        try {
            rengine.assign(name, array);
        }
        catch (REngineException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void assign(String name, String[] array) {
        try {
            rengine.assign(name, array);
        }
        catch (REngineException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void checkPackageAvailability(String packageName) {
        try {
            rengine.eval("options(warn=-1)");
            rengine.eval("library(" + packageName + ")");
        }
        catch (RserveException e) {
            LOGGER.error((Object)("Error while loading the library '" + packageName + "'. " + "Use 'install.packages('" + packageName + "');' to install the missing library."));
            throw new IllegalStateException(e);
        }
    }

    protected void initalizeConnection() {
        this.checkPathValidity();
        System.setProperty("jri.ignore.ule", "yes");
        try {
            rengine = new RConnection();
        }
        catch (RserveException e) {
            LOGGER.error((Object)("Creating R engine was not successful. Reason: " + e.toString()));
        }
        if (!rengine.isConnected()) {
            LOGGER.error((Object)"Creating R engine ** Waiting for the R engine to come up failed. Please check the R-output on the console for more details, as they are written to System.out and System.err");
            rengine = null;
            return;
        }
        LOGGER.info((Object)"Connection to R established successfully.");
        try {
            this.prepareEnvironment();
        }
        catch (REXPMismatchException | RserveException e) {
            LOGGER.error((Object)("Error while setting up environment. Reason: " + e.toString()));
        }
        this.checkPackageAvailability();
    }

    private void checkPackageAvailability() {
        this.checkPackageAvailability("plotrix");
    }

    private void checkPathValidity() {
        String libraryPath = System.getProperty("java.library.path");
        String[] libraryPaths = libraryPath.split(";");
        Vector<String> conflictingPaths = new Vector<String>();
        String[] stringArray = libraryPaths;
        int n = libraryPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (path.contains(" ") && !path.startsWith("\"") && !path.endsWith("\"")) {
                conflictingPaths.add(path);
            }
            ++n2;
        }
        if (!conflictingPaths.isEmpty()) {
            String formattedPath = "";
            for (String conflictPath : conflictingPaths) {
                formattedPath = String.valueOf(formattedPath) + "'" + conflictPath + "', ";
            }
            formattedPath = formattedPath.substring(0, formattedPath.length() - 2);
            LOGGER.warn((Object)("The environment variable java.library.path contains  unescaped spaces. This may lead to errors loading the necessary dynamic link libraries of R.\n\nConflicting parts of the java.library.path are: " + formattedPath + "\n\n" + "A possible solution is to set the library path to" + " point to the path containing jri.dll via the -D" + " command line switch of the java VM of by setting" + " it via the eclipse.ini file. However, this does" + " not work in all cases."));
        }
    }

    private void prepareEnvironment() throws RserveException, REXPMismatchException {
        rengine.eval("Sys.setlocale(\"LC_ALL\", \"German_Germany.1252\")");
        rengine.eval("Sys.setlocale(\"LC_NUMERIC\", \"C\")");
        rengine.eval("rUser <- chartr(\"\\\\\", \"/\", Sys.getenv(\"R_USER\"))");
        rengine.eval("rLibs <- chartr(\"\\\\\", \"/\", Sys.getenv(\"R_LIBS_USER\"))");
        rengine.eval("homedrive <- chartr(\"\\\\\", \"/\", Sys.getenv(\"HOMEDRIVE\"))");
        rengine.eval("homepath <- chartr(\"\\\\\", \"/\", Sys.getenv(\"HOMEPATH\"))");
        rengine.eval("usrLibPath <- substring(strsplit(rLibs, rUser)[[1]][2],2)");
        rengine.eval("Sys.setenv(\"R_USER\"=paste(homedrive, homepath, sep=\"\"))");
        rengine.eval("Sys.setenv(\"R_LIBS_USER\"=paste(Sys.getenv(\"R_USER\"), usrLibPath, sep=\"\")[[1]])");
        REXP envContent = rengine.eval("Sys.getenv()");
        REXP envNames = rengine.eval("names(s <- Sys.getenv())");
        String[] sEnvContent = envContent.asStrings();
        String[] sEnvNames = envNames.asStrings();
        String locale = "";
        int number = 0;
        while (number < sEnvContent.length) {
            locale = String.valueOf(locale) + sEnvNames[number] + " = " + sEnvContent[number] + "\n";
            ++number;
        }
        REXP locales = rengine.eval("Sys.getlocale()");
        String[] sLocales = locales.asStrings();
        locale = String.valueOf(locale) + "\nLocalization information:\n";
        int number2 = 0;
        while (number2 < sLocales.length) {
            locale = String.valueOf(locale) + sLocales[number2] + "\n";
            ++number2;
        }
        LOGGER.debug((Object)("Environmental Information:\n" + locale));
    }

    @Override
    public Vector<REXP> execute(String rCommands) {
        if (!RRegressionConnectionImpl.isEngineAvailable()) {
            throw new UnsupportedOperationException("Tried to execute command in R without having a R engine available.");
        }
        String[] commands = rCommands.split("\n");
        String result = "";
        REXP resultExp = null;
        Vector<REXP> resultExpArray = new Vector<REXP>();
        String[] stringArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            String command = stringArray[n2];
            try {
                resultExp = rengine.eval(command);
            }
            catch (RserveException e) {
                String cause = null;
                try {
                    cause = rengine.eval("geterrmessage()").asString();
                }
                catch (REXPMismatchException | RserveException e2) {
                    cause = "Error while identifying cause: " + e2.getMessage();
                }
                LOGGER.error((Object)String.format("Error for command \"%s\": %s", command, cause));
                throw new IllegalStateException(e);
            }
            if (resultExp != null) {
                result = String.valueOf(result) + resultExp.toString() + "\n";
                resultExpArray.add(resultExp);
            }
            ++n2;
        }
        return resultExpArray;
    }

    public static boolean isEngineAvailable() {
        return rengine != null;
    }

    @Override
    public void assign(String name, double[] array) {
        try {
            rengine.assign(name, array);
        }
        catch (REngineException e) {
            LOGGER.error((Object)("Error while assigning " + array + " to " + "name. Cause: " + e.toString()));
        }
    }
}

