/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.regression.edp2;

import de.fzi.power.regression.r.Measurements;
import de.fzi.power.regression.r.TargetMeasurements;
import de.fzi.power.regression.r.VariableMeasurements;
import de.fzi.power.specification.MeasuredFactor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.measure.Measure;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math3.util.MathArrays;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.measurementframework.measureprovider.IMeasureProvider;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;

public class EDP2RUtil {
    private static final String TARGET_METRIC_NAME = "P";

    public static List<Measurements> combineDatasets(Collection<IDataSource> measurements, Map<IDataSource, MeasuredFactor> mappedFactors, MetricDescription targetMetric) {
        measurements.stream().filter(t -> !t.getMetricDesciption().getId().equals(targetMetric.getId())).forEach(dataSource -> {
            if (!MetricDescriptionUtility.isBaseMetricDescriptionSubsumedByMetricDescription((BaseMetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC, (MetricDescription)dataSource.getMetricDesciption())) {
                throw new IllegalArgumentException("The passed metric " + dataSource.getMetricDesciption().getName() + " does not contain a time dimension.");
            }
        });
        TreeMap<Measure, Iterator> nextValuesIterators = new TreeMap<Measure, Iterator>();
        measurements.forEach(m -> {
            Iterator curIterator = m.getDataStream().iterator();
            nextValuesIterators.put(((IMeasureProvider)curIterator.next()).getMeasureForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC), curIterator);
        });
        ArrayList<Measure> sortedPointsInTime = new ArrayList<Measure>();
        Measure lastMeasure = null;
        while (!nextValuesIterators.isEmpty()) {
            Iterator curIterator;
            Measure curMeasure = (Measure)nextValuesIterators.firstKey();
            if (lastMeasure == null || curMeasure.compareTo(lastMeasure) > 0) {
                sortedPointsInTime.add(curMeasure);
            }
            if ((curIterator = (Iterator)nextValuesIterators.remove(curMeasure)).hasNext()) {
                nextValuesIterators.put(((IMeasureProvider)curIterator.next()).getMeasureForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC), curIterator);
            }
            lastMeasure = curMeasure;
        }
        ArrayList<Measurements> resultingMeasurementsList = new ArrayList<Measurements>();
        measurements.stream().filter(m -> mappedFactors.containsKey(m) || m.isCompatibleWith((MetricDescription)MetricDescriptionConstants.POWER_CONSUMPTION_TUPLE)).forEach(m -> {
            double[] timeVals = new double[m.getDataStream().size()];
            double[] targetVals = new double[timeVals.length];
            MetricDescription wantedMetric = ((MetricSetDescription)m.getMetricDesciption()).getSubsumedMetrics().stream().filter(s -> !s.getId().equals(MetricDescriptionConstants.POINT_IN_TIME_METRIC.getId())).findAny().get();
            int idx = 0;
            for (IMeasureProvider curMeasureProvider : m.getDataStream()) {
                Measure targetMeasure = curMeasureProvider.getMeasureForMetric(wantedMetric);
                Measure timeMeasure = curMeasureProvider.getMeasureForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC);
                timeVals[idx] = timeMeasure.doubleValue(timeMeasure.getUnit());
                targetVals[idx] = targetMeasure.doubleValue(targetMeasure.getUnit());
                ++idx;
            }
            MathArrays.sortInPlace((double[])timeVals, (double[][])new double[][]{targetVals});
            PolynomialSplineFunction interpolationFct = new LinearInterpolator().interpolate(timeVals, targetVals);
            double[] interpolatedTargetValues = new double[sortedPointsInTime.size()];
            VariableMeasurements curMeasurements = null;
            if (mappedFactors.containsKey(m)) {
                curMeasurements = new VariableMeasurements(((MeasuredFactor)mappedFactors.get(m)).getName(), ((IMeasureProvider)m.getDataStream().iterator().next()).getMeasureForMetric(wantedMetric).getUnit(), interpolatedTargetValues);
            } else if (m.isCompatibleWith((MetricDescription)MetricDescriptionConstants.POWER_CONSUMPTION_TUPLE)) {
                curMeasurements = new TargetMeasurements(TARGET_METRIC_NAME, ((IMeasureProvider)m.getDataStream().iterator().next()).getMeasureForMetric(targetMetric).getUnit(), interpolatedTargetValues);
            }
            idx = 0;
            for (Measure curTime : sortedPointsInTime) {
                double curValue = curTime.doubleValue(curTime.getUnit());
                interpolatedTargetValues[idx] = curValue < timeVals[0] ? targetVals[0] : (curValue > timeVals[timeVals.length - 1] ? targetVals[targetVals.length - 1] : interpolationFct.value(curValue));
                ++idx;
            }
            resultingMeasurementsList.add((Measurements)curMeasurements);
        });
        return resultingMeasurementsList;
    }
}

