/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.regression.edp2;

import de.fzi.power.binding.AbstractFixedFactorValue;
import de.fzi.power.binding.BindingFactory;
import de.fzi.power.binding.FixedFactorValueDimensionless;
import de.fzi.power.binding.FixedFactorValuePower;
import de.fzi.power.binding.PowerBindingRepository;
import de.fzi.power.binding.ResourcePowerBinding;
import de.fzi.power.binding.util.BindingSwitch;
import de.fzi.power.regression.edp2.EDP2RUtil;
import de.fzi.power.regression.r.AbstractNonLinearRegression;
import de.fzi.power.regression.r.DoubleModelParameter;
import de.fzi.power.regression.r.EarthRegression;
import de.fzi.power.regression.r.Measurements;
import de.fzi.power.regression.r.RobustNonLinearSquaresRegression;
import de.fzi.power.regression.r.SymbolicRegression;
import de.fzi.power.regression.r.TargetMeasurements;
import de.fzi.power.regression.r.VariableMeasurements;
import de.fzi.power.specification.DeclarativePowerModelSpecification;
import de.fzi.power.specification.DeclarativeResourcePowerModelSpecification;
import de.fzi.power.specification.MeasuredFactor;
import de.fzi.power.specification.PowerModelRepository;
import de.fzi.power.specification.ResourcePowerModelSpecification;
import de.fzi.power.specification.ResourceReplicaMeasuredFactor;
import de.fzi.power.specification.SpecificationFactory;
import de.fzi.power.specification.SpecificationPackage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.measure.Measure;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Power;
import javax.measure.unit.Unit;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math3.util.Pair;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.edp2source.Edp2DataTupleDataSource;
import org.palladiosimulator.edp2.filter.exponentialsmoothing.ExponentialDecayingFilter;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentGroup;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentRun;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentSetting;
import org.palladiosimulator.edp2.models.ExperimentData.Measurement;
import org.palladiosimulator.edp2.models.ExperimentData.MeasurementRange;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.models.measuringpoint.StringMeasuringPoint;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.MetricSpecPackage;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.pcmmeasuringpoint.ActiveResourceMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.util.PcmmeasuringpointSwitch;
import org.vedantatree.expressionoasis.ExpressionContext;
import org.vedantatree.expressionoasis.ExpressionEngine;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.Expression;

public class Edp2ModelConstructor {
    private ExperimentGroup runResults;

    public Edp2ModelConstructor(ExperimentGroup runResults) {
        this.runResults = runResults;
    }

    public AbstractNonLinearRegression<Power> constructPowerModel(ResourcePowerBinding binding) {
        Expression expression = null;
        String expressionString = ((DeclarativePowerModelSpecification)binding.getResourcePowerModelSpecification()).getFunctionalExpression();
        try {
            expression = ExpressionEngine.compileExpression((String)expressionString, (ExpressionContext)new ExpressionContext(), (boolean)false);
        }
        catch (ExpressionEngineException e) {
            throw new IllegalArgumentException("Could not compile the expression \"" + expressionString + "\".", e);
        }
        final ArrayList params = new ArrayList();
        for (AbstractFixedFactorValue curValue : binding.getFixedFactorValues()) {
            new BindingSwitch<Void>(){

                public Void caseFixedFactorValuePower(FixedFactorValuePower value) {
                    Measure curMeasure = value.getValue();
                    Amount valueAmount = Amount.valueOf((double)curMeasure.doubleValue(curMeasure.getUnit()), (Unit)curMeasure.getUnit());
                    params.add(new DoubleModelParameter(value.getBoundFactor().getName(), Measure.valueOf((double)valueAmount.getEstimatedValue(), (Unit)valueAmount.getUnit())));
                    return null;
                }

                public Void caseFixedFactorValueDimensionless(FixedFactorValueDimensionless value) {
                    Measure curMeasure = value.getValue();
                    Amount valueAmount = Amount.valueOf((double)curMeasure.doubleValue(curMeasure.getUnit()), (Unit)curMeasure.getUnit());
                    params.add(new DoubleModelParameter(value.getBoundFactor().getName(), Measure.valueOf((double)valueAmount.getEstimatedValue(), (Unit)valueAmount.getUnit())));
                    return null;
                }
            }.doSwitch((EObject)curValue);
        }
        Pair<List<VariableMeasurements>, TargetMeasurements> resultPair = this.getMeasurementsFromRepository(binding);
        return new RobustNonLinearSquaresRegression(expression, (List)resultPair.getFirst(), params, (TargetMeasurements)resultPair.getSecond());
    }

    public SymbolicRegression<Power> constructSymbolicModel(PowerBindingRepository repo, PowerModelRepository modelRepo, DeclarativeResourcePowerModelSpecification spec) {
        List availableSources = this.getDatasourcesOfFirstRun().stream().filter(m -> !m.getMetricDesciption().getId().equals(MetricDescriptionConstants.POWER_CONSUMPTION_TUPLE.getId())).collect(Collectors.toList());
        ResourcePowerBinding binding = BindingFactory.eINSTANCE.createResourcePowerBinding();
        binding.setResourcePowerModelSpecification((ResourcePowerModelSpecification)spec);
        binding.setPowerBindingRepository(repo);
        for (IDataSource source : availableSources) {
            MeasuredFactor factor = SpecificationFactory.eINSTANCE.createMeasuredFactor();
            NumericalBaseMetricDescription curMetric = (NumericalBaseMetricDescription)((MetricSetDescription)source.getMetricDesciption()).getSubsumedMetrics().get(1);
            factor.setMetricType(curMetric);
            String name = curMetric.getName().replace(" ", "");
            name = String.valueOf(name) + (String)new PcmmeasuringpointSwitch<String>(){

                public String caseActiveResourceMeasuringPoint(ActiveResourceMeasuringPoint object) {
                    return Integer.toString(object.getReplicaID());
                }

                public String defaultCase(EObject object) {
                    return "";
                }
            }.doSwitch((EObject)source.getMeasuringPoint());
            factor.setName(name);
            spec.getConsumptionFactors().add((Object)factor);
        }
        spec.setPowermodelrepository(modelRepo);
        Pair<List<VariableMeasurements>, TargetMeasurements> resultPair = this.getMeasurementsFromRepository(binding);
        return new SymbolicRegression((List)resultPair.getFirst(), (TargetMeasurements)resultPair.getSecond());
    }

    public EarthRegression<Power> constructEarthModel(PowerBindingRepository repo, PowerModelRepository modelRepo, DeclarativeResourcePowerModelSpecification spec) {
        List availableSources = this.getDatasourcesOfFirstRun().stream().filter(m -> !m.getMetricDesciption().getId().equals(MetricDescriptionConstants.POWER_CONSUMPTION_TUPLE.getId())).collect(Collectors.toList());
        ResourcePowerBinding binding = BindingFactory.eINSTANCE.createResourcePowerBinding();
        binding.setResourcePowerModelSpecification((ResourcePowerModelSpecification)spec);
        binding.setPowerBindingRepository(repo);
        for (IDataSource source : availableSources) {
            NumericalBaseMetricDescription curMetric = (NumericalBaseMetricDescription)((MetricSetDescription)source.getMetricDesciption()).getSubsumedMetrics().get(1);
            String name = curMetric.getName().replace(" ", "");
            MeasuredFactor factor = SpecificationFactory.eINSTANCE.createMeasuredFactor();
            factor.setName(name);
            factor.setMetricType(curMetric);
            spec.getConsumptionFactors().add((Object)factor);
        }
        spec.setPowermodelrepository(modelRepo);
        Pair<List<VariableMeasurements>, TargetMeasurements> resultPair = this.getMeasurementsFromRepository(binding);
        EarthRegression regression = new EarthRegression((TargetMeasurements)resultPair.getSecond(), (List)resultPair.getFirst());
        String expression = null;
        try {
            expression = regression.getMaximumForm();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        expression = expression.replaceAll("\n", "");
        expression = expression.replaceAll(" ", "");
        spec.setFunctionalExpression(expression);
        spec.setName("EARTH model");
        binding.setName("EARTH model");
        return regression;
    }

    private List<IDataSource> getDatasourcesOfFirstRun() {
        LinkedList<IDataSource> availableSources = new LinkedList<IDataSource>();
        ExperimentSetting workletResults = (ExperimentSetting)this.runResults.getExperimentSettings().get(0);
        Iterator iterator = workletResults.getExperimentRuns().iterator();
        if (iterator.hasNext()) {
            ExperimentRun run = (ExperimentRun)iterator.next();
            for (Measurement curMeasurement : run.getMeasurement()) {
                Edp2DataTupleDataSource dataSource = new Edp2DataTupleDataSource(((MeasurementRange)curMeasurement.getMeasurementRanges().get(0)).getRawMeasurements());
                availableSources.add((IDataSource)dataSource);
            }
            return availableSources;
        }
        return null;
    }

    private Pair<List<VariableMeasurements>, TargetMeasurements> getMeasurementsFromRepository(ResourcePowerBinding binding) {
        List<List<Measurements>> allMeasurements = this.getMeasurementsForFixedValues(binding);
        List measurements = (List)allMeasurements.stream().reduce((a, b) -> {
            ArrayList result = new ArrayList();
            a.forEach(consumer -> {
                Measurements matchingMsmnts = b.stream().filter(curMeasurements -> curMeasurements.getName().equals(consumer.getName())).findAny().get();
                UnitConverter converter = matchingMsmnts.getUnit().getConverterTo(consumer.getUnit());
                double[] correctedValues = Arrays.stream(matchingMsmnts.getValues()).map(d -> converter.convert(d)).toArray();
                result.add(matchingMsmnts.instantiate(consumer.getName(), consumer.getUnit(), ArrayUtils.addAll((double[])consumer.getValues(), (double[])correctedValues)));
            });
            return result;
        }).get();
        List variableMeasurements = measurements.stream().filter(m -> m instanceof VariableMeasurements).map(p -> (VariableMeasurements)p).collect(Collectors.toList());
        TargetMeasurements targetMeasurements = measurements.stream().filter(m -> m instanceof TargetMeasurements).findAny().map(p -> (TargetMeasurements)p).get();
        return new Pair(variableMeasurements, (Object)targetMeasurements);
    }

    private List<List<Measurements>> getMeasurementsForFixedValues(ResourcePowerBinding binding) {
        ArrayList<List<Measurements>> allMeasurements = new ArrayList<List<Measurements>>();
        for (ExperimentSetting workletResults : this.runResults.getExperimentSettings()) {
            for (ExperimentRun run : workletResults.getExperimentRuns()) {
                HashMap<IDataSource, MeasuredFactor> mappedFactors = new HashMap<IDataSource, MeasuredFactor>();
                ArrayList<IDataSource> measurements = new ArrayList<IDataSource>();
                for (Measurement curMeasurement : run.getMeasurement()) {
                    String curId = curMeasurement.getMeasuringType().getMetric().getId();
                    Edp2DataTupleDataSource dataSource = new Edp2DataTupleDataSource(((MeasurementRange)curMeasurement.getMeasurementRanges().get(0)).getRawMeasurements());
                    if (curId.equals(MetricDescriptionConstants.HDD_READ_RATE_TUPLE.getId()) || curId.equals(MetricDescriptionConstants.HDD_WRITE_RATE_TUPLE.getId())) {
                        dataSource = new ExponentialDecayingFilter((IDataSource)dataSource, dataSource.getMetricDesciption());
                    }
                    measurements.add((IDataSource)dataSource);
                    MetricSetDescription metricSet = (MetricSetDescription)dataSource.getMetricDesciption();
                    MetricDescription secondMetric = (MetricDescription)metricSet.getSubsumedMetrics().get(1);
                    if (!MetricSpecPackage.eINSTANCE.getNumericalBaseMetricDescription().isInstance((Object)secondMetric)) continue;
                    Edp2DataTupleDataSource passedSource = dataSource;
                    for (MeasuredFactor curFactor : EcoreUtil.getObjectsByType((Collection)binding.getResourcePowerModelSpecification().getConsumptionFactors(), (EClassifier)SpecificationPackage.eINSTANCE.getMeasuredFactor())) {
                        if (!MetricDescriptionUtility.isBaseMetricDescriptionSubsumedByMetricDescription((BaseMetricDescription)curFactor.getMetricType(), (MetricDescription)curMeasurement.getMeasuringType().getMetric())) continue;
                        if (this.isSameResourceReplica(curFactor, passedSource.getMeasuringPoint())) {
                            mappedFactors.put((IDataSource)passedSource, curFactor);
                            continue;
                        }
                        if (!(passedSource.getMeasuringPoint() instanceof StringMeasuringPoint)) continue;
                        mappedFactors.put((IDataSource)passedSource, curFactor);
                    }
                }
                List<Measurements> curMeasurements = EDP2RUtil.combineDatasets(measurements, mappedFactors, (MetricDescription)MetricDescriptionConstants.POWER_CONSUMPTION);
                allMeasurements.add(curMeasurements);
            }
        }
        return allMeasurements;
    }

    private boolean isSameResourceReplica(MeasuredFactor curFactor, MeasuringPoint measuringPoint) {
        if (curFactor instanceof ResourceReplicaMeasuredFactor && measuringPoint instanceof ActiveResourceMeasuringPoint) {
            ResourceReplicaMeasuredFactor replicatedFactor = (ResourceReplicaMeasuredFactor)curFactor;
            ActiveResourceMeasuringPoint activeMeasuringPoint = (ActiveResourceMeasuringPoint)measuringPoint;
            if (replicatedFactor.getReplicaId() == activeMeasuringPoint.getReplicaID()) {
                return true;
            }
        }
        return false;
    }
}

