/**
 */
package de.fzi.power.binding.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import de.fzi.power.binding.util.BindingAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc --> <!--
 * end-user-doc -->
 * @generated
 */
public class BindingItemProviderAdapterFactory extends BindingAdapterFactory
        implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier();

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<Object>();

    /**
     * This constructs an instance.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    public BindingItemProviderAdapterFactory() {
        supportedTypes.add(IEditingDomainItemProvider.class);
        supportedTypes.add(IStructuredItemContentProvider.class);
        supportedTypes.add(ITreeItemContentProvider.class);
        supportedTypes.add(IItemLabelProvider.class);
        supportedTypes.add(IItemPropertySource.class);
    }

    /**
     * This keeps track of the one adapter used for all {@link de.fzi.power.binding.FixedFactorValuePower} instances.
     * <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * @generated
     */
    protected FixedFactorValuePowerItemProvider fixedFactorValuePowerItemProvider;

    /**
     * This creates an adapter for a {@link de.fzi.power.binding.FixedFactorValuePower}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createFixedFactorValuePowerAdapter() {
        if (fixedFactorValuePowerItemProvider == null) {
            fixedFactorValuePowerItemProvider = new FixedFactorValuePowerItemProvider(this);
        }

        return fixedFactorValuePowerItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.fzi.power.binding.PowerBindingRepository} instances.
     * <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * @generated
     */
    protected PowerBindingRepositoryItemProvider powerBindingRepositoryItemProvider;

    /**
     * This creates an adapter for a {@link de.fzi.power.binding.PowerBindingRepository}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createPowerBindingRepositoryAdapter() {
        if (powerBindingRepositoryItemProvider == null) {
            powerBindingRepositoryItemProvider = new PowerBindingRepositoryItemProvider(this);
        }

        return powerBindingRepositoryItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.fzi.power.binding.ResourcePowerBinding} instances.
     * <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * @generated
     */
    protected ResourcePowerBindingItemProvider resourcePowerBindingItemProvider;

    /**
     * This creates an adapter for a {@link de.fzi.power.binding.ResourcePowerBinding}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createResourcePowerBindingAdapter() {
        if (resourcePowerBindingItemProvider == null) {
            resourcePowerBindingItemProvider = new ResourcePowerBindingItemProvider(this);
        }

        return resourcePowerBindingItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.fzi.power.binding.DistributionPowerBinding} instances.
     * <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * @generated
     */
    protected DistributionPowerBindingItemProvider distributionPowerBindingItemProvider;

    /**
     * This creates an adapter for a {@link de.fzi.power.binding.DistributionPowerBinding}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createDistributionPowerBindingAdapter() {
        if (distributionPowerBindingItemProvider == null) {
            distributionPowerBindingItemProvider = new DistributionPowerBindingItemProvider(this);
        }

        return distributionPowerBindingItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.fzi.power.binding.StatefulResourcePowerBinding} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected StatefulResourcePowerBindingItemProvider statefulResourcePowerBindingItemProvider;

    /**
     * This creates an adapter for a {@link de.fzi.power.binding.StatefulResourcePowerBinding}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createStatefulResourcePowerBindingAdapter() {
        if (statefulResourcePowerBindingItemProvider == null) {
            statefulResourcePowerBindingItemProvider = new StatefulResourcePowerBindingItemProvider(this);
        }

        return statefulResourcePowerBindingItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.fzi.power.binding.PowerStateBinding} instances.
     * <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * @generated
     */
    protected PowerStateBindingItemProvider powerStateBindingItemProvider;

    /**
     * This creates an adapter for a {@link de.fzi.power.binding.PowerStateBinding}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createPowerStateBindingAdapter() {
        if (powerStateBindingItemProvider == null) {
            powerStateBindingItemProvider = new PowerStateBindingItemProvider(this);
        }

        return powerStateBindingItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.fzi.power.binding.TransitionStateBinding} instances.
     * <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * @generated
     */
    protected TransitionStateBindingItemProvider transitionStateBindingItemProvider;

    /**
     * This creates an adapter for a {@link de.fzi.power.binding.TransitionStateBinding}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createTransitionStateBindingAdapter() {
        if (transitionStateBindingItemProvider == null) {
            transitionStateBindingItemProvider = new TransitionStateBindingItemProvider(this);
        }

        return transitionStateBindingItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.fzi.power.binding.FixedFactorValueDimensionless} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected FixedFactorValueDimensionlessItemProvider fixedFactorValueDimensionlessItemProvider;

    /**
     * This creates an adapter for a {@link de.fzi.power.binding.FixedFactorValueDimensionless}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createFixedFactorValueDimensionlessAdapter() {
        if (fixedFactorValueDimensionlessItemProvider == null) {
            fixedFactorValueDimensionlessItemProvider = new FixedFactorValueDimensionlessItemProvider(this);
        }

        return fixedFactorValueDimensionlessItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.fzi.power.binding.ConsumptionBehavior} instances.
     * <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * @generated
     */
    protected ConsumptionBehaviorItemProvider consumptionBehaviorItemProvider;

    /**
     * This creates an adapter for a {@link de.fzi.power.binding.ConsumptionBehavior}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createConsumptionBehaviorAdapter() {
        if (consumptionBehaviorItemProvider == null) {
            consumptionBehaviorItemProvider = new ConsumptionBehaviorItemProvider(this);
        }

        return consumptionBehaviorItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public ComposeableAdapterFactory getRootAdapterFactory() {
        return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
    }

    /**
     * This sets the composed adapter factory that contains this factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean isFactoryForType(Object type) {
        return supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, this);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object adapt(Object object, Object type) {
        if (isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

    /**
     * This adds a listener.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void addListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.addListener(notifyChangedListener);
    }

    /**
     * This removes a listener.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void removeListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.removeListener(notifyChangedListener);
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void fireNotifyChanged(Notification notification) {
        changeNotifier.fireNotifyChanged(notification);

        if (parentAdapterFactory != null) {
            parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    /**
     * This disposes all of the item providers created by this factory. 
     * <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * @generated
     */
    @Override
    public void dispose() {
        if (fixedFactorValuePowerItemProvider != null)
            fixedFactorValuePowerItemProvider.dispose();
        if (powerBindingRepositoryItemProvider != null)
            powerBindingRepositoryItemProvider.dispose();
        if (resourcePowerBindingItemProvider != null)
            resourcePowerBindingItemProvider.dispose();
        if (distributionPowerBindingItemProvider != null)
            distributionPowerBindingItemProvider.dispose();
        if (fixedFactorValueDimensionlessItemProvider != null)
            fixedFactorValueDimensionlessItemProvider.dispose();
        if (consumptionBehaviorItemProvider != null)
            consumptionBehaviorItemProvider.dispose();
        if (statefulResourcePowerBindingItemProvider != null)
            statefulResourcePowerBindingItemProvider.dispose();
        if (powerStateBindingItemProvider != null)
            powerStateBindingItemProvider.dispose();
        if (transitionStateBindingItemProvider != null)
            transitionStateBindingItemProvider.dispose();
    }

}
