/**
 */
package de.fzi.power.specification.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import de.fzi.power.specification.util.SpecificationAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers. The
 * adapters generated by this factory convert EMF adapter notifications into calls to
 * {@link #fireNotifyChanged fireNotifyChanged}. The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances. <!-- begin-user-doc --> <!--
 * end-user-doc -->
 *
 * @generated
 */
public class SpecificationItemProviderAdapterFactory extends SpecificationAdapterFactory
        implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier();

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType
     * isFactoryForType}. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<>();

    /**
     * This constructs an instance. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    public SpecificationItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.fzi.power.specification.PowerModelRepository} instances. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    protected PowerModelRepositoryItemProvider powerModelRepositoryItemProvider;

    /**
     * This creates an adapter for a {@link de.fzi.power.specification.PowerModelRepository}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createPowerModelRepositoryAdapter() {
        if (this.powerModelRepositoryItemProvider == null) {
            this.powerModelRepositoryItemProvider = new PowerModelRepositoryItemProvider(this);
        }

        return this.powerModelRepositoryItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.fzi.power.specification.FixedFactor} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected FixedFactorItemProvider fixedFactorItemProvider;

    /**
     * This creates an adapter for a {@link de.fzi.power.specification.FixedFactor}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createFixedFactorAdapter() {
        if (this.fixedFactorItemProvider == null) {
            this.fixedFactorItemProvider = new FixedFactorItemProvider(this);
        }

        return this.fixedFactorItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.fzi.power.specification.MeasuredFactor} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected MeasuredFactorItemProvider measuredFactorItemProvider;

    /**
     * This creates an adapter for a {@link de.fzi.power.specification.MeasuredFactor}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createMeasuredFactorAdapter() {
        if (this.measuredFactorItemProvider == null) {
            this.measuredFactorItemProvider = new MeasuredFactorItemProvider(this);
        }

        return this.measuredFactorItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.fzi.power.specification.DeclarativePowerModelSpecification} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected DeclarativePowerModelSpecificationItemProvider declarativePowerModelSpecificationItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.fzi.power.specification.DeclarativePowerModelSpecification}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createDeclarativePowerModelSpecificationAdapter() {
        if (this.declarativePowerModelSpecificationItemProvider == null) {
            this.declarativePowerModelSpecificationItemProvider = new DeclarativePowerModelSpecificationItemProvider(
                    this);
        }

        return this.declarativePowerModelSpecificationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.fzi.power.specification.DeclarativeResourcePowerModelSpecification} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected DeclarativeResourcePowerModelSpecificationItemProvider declarativeResourcePowerModelSpecificationItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.fzi.power.specification.DeclarativeResourcePowerModelSpecification}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createDeclarativeResourcePowerModelSpecificationAdapter() {
        if (this.declarativeResourcePowerModelSpecificationItemProvider == null) {
            this.declarativeResourcePowerModelSpecificationItemProvider = new DeclarativeResourcePowerModelSpecificationItemProvider(
                    this);
        }

        return this.declarativeResourcePowerModelSpecificationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.fzi.power.specification.DeclarativeDistributionPowerModelSpecification} instances.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected DeclarativeDistributionPowerModelSpecificationItemProvider declarativeDistributionPowerModelSpecificationItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.fzi.power.specification.DeclarativeDistributionPowerModelSpecification}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createDeclarativeDistributionPowerModelSpecificationAdapter() {
        if (this.declarativeDistributionPowerModelSpecificationItemProvider == null) {
            this.declarativeDistributionPowerModelSpecificationItemProvider = new DeclarativeDistributionPowerModelSpecificationItemProvider(
                    this);
        }

        return this.declarativeDistributionPowerModelSpecificationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.fzi.power.specification.BlackBoxDistributionPowerModelSpecification} instances.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected BlackBoxDistributionPowerModelSpecificationItemProvider blackBoxDistributionPowerModelSpecificationItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.fzi.power.specification.BlackBoxDistributionPowerModelSpecification}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createBlackBoxDistributionPowerModelSpecificationAdapter() {
        if (this.blackBoxDistributionPowerModelSpecificationItemProvider == null) {
            this.blackBoxDistributionPowerModelSpecificationItemProvider = new BlackBoxDistributionPowerModelSpecificationItemProvider(
                    this);
        }

        return this.blackBoxDistributionPowerModelSpecificationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.fzi.power.specification.BlackBoxResourcePowerModelSpecification} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected BlackBoxResourcePowerModelSpecificationItemProvider blackBoxResourcePowerModelSpecificationItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.fzi.power.specification.BlackBoxResourcePowerModelSpecification}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createBlackBoxResourcePowerModelSpecificationAdapter() {
        if (this.blackBoxResourcePowerModelSpecificationItemProvider == null) {
            this.blackBoxResourcePowerModelSpecificationItemProvider = new BlackBoxResourcePowerModelSpecificationItemProvider(
                    this);
        }

        return this.blackBoxResourcePowerModelSpecificationItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    /**
     * This sets the composed adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void setParentAdapterFactory(final ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public boolean isFactoryForType(final Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter adapt(final Notifier notifier, final Object type) {
        return super.adapt(notifier, this);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Object adapt(final Object object, final Object type) {
        if (this.isFactoryForType(type)) {
            final Object adapter = super.adapt(object, type);
            if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

    /**
     * This adds a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void addListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    /**
     * This removes a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void removeListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void fireNotifyChanged(final Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);

        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    /**
     * This disposes all of the item providers created by this factory. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    @Override
    public void dispose() {
        if (this.powerModelRepositoryItemProvider != null) {
            this.powerModelRepositoryItemProvider.dispose();
        }
        if (this.fixedFactorItemProvider != null) {
            this.fixedFactorItemProvider.dispose();
        }
        if (this.measuredFactorItemProvider != null) {
            this.measuredFactorItemProvider.dispose();
        }
        if (this.declarativePowerModelSpecificationItemProvider != null) {
            this.declarativePowerModelSpecificationItemProvider.dispose();
        }
        if (this.declarativeResourcePowerModelSpecificationItemProvider != null) {
            this.declarativeResourcePowerModelSpecificationItemProvider.dispose();
        }
        if (this.declarativeDistributionPowerModelSpecificationItemProvider != null) {
            this.declarativeDistributionPowerModelSpecificationItemProvider.dispose();
        }
        if (this.blackBoxDistributionPowerModelSpecificationItemProvider != null) {
            this.blackBoxDistributionPowerModelSpecificationItemProvider.dispose();
        }
        if (this.blackBoxResourcePowerModelSpecificationItemProvider != null) {
            this.blackBoxResourcePowerModelSpecificationItemProvider.dispose();
        }
    }

}
