/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter.calculator.expressionoasis.custom;

import de.fzi.power.binding.AbstractFixedFactorValue;
import de.fzi.power.interpreter.calculator.expressionoasis.custom.ConsumptionFactorsVariableProvider;
import de.fzi.power.interpreter.calculator.expressionoasis.custom.CustomFunctionProvider;
import de.fzi.power.interpreter.calculator.expressionoasis.custom.MeasuredValuesCompositeValueObject;
import de.fzi.power.interpreter.calculator.expressionoasis.helper.ExpressionOasisHelper;
import de.fzi.power.specification.ConsumptionFactor;
import java.util.Collection;
import java.util.Iterator;
import javax.measure.Measure;
import javax.measure.quantity.Power;
import javax.measure.unit.Unit;
import org.eclipse.emf.common.util.EList;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.measurementframework.BasicMeasurement;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.vedantatree.expressionoasis.ExpressionContext;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.extensions.VariableProvider;
import org.vedantatree.expressionoasis.types.ValueObject;

public class CustomExpressionContext
extends ExpressionContext {
    private final ConsumptionFactorsVariableProvider variableProvider;

    public CustomExpressionContext(EList<AbstractFixedFactorValue<?>> eList, Iterable<ConsumptionFactor> consumptionFactors) throws ExpressionEngineException {
        this.variableProvider = new ConsumptionFactorsVariableProvider(eList, consumptionFactors);
        this.addVariableProvider((VariableProvider)this.variableProvider);
        this.addFunctionProvider(new CustomFunctionProvider());
    }

    public void addBasicMeasurement(MeasuringValue measuringValue) {
        this.variableProvider.addMeasuredValue(measuringValue);
    }

    public void addPowerConsumptions(Iterable<Amount<Power>> outletConsumptions) {
        for (Amount<Power> outletConsumption : outletConsumptions) {
            Unit unit = outletConsumption.getUnit();
            Measure measure = Measure.valueOf((double)outletConsumption.doubleValue(unit), (Unit)unit);
            this.addBasicMeasurement((MeasuringValue)new BasicMeasurement(measure, (BaseMetricDescription)MetricDescriptionConstants.POWER_CONSUMPTION));
        }
    }

    public void clearMeasurements() {
        this.variableProvider.clearMeasuredValues();
    }

    public Collection<MetricDescription> getMeasuredFactors() {
        return this.variableProvider.getMeasuredFactors();
    }

    public boolean isMeasuredFactorAvailable(String measuredFactorName) {
        return this.variableProvider.providesMeasuredFactor(measuredFactorName);
    }

    public boolean isMeasuredFactorAvailable(MetricDescription measuredFactorMetricDescription) {
        return this.variableProvider.providesMeasuredFactor(measuredFactorMetricDescription);
    }

    public double toDouble(ValueObject valueObject) {
        double result = 0.0;
        if (ExpressionOasisHelper.hasCompositeType(valueObject)) {
            Object objectValues = ((MeasuredValuesCompositeValueObject)valueObject).getValue();
            Iterator valuesIterator = objectValues.iterator();
            if (valuesIterator.hasNext()) {
                result = (Double)valuesIterator.next();
            }
        } else if (ExpressionOasisHelper.hasNumericType(valueObject)) {
            result = Double.parseDouble(valueObject.getValue().toString());
        }
        return result;
    }
}

