/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter.calculator.expressionoasis.custom.expressions;

import de.fzi.power.interpreter.calculator.expressionoasis.custom.CustomExpressionContext;
import de.fzi.power.interpreter.calculator.expressionoasis.custom.expressions.EvaluationVisitor;
import de.fzi.power.interpreter.calculator.expressionoasis.helper.ExpressionOasisHelper;
import java.util.Objects;
import org.vedantatree.expressionoasis.ExpressionContext;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.Expression;
import org.vedantatree.expressionoasis.expressions.ExpressionTypeFinder;
import org.vedantatree.expressionoasis.expressions.IdentifierExpression;
import org.vedantatree.expressionoasis.expressions.UnaryOperatorExpression;
import org.vedantatree.expressionoasis.expressions.arithmatic.ParanthesisExpression;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;

abstract class MeasuredFactorsFoldExpression
extends UnaryOperatorExpression {
    private final EvaluationVisitor evaluator;
    private final String opcode;

    MeasuredFactorsFoldExpression(EvaluationVisitor evaluator, String opcode) {
        this.evaluator = Objects.requireNonNull(evaluator);
        this.opcode = Objects.requireNonNull(opcode);
        if (this.opcode.isEmpty()) {
            throw new IllegalArgumentException("EXpression opcode must not be null!");
        }
    }

    public Type getReturnType() {
        return Type.DOUBLE;
    }

    public final ValueObject getValue() throws ExpressionEngineException {
        return this.evaluator.evaluate(this.getOperandExpression());
    }

    public void initialize(ExpressionContext expressionContext, Object parameters, boolean validate) throws ExpressionEngineException {
        ExpressionOasisHelper.assertCorrectExpressionContext(expressionContext, ((Object)((Object)this)).getClass());
        super.initialize(expressionContext, parameters, validate);
    }

    protected void validate(ExpressionContext context) throws ExpressionEngineException {
        ExpressionOasisHelper.assertCorrectExpressionContext(context, ((Object)((Object)this)).getClass());
        CustomExpressionContext expressionContext = (CustomExpressionContext)context;
        if (ExpressionOasisHelper.isNumericType(this.getOperandExpression().getReturnType())) {
            ExpressionTypeFinder identifierFinder = new ExpressionTypeFinder(this.getOperandExpression(), IdentifierExpression.class);
            boolean foundMeasuredFactor = false;
            for (Expression found : identifierFinder.getExpressions()) {
                IdentifierExpression foundIdentifier = (IdentifierExpression)found;
                if (!expressionContext.isMeasuredFactorAvailable(foundIdentifier.getIdentifierName())) continue;
                foundMeasuredFactor = true;
                break;
            }
            if (!foundMeasuredFactor) {
                throw new ExpressionEngineException("Operand is not supported by \"" + this.opcode + "\", for it does not contain any measured factor!", 100, null);
            }
        }
    }

    public Expression getOperandExpression() {
        Expression operand = super.getOperandExpression();
        while (operand instanceof ParanthesisExpression) {
            operand = ((ParanthesisExpression)operand).getOperandExpression();
        }
        return operand;
    }
}

