/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter.calculator.expressionoasis.custom;

import de.fzi.power.interpreter.calculator.expressionoasis.custom.MeasuredValuesCompositeValueObject;
import de.fzi.power.interpreter.calculator.expressionoasis.helper.ExpressionOasisHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.vedantatree.expressionoasis.ExpressionContext;
import org.vedantatree.expressionoasis.ExpressionEngine;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.extensions.FunctionProvider;
import org.vedantatree.expressionoasis.grammar.Grammar;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;

public final class CustomFunctionProvider
implements FunctionProvider {
    public static final String POW = "POW";
    public static final String SQRT = "SQRT";
    private static final List<String> KNOWN_FUNCTIONS = Arrays.asList("POW", "SQRT");

    public void initialize(ExpressionContext expressionContext) {
        ExpressionOasisHelper.assertCorrectExpressionContext(expressionContext, this.getClass());
        Grammar grammar = ExpressionEngine.getGrammar();
        for (String function : KNOWN_FUNCTIONS) {
            grammar.addFunction(function);
        }
    }

    public Type getFunctionType(String functionName, Type[] parameterTypes) throws ExpressionEngineException {
        return this.supportsFunction(functionName, parameterTypes) ? Type.DOUBLE : null;
    }

    private ValueObject evaluatePow(ValueObject[] parameters) {
        assert (parameters != null && parameters.length == 2);
        Number exponent = (Number)parameters[1].getValue();
        ValueObject result = null;
        ValueObject firstParam = parameters[0];
        if (ExpressionOasisHelper.hasCompositeType(firstParam)) {
            Object values = ((MeasuredValuesCompositeValueObject)firstParam).getValue();
            ArrayList<Double> resultValues = new ArrayList<Double>();
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                double base = (Double)iterator.next();
                resultValues.add(Math.pow(base, exponent.doubleValue()));
            }
            result = new MeasuredValuesCompositeValueObject(resultValues);
        } else {
            double base = (Double)firstParam.getValue();
            result = new ValueObject((Object)Math.pow(base, exponent.doubleValue()), Type.DOUBLE);
        }
        return result;
    }

    private ValueObject evaluateSqrt(ValueObject[] parameters) {
        assert (parameters != null && parameters.length == 1);
        ValueObject result = null;
        ValueObject radicandValueObj = parameters[0];
        if (ExpressionOasisHelper.hasCompositeType(radicandValueObj)) {
            Object radicands = ((MeasuredValuesCompositeValueObject)radicandValueObj).getValue();
            ArrayList<Double> squareRoots = new ArrayList<Double>();
            Iterator iterator = radicands.iterator();
            while (iterator.hasNext()) {
                double radicand = (Double)iterator.next();
                squareRoots.add(Math.sqrt(radicand));
            }
            result = new MeasuredValuesCompositeValueObject(squareRoots);
        } else {
            Number radicand = (Number)radicandValueObj.getValue();
            result = new ValueObject((Object)Math.sqrt(radicand.doubleValue()), Type.DOUBLE);
        }
        return result;
    }

    public ValueObject getFunctionValue(String functionName, ValueObject[] parameters) throws ExpressionEngineException {
        switch (functionName) {
            case "POW": {
                return this.evaluatePow(parameters);
            }
            case "SQRT": {
                return this.evaluateSqrt(parameters);
            }
        }
        return null;
    }

    private static boolean typesMatch(String functionName, Type[] paramTypes) {
        switch (functionName) {
            case "POW": {
                return paramTypes.length == 2 && ExpressionOasisHelper.isNumericType(paramTypes[0]) && ExpressionOasisHelper.isNumericType(paramTypes[1]);
            }
            case "SQRT": {
                return paramTypes.length == 1 && ExpressionOasisHelper.isNumericType(paramTypes[0]);
            }
        }
        return false;
    }

    public boolean supportsFunction(String functionName, Type[] parameterTypes) throws ExpressionEngineException {
        return KNOWN_FUNCTIONS.contains(functionName) && CustomFunctionProvider.typesMatch(functionName, parameterTypes);
    }
}

