/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter.calculator.expressionoasis.custom.expressions;

import de.fzi.power.interpreter.calculator.expressionoasis.custom.MeasuredValuesCompositeValueObject;
import de.fzi.power.interpreter.calculator.expressionoasis.helper.ExpressionOasisHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.vedantatree.expressionoasis.exceptions.ExpressionEngineException;
import org.vedantatree.expressionoasis.expressions.BinaryOperatorExpression;
import org.vedantatree.expressionoasis.expressions.Expression;
import org.vedantatree.expressionoasis.expressions.ExpressionVisitor;
import org.vedantatree.expressionoasis.expressions.IdentifierExpression;
import org.vedantatree.expressionoasis.expressions.arithmatic.AddExpression;
import org.vedantatree.expressionoasis.expressions.arithmatic.DivideExpression;
import org.vedantatree.expressionoasis.expressions.arithmatic.MultiplyExpression;
import org.vedantatree.expressionoasis.expressions.arithmatic.SubtractExpression;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;

abstract class EvaluationVisitor
implements ExpressionVisitor {
    private Iterable<Double> values;
    private boolean operandsVisited = false;

    EvaluationVisitor() {
    }

    final ValueObject evaluate(Expression operand) {
        this.reset();
        operand.accept((ExpressionVisitor)this);
        return new ValueObject((Object)this.fold(this.values), Type.DOUBLE);
    }

    protected abstract double fold(Iterable<Double> var1);

    private void reset() {
        this.values = Collections.emptyList();
        this.operandsVisited = false;
    }

    public void visit(Expression expression) {
        if (!this.operandsVisited) {
            if (expression instanceof IdentifierExpression) {
                this.values = this.handleIdentifier((IdentifierExpression)expression);
                this.operandsVisited = false;
            } else if (expression instanceof BinaryOperatorExpression) {
                try {
                    this.values = this.internalVisit((BinaryOperatorExpression)expression);
                    this.operandsVisited = true;
                }
                catch (ExpressionEngineException e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.values = this.internalVisitDefault(expression);
                this.operandsVisited = true;
            }
        }
    }

    private Iterable<Double> internalVisitDefault(Expression expression) {
        ValueObject valueObject = null;
        try {
            valueObject = expression.getValue();
        }
        catch (ExpressionEngineException e) {
            throw new RuntimeException(e);
        }
        if (ExpressionOasisHelper.hasCompositeType(valueObject)) {
            return ((MeasuredValuesCompositeValueObject)valueObject).getValue();
        }
        return Collections.singletonList(Double.valueOf((Double)valueObject.getValue()));
    }

    private Iterable<Double> internalVisit(BinaryOperatorExpression binaryExpression) throws ExpressionEngineException {
        Iterable<Double> result = null;
        if (binaryExpression instanceof MultiplyExpression) {
            result = this.handleMultiply((MultiplyExpression)binaryExpression);
        } else if (binaryExpression instanceof DivideExpression) {
            result = this.handleDivide((DivideExpression)binaryExpression);
        } else if (binaryExpression instanceof AddExpression) {
            result = this.handleAdd((AddExpression)binaryExpression);
        } else if (binaryExpression instanceof SubtractExpression) {
            result = this.handleSubtract((SubtractExpression)binaryExpression);
        } else {
            throw new ExpressionEngineException("Binary expression type " + binaryExpression.getClass().getSimpleName() + " [" + binaryExpression.toString() + "] not yet supported by EvaluationVisitor so far!");
        }
        return result;
    }

    private Iterable<Double> handleDivide(DivideExpression divideExpression) throws ExpressionEngineException {
        ArrayList<Double> result = new ArrayList<Double>();
        ValueObject dividendValue = divideExpression.getLeftOperandExpression().getValue();
        ValueObject divisorValue = divideExpression.getRightOperandExpression().getValue();
        if (ExpressionOasisHelper.hasCompositeType(dividendValue)) {
            Number divisor = (Number)divisorValue.getValue();
            Object dividends = ((MeasuredValuesCompositeValueObject)dividendValue).getValue();
            Iterator iterator = dividends.iterator();
            while (iterator.hasNext()) {
                double dividend = (Double)iterator.next();
                result.add(dividend / divisor.doubleValue());
            }
        } else if (ExpressionOasisHelper.hasCompositeType(divisorValue)) {
            Number dividend = (Number)dividendValue.getValue();
            Object divisors = ((MeasuredValuesCompositeValueObject)divisorValue).getValue();
            Iterator iterator = divisors.iterator();
            while (iterator.hasNext()) {
                double divisor = (Double)iterator.next();
                result.add(dividend.doubleValue() / divisor);
            }
        } else {
            result.add((Double)divideExpression.getValue().getValue());
        }
        return result;
    }

    private Iterable<Double> handleSubtract(SubtractExpression subtractExpression) throws ExpressionEngineException {
        ArrayList<Double> result = new ArrayList<Double>();
        ValueObject minuendValue = subtractExpression.getLeftOperandExpression().getValue();
        ValueObject subtrahendValue = subtractExpression.getRightOperandExpression().getValue();
        if (ExpressionOasisHelper.hasCompositeType(minuendValue)) {
            Number subtrahend = (Number)subtrahendValue.getValue();
            Object minuends = ((MeasuredValuesCompositeValueObject)minuendValue).getValue();
            Iterator iterator = minuends.iterator();
            while (iterator.hasNext()) {
                double minuend = (Double)iterator.next();
                result.add(minuend - subtrahend.doubleValue());
            }
        } else if (ExpressionOasisHelper.hasCompositeType(subtrahendValue)) {
            Number minuend = (Number)minuendValue.getValue();
            Object subtrahends = ((MeasuredValuesCompositeValueObject)subtrahendValue).getValue();
            Iterator iterator = subtrahends.iterator();
            while (iterator.hasNext()) {
                double subtrahend = (Double)iterator.next();
                result.add(minuend.doubleValue() - subtrahend);
            }
        } else {
            result.add((Double)subtractExpression.getValue().getValue());
        }
        return result;
    }

    private Iterable<Double> handleMultiply(MultiplyExpression multiplyExpression) throws ExpressionEngineException {
        ArrayList<Double> result = new ArrayList<Double>();
        Object compositeOperand = null;
        Number factor = 0;
        ValueObject leftOperandValue = multiplyExpression.getLeftOperandExpression().getValue();
        ValueObject rightOperandValue = multiplyExpression.getRightOperandExpression().getValue();
        if (ExpressionOasisHelper.hasCompositeType(leftOperandValue)) {
            compositeOperand = ((MeasuredValuesCompositeValueObject)leftOperandValue).getValue();
            factor = (Number)rightOperandValue.getValue();
        } else if (ExpressionOasisHelper.hasCompositeType(rightOperandValue)) {
            compositeOperand = ((MeasuredValuesCompositeValueObject)rightOperandValue).getValue();
            factor = (Number)leftOperandValue.getValue();
        }
        if (compositeOperand == null) {
            result.add((Double)multiplyExpression.getValue().getValue());
        } else {
            Iterator iterator = compositeOperand.iterator();
            while (iterator.hasNext()) {
                double value = (Double)iterator.next();
                result.add(value * factor.doubleValue());
            }
        }
        return result;
    }

    private Iterable<Double> handleAdd(AddExpression addExpression) throws ExpressionEngineException {
        ArrayList<Double> result = new ArrayList<Double>();
        Object compositeSummand = null;
        Number summand = 0;
        ValueObject leftSummand = addExpression.getLeftOperandExpression().getValue();
        ValueObject rightSummand = addExpression.getRightOperandExpression().getValue();
        if (ExpressionOasisHelper.hasCompositeType(leftSummand)) {
            compositeSummand = ((MeasuredValuesCompositeValueObject)leftSummand).getValue();
            summand = (Number)rightSummand.getValue();
        } else if (ExpressionOasisHelper.hasCompositeType(rightSummand)) {
            compositeSummand = ((MeasuredValuesCompositeValueObject)rightSummand).getValue();
            summand = (Number)leftSummand.getValue();
        }
        if (compositeSummand == null) {
            result.add((Double)addExpression.getValue().getValue());
        } else {
            Iterator iterator = compositeSummand.iterator();
            while (iterator.hasNext()) {
                double value = (Double)iterator.next();
                result.add(value + summand.doubleValue());
            }
        }
        return result;
    }

    private Iterable<Double> handleIdentifier(IdentifierExpression identifierExpression) {
        ValueObject valueObject = null;
        try {
            valueObject = identifierExpression.getValue();
        }
        catch (ExpressionEngineException e) {
            throw new RuntimeException(e);
        }
        if (ExpressionOasisHelper.hasCompositeType(valueObject)) {
            return ((MeasuredValuesCompositeValueObject)valueObject).getValue();
        }
        return Collections.singletonList(Double.valueOf((Double)valueObject.getValue()));
    }
}

