/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter.calculator.expressionoasis.helper;

import de.fzi.power.interpreter.calculator.expressionoasis.custom.CustomExpressionContext;
import de.fzi.power.interpreter.calculator.expressionoasis.custom.MeasuredValuesCompositeValueObject;
import java.util.Objects;
import org.vedantatree.expressionoasis.ExpressionContext;
import org.vedantatree.expressionoasis.types.Type;
import org.vedantatree.expressionoasis.types.ValueObject;

public final class ExpressionOasisHelper {
    private ExpressionOasisHelper() {
    }

    public static boolean hasNumericType(ValueObject valueObject) {
        return ExpressionOasisHelper.isNumericType(Objects.requireNonNull(valueObject).getValueType());
    }

    public static boolean isNumericType(Type type) {
        return ExpressionOasisHelper.typesEqual(type, Type.DOUBLE) || ExpressionOasisHelper.typesEqual(type, Type.INTEGER) || ExpressionOasisHelper.typesEqual(type, Type.LONG) || ExpressionOasisHelper.typesEqual(type, Type.FLOAT) || ExpressionOasisHelper.typesEqual(type, Type.SHORT) || ExpressionOasisHelper.typesEqual(type, Type.BYTE);
    }

    public static boolean typesEqual(Type first, Type second) {
        return Objects.requireNonNull(first).equals((Object)Objects.requireNonNull(second));
    }

    public static boolean hasCompositeType(ValueObject valueObject) {
        return ExpressionOasisHelper.typesEqual(Objects.requireNonNull(valueObject).getValueType(), MeasuredValuesCompositeValueObject.getType());
    }

    public static void assertCorrectExpressionContext(ExpressionContext expressionContext, Class<?> assertingClass) {
        if (!(Objects.requireNonNull(expressionContext) instanceof CustomExpressionContext)) {
            throw new AssertionError((Object)(String.valueOf(assertingClass.getSimpleName()) + " only works with " + CustomExpressionContext.class.getSimpleName() + " instances!"));
        }
    }
}

