/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter.calculators.energy;

import de.fzi.power.interpreter.calculators.energy.AbstractCumulativeEnergyCalculator;
import javax.measure.Measurable;
import javax.measure.quantity.Duration;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Power;
import org.jscience.physics.amount.Amount;

public class SimpsonRuleCumulativeEnergyCalculator
extends AbstractCumulativeEnergyCalculator {
    private static final int INIT_STEPS = 2;
    private static final int REQUIRED_ENERGY_SAMPLES = 2;
    private static final int REQUIRED_POWER_SAMPLES = 3;
    private Amount<Duration> weighting;

    public SimpsonRuleCumulativeEnergyCalculator() {
        super(3, 2, 2);
    }

    public SimpsonRuleCumulativeEnergyCalculator(Measurable<Duration> samplingPeriod, Measurable<Duration> initialOffset) {
        super(3, 2, 2, samplingPeriod, initialOffset);
    }

    @Override
    public void setSamplingPeriod(Measurable<Duration> samplingPeriod) {
        super.setSamplingPeriod(samplingPeriod);
        this.weighting = this.getSamplingPeriod().divide(3L);
    }

    @Override
    protected Amount<Energy> calculateNextInternal() {
        assert (this.getCurrentlyStoredEnergySamplesCount() == 2);
        assert (this.getCurrentlyStoredPowerSamplesCount() == 3);
        Amount<Energy> y_i2 = this.getOldestEnergySample();
        Amount<Power> x_i = this.getMostRecentPowerSample();
        Amount<Power> x_i1 = this.getPowerSample(1);
        Amount<Power> x_i2 = this.getOldestPowerSample();
        return y_i2.plus(this.weighting.times(x_i.plus(x_i1.times(4L)).plus(x_i2)));
    }

    @Override
    protected Amount<Energy> calculateInitValue(int initValueIndex) {
        assert (initValueIndex <= 2);
        assert (this.getCurrentlyStoredPowerSamplesCount() == initValueIndex);
        assert (this.getCurrentlyStoredEnergySamplesCount() == initValueIndex - 1);
        Amount result = null;
        if (initValueIndex == 1) {
            Amount<Duration> initialOffset = this.getInitialOffset();
            if (initialOffset == null) {
                throw new IllegalStateException("This type of energy calculator/integrator needs an initial (time) offset to calculate the first energy sample.");
            }
            result = this.getOldestPowerSample().times(initialOffset).to(this.getResultUnit());
        } else {
            assert (this.getCurrentlyStoredEnergySamplesCount() == 1);
            Amount<Power> x0 = this.getOldestPowerSample();
            Amount<Power> x1 = this.getMostRecentPowerSample();
            Amount<Energy> y0 = this.getMostRecentEnergySample();
            result = y0.plus(this.weighting.times(x1.plus(x0.times(4L))));
        }
        return result;
    }
}

