/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter.calculators.essential;

import de.fzi.power.binding.BindingPackage;
import de.fzi.power.binding.DistributionPowerBinding;
import de.fzi.power.binding.FixedFactorValuePower;
import de.fzi.power.infrastructure.PowerConsumingEntity;
import de.fzi.power.interpreter.calculators.AbstractDistributionPowerModelCalculator;
import de.fzi.power.specification.resources.PowerModelConstants;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.measure.quantity.Power;
import javax.measure.unit.Unit;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.jscience.physics.amount.Amount;

public class LinearPassthroughCalculator
extends AbstractDistributionPowerModelCalculator {
    private Amount<Power> constantLoss;

    public LinearPassthroughCalculator(DistributionPowerBinding binding) {
        super(binding);
        if (!binding.getDistributionPowerModel().getId().equals(PowerModelConstants.LINEAR_PASSTHROUGH_DISTRIBUTION.getId())) {
            throw new IllegalArgumentException("Referred model wasn't the linear power model from" + PowerModelConstants.LINEAR_PASSTHROUGH_DISTRIBUTION.getName() + ".");
        }
        for (FixedFactorValuePower value : EcoreUtil.getObjectsByType((Collection)binding.getFixedFactorValues(), (EClassifier)BindingPackage.eINSTANCE.getFixedFactorValuePower())) {
            if (value.getBoundFactor().getId().equals(PowerModelConstants.LINEAR_PASSTHROUGH_DISTRIBUTION_CONSTANT_LOSS.getId())) {
                Amount valueInAmount;
                Unit unit = value.getValue().getUnit();
                this.constantLoss = valueInAmount = Amount.valueOf((double)value.getValue().doubleValue(unit), (Unit)unit);
                continue;
            }
            throw new IllegalArgumentException("Factor value referred to constant " + value.getBoundFactor().getId() + "that didn't match up with " + PowerModelConstants.LINEAR_PASSTHROUGH_DISTRIBUTION_CONSTANT_LOSS);
        }
        Objects.requireNonNull(this.constantLoss, "FixedFactor '" + PowerModelConstants.LINEAR_PASSTHROUGH_DISTRIBUTION_CONSTANT_LOSS + "' not set!");
    }

    public Amount<Power> calculate(Map<PowerConsumingEntity, Amount<Power>> outletConsumptions) {
        Amount sum = PowerModelConstants.ZERO_POWER;
        for (Amount<Power> power : outletConsumptions.values()) {
            sum = sum.plus(power);
        }
        return sum.minus(this.constantLoss);
    }
}

