/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter.calculators.essential;

import de.fzi.power.binding.BindingPackage;
import de.fzi.power.binding.FixedFactorValuePower;
import de.fzi.power.binding.ResourcePowerBinding;
import de.fzi.power.interpreter.calculators.AbstractResourcePowerModelCalculator;
import de.fzi.power.specification.resources.PowerModelConstants;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.measure.Measure;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Power;
import javax.measure.unit.Unit;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;

public class NonlinearRegressionCalculator
extends AbstractResourcePowerModelCalculator {
    private Amount<Power> minimumPower;
    private Amount<Power> maximumPower;
    private Amount<Dimensionless> exponent;
    private static final MetricDescription utilMetric = MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE;

    public NonlinearRegressionCalculator(ResourcePowerBinding binding) {
        super(binding);
        if (!binding.getResourcePowerModelSpecification().getId().equals(PowerModelConstants.NONLINEAR_REGRESSION_MODEL.getId())) {
            throw new IllegalArgumentException("Referred model wasn't the non-linear regression power model from" + PowerModelConstants.NONLINEAR_REGRESSION_MODEL.eResource().getURI() + ".");
        }
        for (FixedFactorValuePower value : EcoreUtil.getObjectsByType((Collection)binding.getFixedFactorValues(), (EClassifier)BindingPackage.eINSTANCE.getFixedFactorValuePower())) {
            String boundFactorId = value.getBoundFactor().getId();
            Unit unit = value.getValue().getUnit();
            Amount valueInAmount = Amount.valueOf((double)value.getValue().doubleValue(unit), (Unit)unit);
            if (boundFactorId.equals(PowerModelConstants.NONLINEAR_REGRESSION_MODEL_MIN_CONSUMPTION.getId())) {
                this.minimumPower = valueInAmount;
                continue;
            }
            if (boundFactorId.equals(PowerModelConstants.NONLINEAR_REGRESSION_MODEL_MAX_CONSUMPTION.getId())) {
                this.maximumPower = valueInAmount;
                continue;
            }
            if (boundFactorId.equals(PowerModelConstants.NONLINEAR_REGRESSION_MODEL_EXPONENT.getId())) {
                this.exponent = valueInAmount;
                continue;
            }
            throw new IllegalArgumentException("One of the factor values wasn't a min or max consumption value.");
        }
    }

    public Amount<Power> calculate(Collection<MeasuringValue> measurements) {
        NonlinearRegressionCalculator.checkMeasurementConsistency(measurements);
        Measure utilization = measurements.iterator().next().getMeasureForMetric(utilMetric);
        Amount utilAmount = Amount.valueOf((double)((Double)utilization.getValue()), (Unit)utilization.getUnit());
        return this.minimumPower.plus(this.maximumPower.minus(this.minimumPower).times(utilAmount.times(2L).minus(utilAmount).pow((int)this.exponent.longValue(Dimensionless.UNIT))));
    }

    public Set<MetricDescription> getInputMetrics() {
        return Collections.singleton(utilMetric);
    }

    private static void checkMeasurementConsistency(Collection<MeasuringValue> measurements) {
        if (measurements != null && measurements.size() == 1) {
            measurements.iterator().next().getMeasureForMetric(utilMetric);
        }
    }
}

