/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter.calculators.essential;

import de.fzi.power.binding.BindingPackage;
import de.fzi.power.binding.FixedFactorValuePower;
import de.fzi.power.binding.ResourcePowerBinding;
import de.fzi.power.interpreter.calculators.AbstractResourcePowerModelCalculator;
import de.fzi.power.specification.resources.PowerModelConstants;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.measure.Measure;
import javax.measure.quantity.Power;
import javax.measure.unit.Unit;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;

public class LinearPowerModelCalculator
extends AbstractResourcePowerModelCalculator {
    private Amount<Power> maximumPower;
    private Amount<Power> minimumPower;
    private static final MetricDescription UTIL_METRIC = MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE;
    private final Amount<Power> powerDifference;

    public LinearPowerModelCalculator(ResourcePowerBinding binding) {
        super(binding);
        if (!binding.getResourcePowerModelSpecification().getId().equals(PowerModelConstants.LINEAR_POWER_MODEL.getId())) {
            throw new IllegalArgumentException("Referred model wasn't the linear power model from" + PowerModelConstants.LINEAR_POWER_MODEL.eResource().getURI() + ".");
        }
        for (FixedFactorValuePower value : EcoreUtil.getObjectsByType((Collection)binding.getFixedFactorValues(), (EClassifier)BindingPackage.eINSTANCE.getFixedFactorValuePower())) {
            String boundFactorId = value.getBoundFactor().getId();
            Unit unit = value.getValue().getUnit();
            Amount valueInAmount = Amount.valueOf((double)value.getValue().doubleValue(unit), (Unit)unit);
            if (boundFactorId.equals(PowerModelConstants.LINEAR_POWER_MODEL_MIN_CONSUMPTION.getId())) {
                this.minimumPower = valueInAmount;
                continue;
            }
            if (boundFactorId.equals(PowerModelConstants.LINEAR_POWER_MODEL_MAX_CONSUMPTION.getId())) {
                this.maximumPower = valueInAmount;
                continue;
            }
            throw new IllegalArgumentException("One of the factor values wasn't a min or max consumption value.");
        }
        this.powerDifference = this.maximumPower.minus(this.minimumPower);
    }

    public Amount<Power> calculate(Collection<MeasuringValue> measurements) {
        Amount<Power> result = null;
        result = Objects.requireNonNull(measurements, "Passed collection of measurements must not be null!").isEmpty() ? this.minimumPower : this.calculateInternal(measurements);
        return result;
    }

    private Amount<Power> calculateInternal(Collection<MeasuringValue> measurements) {
        assert (measurements != null);
        MeasuringValue firstMeasurement = measurements.iterator().next();
        if (!MetricDescriptionUtility.isBaseMetricDescriptionSubsumedByMetricDescription((BaseMetricDescription)((BaseMetricDescription)UTIL_METRIC), (MetricDescription)firstMeasurement.getMetricDesciption())) {
            throw new IllegalArgumentException("Linear power model expects measurements of type MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE");
        }
        Measure utilization = measurements.iterator().next().getMeasureForMetric(UTIL_METRIC);
        Amount utilAmount = Amount.valueOf((double)((Double)utilization.getValue()), (Unit)utilization.getUnit());
        return this.minimumPower.plus(utilAmount.times(this.powerDifference));
    }

    public Set<MetricDescription> getInputMetrics() {
        return Collections.singleton(UTIL_METRIC);
    }
}

