/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter.measureprovider.utilization.ui;

import de.fzi.power.ui.views.configuration.ExtendedMeasureProviderConfigurationUI;
import java.util.Map;
import java.util.Vector;
import javax.measure.Measure;
import javax.measure.MeasureFormat;
import javax.measure.quantity.Duration;
import javax.measure.unit.Unit;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.commons.datastructureutils.MapHelper;

public class UtilizationFilterConfigurationTab
extends ExtendedMeasureProviderConfigurationUI {
    private Control control = null;
    private Vector<String> errorMessages;
    private Text windowLengthText;
    private Text windowSizeText;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.control = composite;
        composite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(2, false));
        this.windowLengthText = new Text(composite, 2048);
        this.windowLengthText.setToolTipText("Defines the window length over which utilization is determined with a time unit that needs to be specified.");
        Label labelLength = new Label(composite, 0);
        labelLength.setText("Sliding Window Length");
        this.windowSizeText = new Text(composite, 2048);
        this.windowSizeText.setToolTipText("Defines the sliding window step size over which utilization is determined with a time unit that needs to be specified.");
        Label labelSteps = new Label(composite, 0);
        labelSteps.setText("Sliding Window Step Size");
    }

    public void initializeFrom(Map<String, Object> configuration) {
        if (configuration.containsKey("windowIncrement")) {
            Measure incrementMeasure = (Measure)MapHelper.getValue(configuration, (String)"windowIncrement", Measure.class);
            this.windowSizeText.setText(MeasureFormat.getInstance().format((Object)incrementMeasure));
        }
        if (configuration.containsKey("windowLength")) {
            Measure lengthMeasure = (Measure)MapHelper.getValue(configuration, (String)"windowLength", Measure.class);
            this.windowLengthText.setText(MeasureFormat.getInstance().format((Object)lengthMeasure));
        }
    }

    public void performApply(Map<String, Object> configuration) {
        Amount<Duration> windowLength = this.getWindowLength();
        Measure lengthMeasure = Measure.valueOf((double)windowLength.getEstimatedValue(), (Unit)windowLength.getUnit());
        Amount<Duration> windowSize = this.getWindowSize();
        Measure sizeMeasure = Measure.valueOf((double)windowSize.getEstimatedValue(), (Unit)windowSize.getUnit());
        configuration.put("windowIncrement", sizeMeasure);
        configuration.put("windowLength", lengthMeasure);
    }

    public String getErrorMessage() {
        if (this.errorMessages.size() == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String s : this.errorMessages) {
            builder.append(s);
            builder.append("\n");
        }
        return builder.toString();
    }

    public boolean isValid() {
        this.errorMessages = new Vector();
        boolean result = true;
        Amount<Duration> windowLength = this.getWindowLength();
        if (windowLength == null) {
            this.errorMessages.add("The window length must be set as an amount of time with its unit, e.g. '10s'");
            result = false;
        } else if (windowLength.getEstimatedValue() < 0.0) {
            this.errorMessages.add("The window length must be positive, e.g. '10s'");
            result = false;
        }
        Amount<Duration> windowSize = this.getWindowSize();
        if (windowSize == null) {
            this.errorMessages.add("The window increment must be set as an amount of time with its unit, e.g. '10s'");
            result = false;
        } else if (windowSize.getEstimatedValue() < 0.0) {
            this.errorMessages.add("The window increment must be positive, e.g. '10s'");
            result = false;
        }
        return result && super.isValid();
    }

    public String getName() {
        return "Utilization Filter";
    }

    protected Amount<Duration> getWindowSize() {
        Amount windowSize = null;
        try {
            Amount input;
            windowSize = input = Amount.valueOf((CharSequence)this.windowSizeText.getText());
        }
        catch (ClassCastException classCastException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        return windowSize;
    }

    protected Amount<Duration> getWindowLength() {
        Amount windowLength = null;
        try {
            Amount input;
            windowLength = input = Amount.valueOf((CharSequence)this.windowLengthText.getText());
        }
        catch (ClassCastException classCastException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        return windowLength;
    }

    public Control getControl() {
        return this.control;
    }
}

