/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.power.interpreter;

import de.fzi.power.infrastructure.AbstractPowerConsumingResource;
import de.fzi.power.infrastructure.MountedPowerDistributionUnit;
import de.fzi.power.infrastructure.PowerConsumingEntity;
import de.fzi.power.infrastructure.PowerConsumingProvidingEntity;
import de.fzi.power.infrastructure.PowerConsumingResourceSet;
import de.fzi.power.infrastructure.PowerDistributionUnit;
import de.fzi.power.infrastructure.PowerInfrastructureRepository;
import de.fzi.power.infrastructure.PowerProvidingEntity;
import de.fzi.power.infrastructure.StatefulPowerConsumingResourceSet;
import de.fzi.power.infrastructure.util.InfrastructureSwitch;
import de.fzi.power.interpreter.ConsumptionContext;
import de.fzi.power.specification.resources.PowerModelConstants;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.measure.quantity.Power;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.jscience.physics.amount.Amount;

public final class PowerConsumptionSwitch
extends InfrastructureSwitch<Amount<Power>> {
    private ConsumptionContext consumptionContext;

    private PowerConsumptionSwitch() {
    }

    public static PowerConsumptionSwitch createPowerConsumptionSwitch(ConsumptionContext ctx) {
        PowerConsumptionSwitch consumptionSwitch = new PowerConsumptionSwitch();
        consumptionSwitch.setConsumptionContext(ctx);
        return consumptionSwitch;
    }

    public void setConsumptionContext(ConsumptionContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("ConsumptionContext must not be null.");
        }
        this.consumptionContext = ctx;
    }

    public Amount<Power> casePowerDistributionUnit(PowerDistributionUnit pdu) {
        return this.casePowerConsumingProvidingEntity((PowerConsumingProvidingEntity)pdu);
    }

    public Amount<Power> casePowerConsumingProvidingEntity(PowerConsumingProvidingEntity providingConsumingEntity) {
        EList consumingEntities = Objects.requireNonNull(providingConsumingEntity).getNestedPowerConsumingEntities();
        Map<PowerConsumingEntity, Amount<Power>> consumers = consumingEntities.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ((PowerConsumptionSwitch)this).doSwitch(arg_0)));
        return this.consumptionContext.evaluateDistributionPowerConsumption(providingConsumingEntity, consumers);
    }

    public Amount<Power> casePowerProvidingEntity(PowerProvidingEntity ppEntity) {
        return (Amount)this.doSwitch((EObject)ppEntity);
    }

    public Amount<Power> casePowerConsumingEntity(PowerConsumingEntity powerConsumingEntity) {
        return (Amount)this.doSwitch((EObject)powerConsumingEntity);
    }

    public Amount<Power> caseMountedPowerDistributionUnit(MountedPowerDistributionUnit mountedPdu) {
        return this.casePowerDistributionUnit((PowerDistributionUnit)mountedPdu);
    }

    public Amount<Power> casePowerConsumingResourceSet(PowerConsumingResourceSet resource) {
        return this.consumptionContext.evaluateResourcePowerConsumption((AbstractPowerConsumingResource)resource);
    }

    public Amount<Power> caseStatefulPowerConsumingResourceSet(StatefulPowerConsumingResourceSet resource) {
        return this.consumptionContext.evaluateStatefulResourcePowerConsumption(resource);
    }

    public Amount<Power> casePowerInfrastructureRepository(PowerInfrastructureRepository piModel) {
        return Objects.requireNonNull(piModel).getContainedPowerProvidingEntities().stream().map(this::casePowerProvidingEntity).reduce(PowerModelConstants.ZERO_POWER, Amount::plus);
    }
}

